/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.action.course;

import com.atlassian.confluence.user.actions.AbstractUserProfileAction;
import com.stiltsoft.confluence.quiz.entity.MailParams;
import com.stiltsoft.confluence.quiz.entity.course.CourseMetadata;
import com.stiltsoft.confluence.quiz.entity.course.UserCourse;
import com.stiltsoft.confluence.quiz.manager.CourseReportHelper;
import com.stiltsoft.confluence.quiz.manager.LicenseManager;
import com.stiltsoft.confluence.quiz.manager.QuizPageManager;
import com.stiltsoft.confluence.quiz.manager.UserEntityService;
import java.util.List;

public class CoursesAction
extends AbstractUserProfileAction {
    private LicenseManager licenseManager;
    private QuizPageManager quizPageManager;
    private UserEntityService userEntityService;
    private CourseReportHelper courseReportHelper;

    public void setLicenseManager(LicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public void setQuizPageManager(QuizPageManager quizPageManager) {
        this.quizPageManager = quizPageManager;
    }

    public void setUserEntityService(UserEntityService userEntityService) {
        this.userEntityService = userEntityService;
    }

    public void setCourseReportHelper(CourseReportHelper courseReportHelper) {
        this.courseReportHelper = courseReportHelper;
    }

    public String doDefault() throws Exception {
        return "success";
    }

    public List<UserCourse> getCourses() throws Exception {
        return this.courseReportHelper.getUserCourses(this.getUser());
    }

    public boolean isLicensed() {
        return this.licenseManager.isActive();
    }

    public String getImageTagWithHtml(CourseMetadata courseMetadata) throws Exception {
        String userKey = this.getAuthenticatedUser().getKey().getStringValue();
        MailParams params = new MailParams(courseMetadata.getCourseId(), this.userEntityService.getUserId(userKey), -1, userKey, -1);
        String imgTag = "<img class=\"course-image\" src=\"" + this.getCurrentRequest().getContextPath() + courseMetadata.getImageUrl() + "\">";
        return this.quizPageManager.extractAttachments(imgTag, params, params.getQid());
    }
}

