/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.action.course;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.base.Joiner;
import com.stiltsoft.confluence.quiz.action.DefaultAction;
import com.stiltsoft.confluence.quiz.ao.entity.course.CourseModule;
import com.stiltsoft.confluence.quiz.ao.entity.course.CourseSettings;
import com.stiltsoft.confluence.quiz.ao.entity.course.CourseStateEntity;
import com.stiltsoft.confluence.quiz.ao.service.course.CourseSettingsService;
import com.stiltsoft.confluence.quiz.ao.service.course.CourseStateEntityService;
import com.stiltsoft.confluence.quiz.ao.service.course.DefaultCourseModuleService;
import com.stiltsoft.confluence.quiz.entity.MailParams;
import com.stiltsoft.confluence.quiz.entity.course.CourseEnrollWrapper;
import com.stiltsoft.confluence.quiz.entity.course.CourseParticipantStats;
import com.stiltsoft.confluence.quiz.entity.course.CourseTreeItem;
import com.stiltsoft.confluence.quiz.manager.CourseReportHelper;
import com.stiltsoft.confluence.quiz.manager.QuizPageManager;
import com.stiltsoft.confluence.quiz.utils.DueDateHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class CourseAction
extends DefaultAction {
    private CourseEnrollWrapper courseEnrollWrapper;
    private Page page;
    private CourseParticipantStats stats;
    private CourseStateEntityService courseStateEntityService;
    private PageManager pageManager;
    private CourseSettingsService courseSettingsService;
    private CourseReportHelper reportHelper;
    private QuizPageManager quizPageManager;
    private WikiStyleRenderer wikiStyleRenderer;
    private DueDateHelper dueDateHelper;
    private SoyTemplateRenderer soyRenderer;

    public void setCourseStateEntityService(CourseStateEntityService courseStateEntityService) {
        this.courseStateEntityService = courseStateEntityService;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setCourseSettingsService(CourseSettingsService courseSettingsService) {
        this.courseSettingsService = courseSettingsService;
    }

    public void setReportHelper(CourseReportHelper reportHelper) {
        this.reportHelper = reportHelper;
    }

    public void setQuizPageManager(QuizPageManager quizPageManager) {
        this.quizPageManager = quizPageManager;
    }

    public void setWikiStyleRenderer(WikiStyleRenderer wikiStyleRenderer) {
        this.wikiStyleRenderer = wikiStyleRenderer;
    }

    public void setDueDateHelper(DueDateHelper dueDateHelper) {
        this.dueDateHelper = dueDateHelper;
    }

    public void setSoyRenderer(SoyTemplateRenderer soyRenderer) {
        this.soyRenderer = soyRenderer;
    }

    public String doDefault() throws Exception {
        MailParams params = this.getParam();
        if (params == null || this.userEntityService.getUserId(params.getKey()) != params.getUid().intValue()) {
            return "error";
        }
        this.page = this.pageManager.getPage(this.getParam().getQid().longValue());
        if (this.page == null || this.page.isDeleted()) {
            return "deleted";
        }
        Optional<CourseEnrollWrapper> wrapperOpt = this.courseStateEntityService.getCourseEnrollWrapper(params.getUid(), params.getQid(), params.getRid());
        if (!wrapperOpt.isPresent()) {
            return "cancelled";
        }
        this.courseEnrollWrapper = wrapperOpt.get();
        if (this.courseEnrollWrapper.getStatus() == 4) {
            return "overdue";
        }
        String[] startParam = this.getParams().get("start");
        if (startParam != null && "start".equals(startParam[0]) && !this.isReadOnlyMode()) {
            Optional<CourseEnrollWrapper> startedEntityOpt = this.courseStateEntityService.start(params.getUid(), params.getQid(), params.getRid());
            startedEntityOpt.ifPresent(startedCourseEnrollWrapper -> {
                this.courseEnrollWrapper = startedCourseEnrollWrapper;
            });
        }
        this.stats = this.reportHelper.getStat(this.courseEnrollWrapper);
        if (this.courseEnrollWrapper.getStatus() == 0 || startParam != null && "view".equals(startParam[0])) {
            return "start";
        }
        return "success";
    }

    public Page getPage() {
        return this.page;
    }

    public CourseSettings getSettings() {
        return this.courseSettingsService.getOrCreate(this.courseEnrollWrapper.getCourseId());
    }

    public CourseStateEntity getEntity() {
        return this.courseEnrollWrapper.getEntity();
    }

    public CourseParticipantStats getStats() {
        return this.stats;
    }

    public SoyTemplateRenderer getSoyRenderer() {
        return this.soyRenderer;
    }

    public String getDueDate() {
        return StringUtils.defaultString((String)this.dueDateHelper.formatDueDate(this.courseEnrollWrapper.getDueDate()));
    }

    public String getImageWithHtml(String imgTag) throws Exception {
        MailParams params = this.getParam();
        return this.quizPageManager.extractAttachments(imgTag, params, params.getQid());
    }

    public String getActiveModules() {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (CourseModule module : this.courseEnrollWrapper.getCourseModules()) {
            ids.add(module.getModuleId());
        }
        return Joiner.on((char)',').join(ids);
    }

    public boolean canProceed() {
        return this.lookForFailedQuiz(this.stats.getCourseTree());
    }

    public String convertWikiToHtml(String text) {
        return this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)new PageContext((ContentEntityObject)this.page), text);
    }

    private boolean lookForFailedQuiz(List<CourseTreeItem> items) {
        for (CourseTreeItem item : items) {
            if (!(item.getType() == DefaultCourseModuleService.QUIZ_MODULE.intValue() ? item.getQuizState() != null && item.getQuizState().equals((Object)CourseTreeItem.QuizState.FAIL) : !this.lookForFailedQuiz(item.getItems()))) continue;
            return false;
        }
        return true;
    }
}

