/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.action;

import com.atlassian.confluence.compat.api.service.accessmode.AccessModeCompatService;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.web.context.StaticHttpContext;
import com.atlassian.sal.api.user.UserKey;
import com.stiltsoft.confluence.quiz.ao.entity.UserEntity;
import com.stiltsoft.confluence.quiz.ao.entity.quiz.QuizStateEntity;
import com.stiltsoft.confluence.quiz.ao.service.quiz.QuizService;
import com.stiltsoft.confluence.quiz.entity.MailParams;
import com.stiltsoft.confluence.quiz.manager.CQPermissionHelper;
import com.stiltsoft.confluence.quiz.manager.UserEntityService;
import com.stiltsoft.confluence.quiz.utils.QuizEncrypter;
import java.util.Map;

public class DefaultAction
extends ConfluenceActionSupport {
    protected static final String DELETED_TEMPLATE = "deleted";
    protected static final String OVERDUE_TEMPLATE = "overdue";
    protected static final String START_TEMPLATE = "start";
    protected static final String CANCELLED_TEMPLATE = "cancelled";
    protected CQPermissionHelper cqPermissionHelper;
    protected QuizService quizService;
    protected UserEntityService userEntityService;
    protected UserAccessor userAccessor;
    protected AccessModeCompatService accessModeCompatService;

    public void setQuizService(QuizService quizService) {
        this.quizService = quizService;
    }

    public void setUserEntityService(UserEntityService userEntityService) {
        this.userEntityService = userEntityService;
    }

    public void setCqPermissionHelper(CQPermissionHelper cqPermissionHelper) {
        this.cqPermissionHelper = cqPermissionHelper;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public void setAccessModeCompatService(AccessModeCompatService accessModeCompatService) {
        this.accessModeCompatService = accessModeCompatService;
    }

    public boolean isPermitted() {
        try {
            MailParams params = this.getParam();
            return this.cqPermissionHelper.isUserAuthorized(params);
        }
        catch (Exception e) {
            return true;
        }
    }

    protected MailParams getParam() throws Exception {
        String[] param = this.getParams().get("qsd");
        if (param == null) {
            return null;
        }
        return QuizEncrypter.decrypt(param[0]);
    }

    public String getUrlParam(String name) {
        String[] param = this.getParams().get(name);
        if (param == null) {
            return null;
        }
        return GeneralUtil.urlEncode((String)param[0]);
    }

    public Map<String, String[]> getParams() {
        return new StaticHttpContext().getRequest().getParameterMap();
    }

    public boolean isReadOnlyMode() {
        return this.accessModeCompatService.isReadOnlyAccessModeEnabled();
    }

    public String getUserName(QuizStateEntity stateEntity) {
        UserEntity userEntity = this.userEntityService.getUser(stateEntity.getUserId());
        if (userEntity.getExternal().booleanValue()) {
            return userEntity.getKey();
        }
        return this.userAccessor.getUserByKey(new UserKey(userEntity.getKey())).getFullName();
    }

    protected ConfluenceUser getAuthor(QuizStateEntity entity) {
        return this.getAuthor(entity.getAuthor());
    }

    protected ConfluenceUser getAuthor(Integer authorId) {
        UserEntity userEntity = this.userEntityService.getUser(authorId);
        return this.userAccessor.getUserByKey(new UserKey(userEntity.getKey()));
    }

    protected QuizStateEntity getStateEntity(MailParams params) {
        Map<String, String[]> queryParams = this.getParams();
        if (queryParams.get("oldAttempt") != null && "true".equals(queryParams.get("oldAttempt")[0])) {
            return this.getOldStateEntity(params);
        }
        return this.quizService.getStateTx(params.getUid(), params.getQid(), params.getAid(), params.getRid());
    }

    protected QuizStateEntity getOldStateEntity(MailParams params) {
        QuizStateEntity entity = this.quizService.getStateTx(params.getRid());
        if (!(entity.getUserId().equals(params.getUid()) && entity.getQuizId().equals(params.getQid()) && entity.getAuthor().equals(params.getAid()))) {
            return null;
        }
        return entity;
    }
}

