"use strict";
(self["webpackChunkhandy_macros_server"] = self["webpackChunkhandy_macros_server"] || []).push([["status-timestamp-view"],{

/***/ "./src/main/frontend/api/utils.ts":
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.boolFromString = void 0;
var boolFromString = function (string) {
    return string === 'true';
};
exports.boolFromString = boolFromString;


/***/ }),

/***/ "./src/main/frontend/macro/status-timestamp/components/StatusTimestamp.tsx":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var react_1 = __importDefault(__webpack_require__("./node_modules/react/index.js"));
var WarningIconNoLicense_1 = __importDefault(__webpack_require__("./src/main/frontend/shared/components/icons/WarningIconNoLicense.tsx"));
var InlineMessageStatusMacroIdChanged_1 = __importDefault(__webpack_require__("./src/main/frontend/macro/status-timestamp/components/messages/InlineMessageStatusMacroIdChanged.tsx"));
var InlineMessageNoLicense_1 = __importDefault(__webpack_require__("./src/main/frontend/macro/status-timestamp/components/messages/InlineMessageNoLicense.tsx"));
var StatusTimestamp = function (_a) {
    var statusTimestamp = _a.statusTimestamp, licensed = _a.licensed;
    if (!statusTimestamp && licensed) {
        return react_1.default.createElement(InlineMessageStatusMacroIdChanged_1.default, null);
    }
    else if (!statusTimestamp && !licensed) {
        return react_1.default.createElement(InlineMessageNoLicense_1.default, null);
    }
    else if (statusTimestamp && !licensed) {
        return (react_1.default.createElement(react_1.default.Fragment, null,
            react_1.default.createElement(WarningIconNoLicense_1.default, null),
            statusTimestamp));
    }
    return react_1.default.createElement(react_1.default.Fragment, null, statusTimestamp);
};
exports["default"] = StatusTimestamp;


/***/ }),

/***/ "./src/main/frontend/macro/status-timestamp/components/messages/InlineMessageNoLicense.tsx":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var react_1 = __importDefault(__webpack_require__("./node_modules/react/index.js"));
var inline_message_1 = __importDefault(__webpack_require__("./node_modules/@atlaskit/inline-message/dist/esm/index.js"));
var InlineMessageNoLicense = function () { return (react_1.default.createElement(inline_message_1.default, { appearance: "warning", title: AJS.I18n.getText('handy.macros.macro.status-timestamp.status.macro.id.changed.title') }, AJS.I18n.getText('handy.macros.license.fail.simple'))); };
exports["default"] = InlineMessageNoLicense;


/***/ }),

/***/ "./src/main/frontend/macro/status-timestamp/components/messages/InlineMessageStatusMacroIdChanged.tsx":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var react_1 = __importDefault(__webpack_require__("./node_modules/react/index.js"));
var inline_message_1 = __importDefault(__webpack_require__("./node_modules/@atlaskit/inline-message/dist/esm/index.js"));
var InlineMessageStatusMacroIdChanged = function () { return (react_1.default.createElement(inline_message_1.default, { title: AJS.I18n.getText('handy.macros.macro.status-timestamp.status.macro.id.changed.title'), appearance: "warning" }, AJS.I18n.getText('handy.macros.macro.status-timestamp.status.macro.id.changed'))); };
exports["default"] = InlineMessageStatusMacroIdChanged;


/***/ }),

/***/ "./src/main/frontend/macro/status-timestamp/status-timestamp-service.ts":
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getStatusTimestamp = void 0;
var getStatusTimestamp = function (statusMacroId, format) { return new Promise(function (resolve, reject) {
    var contentId = AJS.Meta.get('content-id');
    $.ajax({
        url: Confluence.getContextPath() + '/rest/handy-macros/2.0/status-timestamp',
        data: {
            statusMacroId: statusMacroId,
            format: format,
            contentId: contentId,
        },
        success: function (data) { return resolve(data.statusTimestamp); },
        error: function (err) { return reject(err); },
    });
}); };
exports.getStatusTimestamp = getStatusTimestamp;


/***/ }),

/***/ "./src/main/frontend/macro/status-timestamp/status-timestamp-view.tsx":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var react_1 = __importDefault(__webpack_require__("./node_modules/react/index.js"));
var react_dom_1 = __importDefault(__webpack_require__("./node_modules/react-dom/index.js"));
var StatusTimestamp_1 = __importDefault(__webpack_require__("./src/main/frontend/macro/status-timestamp/components/StatusTimestamp.tsx"));
var status_timestamp_service_1 = __webpack_require__("./src/main/frontend/macro/status-timestamp/status-timestamp-service.ts");
var utils_1 = __webpack_require__("./src/main/frontend/api/utils.ts");
var HANDY_STATUS_CHANGED_EVENT = 'handy-status-changed';
var TABLE_JOINER_EXECUTED_EVENT = 'tj-executed';
var renderStatusTimestamps = function () {
    var timestampRoots = getStatusTimestampRootElements($(document));
    timestampRoots.forEach(function (root) { return renderStatusTimestamp(root); });
};
var renderStatusTimestamp = function (root) {
    var _a = root.dataset, statusTimestamp = _a.statusTimestamp, licensed = _a.licensed;
    react_dom_1.default.render(react_1.default.createElement(StatusTimestamp_1.default, { statusTimestamp: statusTimestamp, licensed: (0, utils_1.boolFromString)(licensed) }), root);
};
var onStatusChange = function (event) { return __awaiter(void 0, void 0, void 0, function () {
    var oldStatusMacroId, currentStatusMacroId, timestampRoots, _i, timestampRoots_1, timestampRoot, format, _a;
    var _b, _c;
    return __generator(this, function (_d) {
        switch (_d.label) {
            case 0:
                oldStatusMacroId = (_b = event.detail) === null || _b === void 0 ? void 0 : _b.oldId;
                currentStatusMacroId = (_c = event.detail) === null || _c === void 0 ? void 0 : _c.currentId;
                if (!oldStatusMacroId || !currentStatusMacroId) {
                    console.log('No statusMacroId value');
                    return [2 /*return*/];
                }
                if (oldStatusMacroId !== currentStatusMacroId) {
                    updateRootElementsStatusMacroId(oldStatusMacroId, currentStatusMacroId);
                }
                timestampRoots = getOriginalStatusTimestampRootElementsById(currentStatusMacroId);
                _i = 0, timestampRoots_1 = timestampRoots;
                _d.label = 1;
            case 1:
                if (!(_i < timestampRoots_1.length)) return [3 /*break*/, 5];
                timestampRoot = timestampRoots_1[_i];
                format = timestampRoot.dataset.format;
                if (!!format) return [3 /*break*/, 2];
                console.log('No format value in dataset for root: ', timestampRoot);
                return [3 /*break*/, 4];
            case 2:
                _a = timestampRoot.dataset;
                return [4 /*yield*/, (0, status_timestamp_service_1.getStatusTimestamp)(currentStatusMacroId, format)];
            case 3:
                _a.statusTimestamp = _d.sent();
                renderStatusTimestamp(timestampRoot);
                _d.label = 4;
            case 4:
                _i++;
                return [3 /*break*/, 1];
            case 5: return [2 /*return*/];
        }
    });
}); };
var renderStatusTimestampsInTableJoiner = function () {
    var copiesContainers = getTableTransformerCopiesContainers();
    removeRedundantInlineMessageElements(copiesContainers);
    var rootElementsCopies = getStatusTimestampRootElements(copiesContainers);
    rootElementsCopies.forEach(function (rootElement) { return renderStatusTimestamp(rootElement); });
};
var getTableTransformerCopiesContainers = function () { return $('.table-joiner .wrapper'); };
var getInlineMessageElements = function (parents) {
    var buttons = parents.find('button[data-ds--inline-message--button="true"]');
    var buttonParents = buttons.parent();
    return buttonParents.get();
};
var removeRedundantInlineMessageElements = function (parents) {
    var redundantInlineMessages = getInlineMessageElements(parents);
    redundantInlineMessages.forEach(function (inlineMessage) { return inlineMessage.remove(); });
};
var getStatusTimestampRootElements = function (parents) {
    return parents.find('.handy-status-timestamp').get();
};
var getOriginalStatusTimestampRootElementsById = function (statusMacroId) {
    return $("[data-status-macro-id=\"".concat(statusMacroId, "\"]"))
        .not(".table-joiner .wrapper [data-status-macro-id=\"".concat(statusMacroId, "\"]")).get();
};
var updateRootElementsStatusMacroId = function (oldStatusMacroId, currentStatusMacroId) {
    return getOriginalStatusTimestampRootElementsById(oldStatusMacroId)
        .forEach(function (element) { return element.dataset.statusMacroId = currentStatusMacroId; });
};
$(document).on('DOMContentLoaded', renderStatusTimestamps);
$(document).on(HANDY_STATUS_CHANGED_EVENT, onStatusChange);
$(document).on(TABLE_JOINER_EXECUTED_EVENT, renderStatusTimestampsInTableJoiner);


/***/ }),

/***/ "./src/main/frontend/shared/components/icons/WarningIconNoLicense.tsx":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __makeTemplateObject = (this && this.__makeTemplateObject) || function (cooked, raw) {
    if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
    return cooked;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var react_1 = __importDefault(__webpack_require__("./node_modules/react/index.js"));
var styled_1 = __importDefault(__webpack_require__("./node_modules/@emotion/styled/dist/emotion-styled.browser.esm.js"));
var WarningIconNoLicense = function () { return (react_1.default.createElement(WarningIcon, { className: "aui-icon aui-icon-small aui-iconfont-warning", title: AJS.I18n.getText('handy.macros.license.fail.simple') })); };
var WarningIcon = styled_1.default.span(templateObject_1 || (templateObject_1 = __makeTemplateObject(["\n  color: #f6c342;\n  padding-right: 5px;\n"], ["\n  color: #f6c342;\n  padding-right: 5px;\n"])));
exports["default"] = WarningIconNoLicense;
var templateObject_1;


/***/ })

},
/******/ __webpack_require__ => { // webpackRuntimeModules
/******/ var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
/******/ __webpack_require__.O(0, ["vendors-node_modules_atlaskit_analytics-next-stable-react-context_dist_esm_index_js-node_modu-3ab870","vendors-node_modules_bind-event-listener_dist_index_js-node_modules_prop-types_index_js-node_-a57af8","vendors-node_modules_atlaskit_inline-message_dist_esm_index_js"], () => (__webpack_exec__("./src/main/frontend/macro/status-timestamp/status-timestamp-view.tsx")));
/******/ var __webpack_exports__ = __webpack_require__.O();
/******/ }
]);