
require([
        "ajs",
        "jquery",
        'stiltsoft/handy-macros/analytics',
        'stiltsoft/handy-macros/analytics/settings',
        'stiltsoft/handy-macros/analytics/client'
    ],
    function (AJS, $, Analytics, AnalyticsSettings, AnalyticsClient) {

    AJS.toInit(function() {
        initSets();
        initStatuses();
        initToolsSettings();
        $('tr.set .set-container').first().click();
        AnalyticsSettings.init();
        Analytics.createConsentMessage();

    });

    function initSets() {
        var setInput = $('#set-name').focus();
        var addSetBtn = $('#add-set');
        var loader = $('#set-add-row .aui-icon-wait');
        var body = $('#set-body');
        var messageContainer = $('#handy-status-message');

        var getSetsByName = function(name) {
            return $('.set-name-view').filter(function() {
                return $(this).text().trim().toLocaleLowerCase() === name.toLocaleLowerCase();
            });
        };

        setInput.bind('input', function() {
            var name = setInput.val().trim();
            if (name && getSetsByName(name).length === 0) {
                addSetBtn.prop('disabled', false);
            } else {
                addSetBtn.prop('disabled', true);
            }
        }).bind('keyup', function(e) {
            if (e.which == 13) {
                addSetBtn.click();
                return false;
            }
        });

        addSetBtn.click(function() {
            $('#status-name').focus();
            addSetBtn.prop('disabled', true);
            loader.show();
            $.ajax({
                contentType: "application/x-www-form-urlencoded; charset=utf-8",
                type: 'POST',
                cache: false,
                url: Confluence.getContextPath() + '/rest/handy-macros/2.0/status-macro/settings/sets',
                data: {
                    name: setInput.val().trim(),
                    owner: body.data('owner')
                },
                dataType: 'json',
                success: function(statusSet) {
                    body.append(StatusSettings.set({id: statusSet.id, setName: setInput.val()}));
                    setInput.val('');
                    $('tr.set .set-container').last().click();
                    updateMacroBrowser();
                },
                error: function(xhr) {
                    addSetBtn.prop('disabled', false);
                    showError(xhr);
                },
                complete: function() {
                    loader.hide();
                }
            });

            return false;
        });

        $('.handy-status-set-settings').on('keyup change paste cut', '.set-name-input', function(e) {
            var input = $(this);
            var tr = input.parents('tr').first();
            var btn = tr.find('.set-edit-save');
            var name = input.val().trim();
            if (name && getSetsByName(name).not('#' + tr.attr('id') + ' .set-name-view').length == 0) {
                btn.prop('disabled', false);
            } else {
                btn.prop('disabled', true);
            }

            if (e.which == 13) {
                btn.click();
                $('#status-name').focus();
                return false;
            }
        });

        $('.handy-status-set-settings').on('click', '.set-delete', function() {
            $(this).parent().hide();
            $(this).parent().parent().children('.set-delete-container').show();
            return false;
        });

        $('.handy-status-set-settings').on('click', '.set-delete-cancel', function() {
            $(this).parent().hide();
            $(this).parent().parent().children('.set-first-action-container').show();
            return false;
        });

        $('.handy-status-set-settings').on('click', '.set-delete-save', function() {
            var tr = $(this).parents('tr').first();
            var setId = tr.attr("id");

            const statusSetUrl = Confluence.getContextPath() + '/rest/handy-macros/2.0/status-macro/settings/sets/' + setId;

            var removeSet = function() {
                $.ajax({
                    contentType: "application/x-www-form-urlencoded; charset=utf-8",
                    type: 'DELETE',
                    cache: false,
                    url: statusSetUrl,
                    dataType: 'json',
                    success: function() {
                        tr.remove();
                        if (!$('tr.set.selected').length) {
                            $('table.handy-statuses').hide();
                            $('tr.set .set-container').first().click();
                        }
                        updateMacroBrowser();
                    },
                    error: function (xhr) {
                        showError(xhr);
                    }
                });
            };

            $.ajax({
                contentType: "application/x-www-form-urlencoded; charset=utf-8",
                type: 'GET',
                cache: false,
                url: statusSetUrl + '/usage',
                dataType: 'json',
                success: function(data) {
                    if (Object.keys(data.pages).length === 0 && data.restricted === 0) {
                        removeSet();
                    } else {
                        showRemoveDialog(
                            data,
                            tr.find('.set-name-view').text(),
                            removeSet
                        );
                    }
                },
                error: function (xhr) {
                    showError(xhr);
                }
            });

            return false;
        });

        $('.handy-status-set-settings').on('click', '.set-edit', function() {
            $(this).parent().hide();
            $(this).parents('td').first().children('.set-edit-container').show();

            var tr = $(this).parents('tr').first();
            var nameSpan = tr.find('.set-name-view');
            var input = tr.find('.set-name-input');
            input.val(nameSpan.text().trim());
            nameSpan.hide();
            input.show().focus();

            return false;
        });

        $('.handy-status-set-settings').on('click', '.set-edit-cancel', function() {
            $(this).parent().hide();
            $(this).parents('td').first().children('.set-first-action-container').show();

            var tr = $(this).parents('tr').first();
            tr.find('.set-name-input').hide();
            tr.find('.set-name-view').show();

            return false;
        });

        $('.handy-status-set-settings').on('click', '.set-edit-save', function() {
            var btn = $(this);
            if (btn.is('.disabled')) {
                return;
            }

            var loader = btn.parent().children('.aui-icon-wait');
            var tr = btn.parents('tr').first();
            var nameSpan = tr.find('.set-name-view');
            var input = tr.find('.set-name-input');

            btn.prop('disabled', true);
            loader.show();

            const statusSetId = tr.attr("id");

            const url = Confluence.getContextPath() +
                '/rest/handy-macros/2.0/status-macro/settings/sets/' + statusSetId + '/name';

            $.ajax({
                contentType: "application/x-www-form-urlencoded; charset=utf-8",
                type: 'PUT',
                cache: false,
                url: url,
                dataType: 'json',
                data: {
                    newName: input.val().trim()
                },
                success: function() {
                    nameSpan.text(input.val());
                    input.hide();
                    nameSpan.show();
                    btn.parent().hide();
                    btn.parents('td').first().children('.set-first-action-container').show();
                    updateMacroBrowser();
                },
                error: function (xhr) {
                    showError(xhr);
                },
                complete: function() {
                    btn.prop('disabled', false);
                    loader.hide();
                }
            });

            return false;
        });

        $('.handy-status-set-settings').on('click', '.set-container', function() {
            var tr = $(this).parents('tr');
            if (tr.hasClass('selected')) return;

            var statusBody = $('#status-body');
            $('tr.selected').removeClass('selected');
            tr.first().addClass('selected');
            $('tr.status').remove();
            $('table.handy-statuses').show();

            const statusSetId = tr.attr("id");
            const url = Confluence.getContextPath() +
                '/rest/handy-macros/2.0/status-macro/settings/sets/' + statusSetId + '/statuses';

            $.ajax({
                contentType: "application/x-www-form-urlencoded; charset=utf-8",
                type: 'GET',
                cache: false,
                url: url,
                dataType: 'json',
                success: function (statuses) {
                    $.each(statuses, function(i, status) {
                        statusBody.append(StatusSettings.status({
                            id: status.id,
                            statusName: status.name,
                            bgColour: status.backgroundColor,
                            textColour: status.textColor,
                            textColorEmpty: status.textColor.trim() === '',
                            view: tr.data('view'),
                            width: tr.data('width')
                        }));
                    });

                    if (!testColorPicker()) {
                        $('.colour-picker').remove();
                    }
                },
                error: function (xhr) {
                    showError(xhr);
                }
            });
        });

        initCategorySettingsDialog(body);
    }

    function initCategorySettingsDialog(body) {
        const inlineDialog = document.getElementById('handy-ss-settings-dialog');
        const $dialogPanel = $(document.getElementById('handy-ss-settings-panel'));

        inlineDialog.addEventListener('aui-show', function() {
            const viewTypeInput = $dialogPanel.find('#view-type');
            viewTypeInput.prop('checked', body.find('tr.selected').data('view') === 1);
        });

        bindCategorySettingsDialog(inlineDialog, $dialogPanel, body);
    }

    function bindCategorySettingsDialog(inlineDialog, $dialogPanel, body) {
        const viewTypeInput = $dialogPanel.find('#view-type');

        $dialogPanel.find('#handy-ss-cancel').click(function () {
            viewTypeInput.prop('checked', body.find('tr.selected').data('view') === 1);
            inlineDialog.open = false;
            return false;
        });

        $dialogPanel.find('#handy-ss-save').click(function () {
            const tr = body.find('tr.selected');
            const view = viewTypeInput.is(':checked') ? 1 : 0;
            const statuses = $('.handy-statuses .status-name-view');
            let width;
            if (view) {
                width = 0;
                statuses.addClass('min-view');
                statuses.each(function () {
                    width = Math.max(width, $(this).width());
                });
                width = Math.min(Math.ceil(width) + 1, 76);
                statuses.css('min-width', width + 'px');
            } else {
                statuses.removeClass('min-view');
                statuses.css('min-width', '');
            }

            tr.data('view', view).data('width', width);

            const statusSetId = tr.attr('id');
            const url = Confluence.getContextPath() +
                '/rest/handy-macros/2.0/status-macro/settings/sets/' + statusSetId + '/view-type';

            $.ajax({
                contentType: "application/x-www-form-urlencoded; charset=utf-8",
                type: 'PUT',
                cache: false,
                url: url,
                data: {
                    view: view,
                    width: width
                },
                dataType: 'json'
            });

            inlineDialog.open = false;
            return false;
        });
    }

    function initStatuses() {
        var statusInput = $('#status-name');
        var bgColor = $('#status-bg-colour');
        var textColor = $('#status-text-colour');
        var addStatusBtn = $('#add-status');
        var statusAddRow = $('#status-add-row');
        var loader = statusAddRow.find('.aui-icon-wait');
        var body = $('#status-body');
        var th = $('.handy-status-action').eq(0);

        var getStatusesByName = function(name) {
            return $('.status-name-view').filter(function() {
                return $(this).text().trim().toLocaleLowerCase() === name.toLocaleLowerCase();
            });
        };

        var updateStatusesWidth = function (tr) {
            if (tr.data('view') === 1) {
                var statuses = $('.handy-statuses .status-name-view');
                var width = 0;
                statuses.css('min-width', '');
                statuses.each(function () {
                    width = Math.max(width, $(this).width());
                });
                width = Math.min(Math.ceil(width) + 1, 76);
                statuses.css('min-width', width + 'px');
                tr.data('width', width);

                const statusSetId = tr.attr('id');
                const url = Confluence.getContextPath() + '/rest/handy-macros/2.0/status-macro/settings/sets/' + statusSetId + '/width';

                $.ajax({
                    contentType: "application/x-www-form-urlencoded; charset=utf-8",
                    type: 'PUT',
                    cache: false,
                    url: url,
                    data: {
                        width: width
                    },
                    dataType: 'json'
                });
            }
        };

        if (!testColorPicker()) {
            $('.colour-picker').remove();
        }

        statusInput.add(bgColor).add(textColor).bind('keyup change paste cut input', function(e) {
            var name = statusInput.val().trim();
            if (name && getStatusesByName(name).length === 0 && bgColor.val().trim()) {
                addStatusBtn.prop('disabled', false);
            } else {
                addStatusBtn.prop('disabled', true);
            }

            var input = $(this);
            var color = repairColor(input, th);

            $('#' + input.attr('id') + '-picker').val(color);

            if (e.which === 13) {
                addStatusBtn.click();
                $('#status-name').focus();
                return false;
            }
        });

        $('#status-bg-colour-picker').bind('change click', function() {
            $('#status-bg-colour').val($(this).val()).trigger('change');
        });

        $('#status-text-colour-picker').bind('change click', function() {
            $('#status-text-colour').val($(this).val()).trigger('change');
        });

        addStatusBtn.click(function() {
            if (addStatusBtn.is('.disabled')) {
                return;
            }
            var tr = $('tr.set.selected');
            addStatusBtn.prop('disabled', true);
            loader.show();

            bgColor.val(repairColor(bgColor, th));
            if (textColor.val().trim()) textColor.val(repairColor(textColor, th));

            const statusSetId = tr.attr('id');
            const url = Confluence.getContextPath() + '/rest/handy-macros/2.0/status-macro/settings/sets/' + statusSetId + '/statuses';

            $.ajax({
                contentType: "application/x-www-form-urlencoded; charset=utf-8",
                type: 'POST',
                cache: false,
                url: url,
                data: {
                    textColor: textColor.val(),
                    backgroundColor: bgColor.val(),
                    statusName: statusInput.val().trim(),
                },
                dataType: 'json',
                success: function(createdStatus) {
                    body.append(StatusSettings.status({
                        id: createdStatus.id,
                        statusName: statusInput.val(),
                        bgColour: bgColor.val(),
                        textColour: textColor.val().trim() ? textColor.val() : getContrastColor(repairColor(bgColor, th)),
                        textColorEmpty: textColor.val().trim() === '',
                        view: tr.data('view'),
                        width: tr.data('width')
                    }));
                    statusInput.val('');
                    bgColor.val('').change();
                    textColor.val('').change();
                    bgColor.find('option').first().attr('selected', 'selected');
                    if (!testColorPicker()) {
                        $('.colour-picker').remove();
                    }
                    updateMacroBrowser();
                    updateStatusesWidth(tr);
                },
                error: function(xhr) {
                    addStatusBtn.prop('disabled', false);
                    showError(xhr);
                },
                complete: function() {
                    loader.hide();
                }
            });

            return false;
        });

        $('.handy-statuses').on('click', '.status-delete', function() {
            $(this).parent().hide();
            $(this).parent().parent().children('.status-delete-container').show();
            return false;
        });

        $('.handy-statuses').on('click', '.status-delete-cancel', function() {
            $(this).parent().hide();
            $(this).parent().parent().children('.status-first-action-container').show();
            return false;
        });

        $('.handy-statuses').on('click', '.status-delete-save', function() {
            var tr = $(this).parents('tr').first();
            var statusSetId = $('tr.set.selected').attr("id");
            var statusId = tr.attr('id');

            var removeStatus = function() {
                const removeStatusUrl = Confluence.getContextPath() +
                    '/rest/handy-macros/2.0/status-macro/settings/sets/' + statusSetId + '/statuses/' + statusId;

                $.ajax({
                    contentType: "application/x-www-form-urlencoded; charset=utf-8",
                    type: 'DELETE',
                    cache: false,
                    url: removeStatusUrl,
                    success: function() {
                        tr.remove();
                        updateMacroBrowser();
                        updateStatusesWidth($('tr.set.selected'));
                    },
                    error: function (xhr) {
                        showError(xhr);
                    }
                });
            };

            const statusUsageUrl = Confluence.getContextPath() +
                '/rest/handy-macros/2.0/status-macro/settings/sets/' + statusSetId + '/statuses/' + statusId + '/usage';

            $.ajax({
                contentType: "application/x-www-form-urlencoded; charset=utf-8",
                type: 'GET',
                cache: false,
                url: statusUsageUrl,
                dataType: 'json',
                success: function(data) {
                    if (Object.keys(data.pages).length === 0 && data.restricted === 0) {
                        removeStatus();
                    } else {
                        showRemoveDialog(
                            data,
                            tr.find('.status-name-view').text(),
                            removeStatus,
                            true
                        );
                    }
                },
                error: function (xhr) {
                    showError(xhr);
                }
            });

            return false;
        });

        $('.handy-statuses').on('click', '.status-edit', function() {
            $(this).parent().hide();
            $(this).parents('td').first().children('.status-edit-container').show();

            var tr = $(this).parents('tr').first();
            var nameSpan = tr.find('.status-name-view');
            var input = tr.find('.status-name-input');
            input.val(nameSpan.text().trim());
            nameSpan.hide();
            input.show().focus();

            var bgSpan = tr.find('.status-bg-colour-view');
            var bgInput = tr.find('.status-bg-colour-input');
            bgInput.val(bgSpan.text().trim()).trigger('change');
            bgSpan.hide();
            bgInput.show();

            var textSpan = tr.find('.status-text-colour-view');
            var textInput = tr.find('.status-text-colour-input');
            textInput.val(textSpan.text().trim()).trigger('change');
            textSpan.hide();
            textInput.show();

            tr.find('.colour-picker').show();

            return false;
        });

        $('.handy-statuses').on('keyup change paste cut',
            '.status-name-input, .status-bg-colour-input, .status-text-colour-input', function(e) {
            var row = $(this).parent().parent();
            var name = row.find('.status-name-input').val().trim();
            if (name && getStatusesByName(name).not('#' + row.attr('id') + ' .status-name-view').length === 0 && row.find('.status-bg-colour-input').val().trim()) {
                row.find('.status-edit-save').prop('disabled', false);
            } else {
                row.find('.status-edit-save').prop('disabled', true);
            }

            var input = $(this);
            var color = repairColor(input, th);
            row.find('.' + input.data('id') + '-picker').val(color);

            if (e.which === 13) {
                row.find('.status-edit-save').click();
                return false;
            }
        });

        $('.handy-statuses').on('change click', '.status-bg-colour-picker', function() {
            var row = $(this).parent().parent();
            row.find('.status-bg-colour-input').val($(this).val()).trigger('change');
        });

        $('.handy-statuses').on('change click', '.status-text-colour-picker', function() {
            var row = $(this).parent().parent();
            row.find('.status-text-colour-input').val($(this).val()).trigger('change');
        });

        $('.handy-statuses').on('click', '.status-edit-cancel', function() {
            $(this).parent().hide();
            $(this).parents('td').first().children('.status-first-action-container').show();

            var tr = $(this).parents('tr').first();
            tr.find('.status-name-input').hide();
            tr.find('.status-name-view').show();
            tr.find('.status-bg-colour-input').hide();
            tr.find('.status-bg-colour-view').show();
            tr.find('.status-text-colour-input').hide();
            tr.find('.status-text-colour-view').show();
            tr.find('.colour-picker').hide();

            return false;
        });

        $('.handy-statuses').on('click', '.status-edit-save', function() {
            var btn = $(this);
            if (btn.is('.disabled')) {
                return;
            }
            var loader = btn.parent().children('.aui-icon-wait');
            var tr = btn.parents('tr').first();
            var nameSpan = tr.find('.status-name-view');
            var input = tr.find('.status-name-input');
            var bgSpan = tr.find('.status-bg-colour-view');
            var bgInput = tr.find('.status-bg-colour-input');
            var textSpan = tr.find('.status-text-colour-view');
            var textInput = tr.find('.status-text-colour-input');

            btn.prop('disabled', true);
            loader.show();

            bgInput.val(repairColor(bgInput, th));
            if (textInput.val().trim()) textInput.val(repairColor(textInput, th));

            const statusSetId = $('tr.set.selected').attr('id');
            const statusId = tr.attr('id');

            const url = Confluence.getContextPath() +
                '/rest/handy-macros/2.0/status-macro/settings/sets/' + statusSetId + '/statuses/' + statusId;

            $.ajax({
                contentType: "application/x-www-form-urlencoded; charset=utf-8",
                type: 'PUT',
                cache: false,
                url: url,
                dataType: 'json',
                data: {
                    name: input.val().trim(),
                    textColor: textInput.val().trim(),
                    backgroundColor: bgInput.val().trim(),
                },
                success: function() {
                    nameSpan.text(input.val().trim()).css({
                        color: textInput.val().trim() ? textInput.val().trim() : getContrastColor(repairColor(bgInput, th)),
                        'background-color': bgInput.val().trim(),
                        'border-color': bgInput.val().trim()
                    });
                    bgSpan.text(bgInput.val().trim());
                    textSpan.text(textInput.val().trim());
                    input.hide();
                    nameSpan.show();
                    bgInput.hide();
                    bgSpan.show();
                    textInput.hide();
                    textSpan.show();
                    btn.parent().hide();
                    btn.parents('td').first().children('.status-first-action-container').show();
                    tr.find('.colour-picker').hide();
                    updateMacroBrowser();
                },
                error: function (xhr) {
                    showError(xhr);
                },
                complete: function() {
                    btn.prop('disabled', false);
                    loader.hide();
                }
            });

            return false;
        });

        body.sortable({
            axis: 'y',
            tolerance: 'pointer',
            cursor: 'move',
            scroll: true,
            scrollSensitivity: 80,
            scrollSpeed: 3,
            items: "tr.status",
            start: function(e, ui) {
                var tds = statusAddRow.children('td');
                ui.item.children('td').each(function(i) {
                    $(this).css('width', tds.eq(i).width());
                });
            },
            stop: function() {
                var ids = [];
                body.find('tr.status').each(function() {
                    ids.push($(this).attr('id'));
                });

                const statusSetId = $('tr.set.selected').attr("id");

                const url = Confluence.getContextPath() +
                    '/rest/handy-macros/2.0/status-macro/settings/sets/' + statusSetId + '/statuses/order';

                $.ajax({
                    contentType: "application/x-www-form-urlencoded; charset=utf-8",
                    type: 'POST',
                    cache: false,
                    url: url,
                    dataType: 'json',
                    data: {
                        statusIds: ids
                    }
                });
            }
        });
    }

    function initToolsSettings() {
        const owner = $('#handy-diff-settings').data('owner');
        bindTool('handy-diff', $('#diff-enable'), owner);
        bindTool('handy-header', $('#header-enable'), owner);
        bindTool('handy-tasks', $('#tasks-enable'), owner);
        bindTool('handy-page-status', $('#page-status-enable'));
    }

    function bindTool(toolName, input, owner) {
        input.change(function() {
            $.ajax({
                contentType: "application/x-www-form-urlencoded; charset=utf-8",
                type: 'POST',
                cache: false,
                url: Confluence.getContextPath() + '/rest/handy-macros/2.0/settings/' + toolName,
                data: {
                    owner: owner,
                    enabled: input.is(':checked')
                },
                dataType: 'json',
                success: function () {
                    sendToolGA4Event(toolName, input);
                },
                error: function (xhr) {
                    input.prop('checked', !input.is(':checked'));
                    showError(xhr);
                }
            });
        });
    }

    function sendToolGA4Event(toolName, input) {
        if (toolName === 'handy-page-status') {
            input.is(':checked')
                ? AnalyticsClient.sendPageStatusEnableGlobalEvent()
                : AnalyticsClient.sendPageStatusDisableGlobalEvent();
        }
    }

    function showRemoveDialog(data, name, callback, isStatus) {
        const templateParams = {name: name, pages: data.pages, restrictedCount: data.restricted};
        if (isStatus) {
            showRemoveStatusDialog(templateParams, callback);
        } else {
            showRemoveSetDialog(templateParams, callback);
        }
    }

    function showRemoveStatusDialog(templateParams, onConfirmCallback) {
        const dialog = $(StatusSettings.removeStatusDialog(templateParams));
        bindControlsAndShowRemoveDialog(dialog, onConfirmCallback);
    }

    function showRemoveSetDialog(templateParams, onConfirmCallback) {
        const dialog = $(StatusSettings.removeSetDialog(templateParams));
        bindControlsAndShowRemoveDialog(dialog, onConfirmCallback);
    }

    function bindControlsAndShowRemoveDialog(dialog, onConfirmCallback) {
        dialog.find('#remove-confirm').on('click', function () {
            onConfirmCallback();
            AJS.dialog2(dialog).hide();
        });
        dialog.find('#remove-cancel').on('click', function () {
            AJS.dialog2(dialog).hide();
        });
        AJS.dialog2(dialog).show();
    }

    function updateMacroBrowser() {
        if (opener && opener.HandyStatusMacroReloader && opener.HandyStatusMacroReloader.beforeParamsSet) {
            opener.HandyStatusMacroReloader.beforeParamsSet(opener.HandyStatusMacroReloader.params);
        }
    }

    function showError(xhr) {
        var isReadOnly = xhr.responseText.indexOf('com.atlassian.confluence.api.service.exceptions.ReadOnlyException') !== -1;
        AJS.messages.error($('#handy-status-message'), {
            title: AJS.I18n.getText("handy.macros.config.error.title"),
            body: isReadOnly ? AJS.I18n.getText("handy.macros.read-only-mode") : AJS.I18n.getText("handy.macros.config.error.body")
        });
    }

    function hexc(colorval) {
        var parts = colorval.match(/^rgb\((\d+),\s*(\d+),\s*(\d+)\)$/);
        for (var i = 1; i <= 3; ++i) {
            parts[i] = parseInt(parts[i]).toString(16);
            if (parts[i].length === 1) parts[i] = '0' + parts[i];
        }
        parts[0] = '';
        var color = '#' + parts.join('');

        return color;
    }

    function testColorPicker() {
        var colorInput = $('<input type="color" value="!" />')[0];
        return colorInput.type === 'color' && colorInput.value !== '!';
    }

    function repairColor(input, th) {
        return hexc(th.css('color', '').css('color', input.val()).css('color'));
    }

    function getContrastColor(hexcolor) {
        var r = parseInt(hexcolor.substr(1,2),16);
        var g = parseInt(hexcolor.substr(3,2),16);
        var b = parseInt(hexcolor.substr(5,2),16);
        var yiq = ((r*299)+(g*587)+(b*114))/1000;
        return (yiq >= 128) ? 'black' : 'white';
    }
});

