"use strict";
(self["webpackChunkhandy_macros_server"] = self["webpackChunkhandy_macros_server"] || []).push([["page-status-view"],{

/***/ "./node_modules/@atlaskit/icon/glyph/add.js":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;

var _react = _interopRequireDefault(__webpack_require__("./node_modules/react/index.js"));

var _base = __webpack_require__("./node_modules/@atlaskit/icon/dist/esm/entry-points/base.js");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const AddIcon = props => /*#__PURE__*/_react.default.createElement(_base.Icon, Object.assign({
  dangerouslySetGlyph: `<svg width="24" height="24" viewBox="0 0 24 24" role="presentation"><path d="M13 11V3.993A.997.997 0 0012 3c-.556 0-1 .445-1 .993V11H3.993A.997.997 0 003 12c0 .557.445 1 .993 1H11v7.007c0 .548.448.993 1 .993.556 0 1-.445 1-.993V13h7.007A.997.997 0 0021 12c0-.556-.445-1-.993-1H13z" fill="currentColor" fill-rule="evenodd"/></svg>`
}, props));

AddIcon.displayName = 'AddIcon';
var _default = AddIcon;
exports["default"] = _default;

/***/ }),

/***/ "./src/main/frontend/api/backend/status-page.ts":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.fetchDeletePageStatus = exports.fetchPageStatusHistory = exports.fetchCreatePageStatus = exports.fetchUpdatePageStatus = exports.fetchPageStatusForEditor = exports.fetchPageStatus = void 0;
var context_1 = __webpack_require__("./src/main/frontend/shared/context.ts");
var PAGE_STATUS_URL = function (contentId) { return "".concat(context_1.APP_REST_API_BASE_URL, "/page/").concat(contentId, "/status"); };
var PAGE_STATUS_EDITOR_URL = function (contentId) { return "".concat(context_1.APP_REST_API_BASE_URL, "/page/").concat(contentId, "/status/editor"); };
var PAGE_STATUS_HISTORY_URL = function (contentId) { return "".concat(context_1.APP_REST_API_BASE_URL, "/page/").concat(contentId, "/status/history"); };
var fetchPageStatus = function (contentId) { return __awaiter(void 0, void 0, void 0, function () {
    var response, message;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0: return [4 /*yield*/, fetch(PAGE_STATUS_URL(contentId))];
            case 1:
                response = _a.sent();
                if (!!response.ok) return [3 /*break*/, 3];
                return [4 /*yield*/, response.text()];
            case 2:
                message = _a.sent();
                throw new Error("Failed to fetch Page Status, Reason: ".concat(message, ", ").concat(response.statusText));
            case 3: return [4 /*yield*/, response.json()];
            case 4: return [2 /*return*/, _a.sent()];
        }
    });
}); };
exports.fetchPageStatus = fetchPageStatus;
var fetchPageStatusForEditor = function (contentId, spaceKey) { return __awaiter(void 0, void 0, void 0, function () {
    var url, response;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                url = "".concat(PAGE_STATUS_EDITOR_URL(contentId), "?spaceKey=").concat(spaceKey);
                return [4 /*yield*/, fetch(url)];
            case 1:
                response = _a.sent();
                if (!response.ok) {
                    throw new Error('Failed to fetch Page Status for editor');
                }
                return [4 /*yield*/, response.json()];
            case 2: return [2 /*return*/, _a.sent()];
        }
    });
}); };
exports.fetchPageStatusForEditor = fetchPageStatusForEditor;
var fetchPostOrPutPageStatusForEditor = function (contentId, statusId, statusSetId, method) { return __awaiter(void 0, void 0, void 0, function () {
    var response, message;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0: return [4 /*yield*/, fetch(PAGE_STATUS_EDITOR_URL(contentId), {
                    method: method,
                    cache: 'no-cache',
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded',
                    },
                    body: new URLSearchParams({
                        statusId: statusId.toString(),
                        statusSetId: statusSetId.toString(),
                    })
                })];
            case 1:
                response = _a.sent();
                if (!!response.ok) return [3 /*break*/, 3];
                return [4 /*yield*/, response.text()];
            case 2:
                message = _a.sent();
                throw new Error("Failed to ".concat(method === 'POST' ? 'add' : 'update', " Page Status. Reason: ").concat(message, ", ").concat(response.statusText));
            case 3: return [2 /*return*/];
        }
    });
}); };
var fetchUpdatePageStatus = function (contentId, statusId, statusSetId) {
    return fetchPostOrPutPageStatusForEditor(contentId, statusId, statusSetId, 'PUT');
};
exports.fetchUpdatePageStatus = fetchUpdatePageStatus;
var fetchCreatePageStatus = function (contentId, statusId, statusSetId) {
    return fetchPostOrPutPageStatusForEditor(contentId, statusId, statusSetId, 'POST');
};
exports.fetchCreatePageStatus = fetchCreatePageStatus;
var fetchPageStatusHistory = function (contentId) { return __awaiter(void 0, void 0, void 0, function () {
    var response;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0: return [4 /*yield*/, fetch(PAGE_STATUS_HISTORY_URL(contentId))];
            case 1:
                response = _a.sent();
                if (!response.ok) {
                    throw new Error('Failed to fetch Page Status history');
                }
                return [4 /*yield*/, response.json()];
            case 2: return [2 /*return*/, _a.sent()];
        }
    });
}); };
exports.fetchPageStatusHistory = fetchPageStatusHistory;
var fetchDeletePageStatus = function (contentId) { return __awaiter(void 0, void 0, void 0, function () {
    var response;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0: return [4 /*yield*/, fetch(PAGE_STATUS_EDITOR_URL(contentId), {
                    method: 'DELETE'
                })];
            case 1:
                response = _a.sent();
                if (!response.ok) {
                    throw new Error('Fail to delete page status.');
                }
                return [2 /*return*/];
        }
    });
}); };
exports.fetchDeletePageStatus = fetchDeletePageStatus;


/***/ }),

/***/ "./src/main/frontend/page-status/dialog/components/hooks/use-async-state.ts":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
var react_1 = __webpack_require__("./node_modules/react/index.js");
var useAsyncState = function (defaultValue, request, dependencies, onError) {
    var _a = (0, react_1.useState)(defaultValue), data = _a[0], setData = _a[1];
    var _b = (0, react_1.useState)(true), isLoading = _b[0], setIsLoading = _b[1];
    var _c = (0, react_1.useState)(''), error = _c[0], setError = _c[1];
    (0, react_1.useEffect)(function () {
        request()
            .then(setData)
            .catch(function (err) {
            setError(err);
            if (onError) {
                onError();
            }
        })
            .finally(function () { return setIsLoading(false); });
    }, dependencies !== null && dependencies !== void 0 ? dependencies : []); // eslint-disable-line react-hooks/exhaustive-deps
    return [data, isLoading, error, setData];
};
exports["default"] = useAsyncState;


/***/ }),

/***/ "./src/main/frontend/page-status/services/page-status-service.ts":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.loadGA4Resource = exports.showFlag = exports.triggerPageStatusUpdate = exports.removePageStatusAjsDialog = exports.handlePageStatusClick = exports.PAGE_STATUS_VIEW_ELEMENT_ID = exports.PAGE_STATUS_DIALOG_ROOT_ELEMENT_ID = exports.PAGE_STATUS_CHANGED_EVENT_NAME = exports.PAGE_STATUS_EDITOR_OPENED_EVENT_NAME = void 0;
var wrm_react_i18n_1 = __webpack_require__("./node_modules/@atlassian/wrm-react-i18n/wrm-react-i18n.js");
exports.PAGE_STATUS_EDITOR_OPENED_EVENT_NAME = 'HandyPageStatusEditorOpened';
exports.PAGE_STATUS_CHANGED_EVENT_NAME = 'HandyPageStatusChanged';
exports.PAGE_STATUS_DIALOG_ROOT_ELEMENT_ID = 'hm-page-status-dialog-root';
exports.PAGE_STATUS_VIEW_ELEMENT_ID = 'hm-page-status-view';
var DIALOG_RESOURCE_KEY = 'com.stiltsoft.confluence.handy.macros:page-status-dialog';
var GA4_RESOURCE_KEY = 'com.stiltsoft.confluence.handy.macros:google-analytics4';
var handlePageStatusClick = function (statusId) {
    var loadingIndicator = Confluence.PageLoadingIndicator($('body'));
    var dialogResourcePromise = WRM.require("wr!".concat(DIALOG_RESOURCE_KEY));
    dialogResourcePromise.then(function () {
        var dialogRootElement = document.getElementById(exports.PAGE_STATUS_DIALOG_ROOT_ELEMENT_ID);
        if (!dialogRootElement) {
            var ajsDialog = createPageStatusAjsDialog(statusId);
            renderAjsDialog(ajsDialog);
        }
        dispatchEventForPageStatusEditorReRender();
    });
    loadingIndicator.showUntilDialogVisible(dialogResourcePromise, wrm_react_i18n_1.I18n.getText('handy.page-status.dialog.loading.error'));
};
exports.handlePageStatusClick = handlePageStatusClick;
var renderAjsDialog = function (dialog) {
    dialog.show();
    dialog.hide();
};
var dispatchEventForPageStatusEditorReRender = function () { return document.dispatchEvent(new CustomEvent(exports.PAGE_STATUS_EDITOR_OPENED_EVENT_NAME)); };
var createPageStatusAjsDialog = function (statusId) {
    return AJS.dialog2("<div id=\"".concat(exports.PAGE_STATUS_DIALOG_ROOT_ELEMENT_ID, "\" data-status-id=").concat(statusId ? statusId : '', "></div>"));
};
var removePageStatusAjsDialog = function () { return AJS.dialog2("#".concat(exports.PAGE_STATUS_DIALOG_ROOT_ELEMENT_ID)).remove(); };
exports.removePageStatusAjsDialog = removePageStatusAjsDialog;
var triggerPageStatusUpdate = function (params) {
    return document.dispatchEvent(new CustomEvent(exports.PAGE_STATUS_CHANGED_EVENT_NAME, { detail: params }));
};
exports.triggerPageStatusUpdate = triggerPageStatusUpdate;
var showFlag = function (options) { return AJS.flag(options); };
exports.showFlag = showFlag;
var loadGA4Resource = function () {
    if (!window.handyGtag) {
        void WRM.require("wr!".concat(GA4_RESOURCE_KEY));
    }
};
exports.loadGA4Resource = loadGA4Resource;


/***/ }),

/***/ "./src/main/frontend/page-status/services/page-status-view-service.ts":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getPageStatus = void 0;
var status_page_1 = __webpack_require__("./src/main/frontend/api/backend/status-page.ts");
var getPageStatus = function () { return __awaiter(void 0, void 0, void 0, function () {
    var contentId, error_1, message;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                contentId = Confluence.getContentId();
                _a.label = 1;
            case 1:
                _a.trys.push([1, 3, , 4]);
                return [4 /*yield*/, (0, status_page_1.fetchPageStatus)(contentId)];
            case 2: return [2 /*return*/, _a.sent()];
            case 3:
                error_1 = _a.sent();
                message = 'Cannot get Page Status data!';
                console.log(message, error_1);
                throw Error(message);
            case 4: return [2 /*return*/];
        }
    });
}); };
exports.getPageStatus = getPageStatus;


/***/ }),

/***/ "./src/main/frontend/page-status/view/components/AddStatusIcon.tsx":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var react_1 = __importDefault(__webpack_require__("./node_modules/react/index.js"));
var wrm_react_i18n_1 = __webpack_require__("./node_modules/@atlassian/wrm-react-i18n/wrm-react-i18n.js");
var add_1 = __importDefault(__webpack_require__("./node_modules/@atlaskit/icon/glyph/add.js"));
var AddStatusIcon = function () { return (react_1.default.createElement(add_1.default, { label: wrm_react_i18n_1.I18n.getText('handy.page-status.view.button'), size: "medium" })); };
exports["default"] = AddStatusIcon;


/***/ }),

/***/ "./src/main/frontend/page-status/view/components/ButtonAddStatus.tsx":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var react_1 = __importDefault(__webpack_require__("./node_modules/react/index.js"));
var wrm_react_i18n_1 = __webpack_require__("./node_modules/@atlassian/wrm-react-i18n/wrm-react-i18n.js");
var button_1 = __importDefault(__webpack_require__("./node_modules/@atlaskit/button/dist/esm/index.js"));
var page_status_view_style_1 = __webpack_require__("./src/main/frontend/page-status/view/page-status-view.style.ts");
var AddStatusIcon_1 = __importDefault(__webpack_require__("./src/main/frontend/page-status/view/components/AddStatusIcon.tsx"));
var ButtonAddStatus = function (_a) {
    var onClick = _a.onClick;
    return (react_1.default.createElement(page_status_view_style_1.ButtonAddStatusStyled, { id: "add-page-status", className: "handy-status-editable" },
        react_1.default.createElement(button_1.default, { onClick: onClick, spacing: "default", iconBefore: react_1.default.createElement(AddStatusIcon_1.default, null) }, wrm_react_i18n_1.I18n.getText('handy.page-status.view.button'))));
};
exports["default"] = ButtonAddStatus;


/***/ }),

/***/ "./src/main/frontend/page-status/view/components/MediumLoadingSpinner.tsx":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var react_1 = __importDefault(__webpack_require__("./node_modules/react/index.js"));
var spinner_1 = __importDefault(__webpack_require__("./node_modules/@atlaskit/spinner/dist/esm/index.js"));
var page_status_view_style_1 = __webpack_require__("./src/main/frontend/page-status/view/page-status-view.style.ts");
var MediumLoadingSpinner = function () { return (react_1.default.createElement(page_status_view_style_1.MediumLoadingSpinnerStyled, null,
    react_1.default.createElement(spinner_1.default, { size: "medium" }))); };
exports["default"] = MediumLoadingSpinner;


/***/ }),

/***/ "./src/main/frontend/page-status/view/components/PageStatusView.tsx":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var react_1 = __importStar(__webpack_require__("./node_modules/react/index.js"));
var use_async_state_1 = __importDefault(__webpack_require__("./src/main/frontend/page-status/dialog/components/hooks/use-async-state.ts"));
var page_status_view_service_1 = __webpack_require__("./src/main/frontend/page-status/services/page-status-view-service.ts");
var page_status_service_1 = __webpack_require__("./src/main/frontend/page-status/services/page-status-service.ts");
var MediumLoadingSpinner_1 = __importDefault(__webpack_require__("./src/main/frontend/page-status/view/components/MediumLoadingSpinner.tsx"));
var page_status_view_style_1 = __webpack_require__("./src/main/frontend/page-status/view/page-status-view.style.ts");
var ClickableStatus_1 = __importDefault(__webpack_require__("./src/main/frontend/page-status/view/components/status/ClickableStatus.tsx"));
var PlainStatus_1 = __importDefault(__webpack_require__("./src/main/frontend/page-status/view/components/status/PlainStatus.tsx"));
var ButtonAddStatus_1 = __importDefault(__webpack_require__("./src/main/frontend/page-status/view/components/ButtonAddStatus.tsx"));
var emptyPageStatus = {
    licensed: false,
};
var PageStatusView = function () {
    var _a = (0, use_async_state_1.default)(emptyPageStatus, page_status_view_service_1.getPageStatus), pageStatus = _a[0], isLoading = _a[1], error = _a[2], setPageStatus = _a[3];
    var updatePageStatus = function (event) {
        var updatedPageStatus = event.detail;
        setPageStatus(__assign({}, updatedPageStatus));
    };
    (0, react_1.useEffect)(function () {
        window.document.addEventListener(page_status_service_1.PAGE_STATUS_CHANGED_EVENT_NAME, updatePageStatus, false);
        return function () {
            window.document.removeEventListener(page_status_service_1.PAGE_STATUS_CHANGED_EVENT_NAME, updatePageStatus, false);
        };
    }, []);
    var onPageStatusClick = (0, react_1.useCallback)(function () {
        if (!pageStatus)
            return;
        var status = pageStatus.status;
        (0, page_status_service_1.handlePageStatusClick)(status === null || status === void 0 ? void 0 : status.id);
    }, [pageStatus === null || pageStatus === void 0 ? void 0 : pageStatus.status]);
    if (isLoading) {
        return react_1.default.createElement(MediumLoadingSpinner_1.default, null);
    }
    if (error) {
        return null;
    }
    if (pageStatus === null || pageStatus === void 0 ? void 0 : pageStatus.status) {
        var status_1 = pageStatus.status, statusWidth = pageStatus.statusWidth, licensed = pageStatus.licensed;
        return (react_1.default.createElement(page_status_view_style_1.PageStatusViewStyled, null, licensed ?
            react_1.default.createElement(ClickableStatus_1.default, { onClick: onPageStatusClick, status: status_1, minWidth: statusWidth }) :
            react_1.default.createElement(PlainStatus_1.default, { status: status_1, minWidth: statusWidth })));
    }
    return react_1.default.createElement(ButtonAddStatus_1.default, { onClick: onPageStatusClick });
};
exports["default"] = PageStatusView;


/***/ }),

/***/ "./src/main/frontend/page-status/view/components/status/ClickableStatus.tsx":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var react_1 = __importDefault(__webpack_require__("./node_modules/react/index.js"));
var StatusPreview_1 = __importDefault(__webpack_require__("./src/main/frontend/shared/components/StatusPreview.tsx"));
var ClickableStatus = function (_a) {
    var status = _a.status, onClick = _a.onClick, minWidth = _a.minWidth;
    var textColor = status.textColor, backgroundColor = status.backgroundColor, name = status.name;
    if (!status) {
        return null;
    }
    return (react_1.default.createElement("div", { className: "container clickable", onClick: onClick },
        react_1.default.createElement(StatusPreview_1.default, { textColor: textColor, backgroundColor: backgroundColor, name: name, minWidth: minWidth })));
};
exports["default"] = ClickableStatus;


/***/ }),

/***/ "./src/main/frontend/page-status/view/components/status/PlainStatus.tsx":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var react_1 = __importDefault(__webpack_require__("./node_modules/react/index.js"));
var StatusPreview_1 = __importDefault(__webpack_require__("./src/main/frontend/shared/components/StatusPreview.tsx"));
var PlainStatus = function (_a) {
    var status = _a.status, minWidth = _a.minWidth;
    var textColor = status.textColor, backgroundColor = status.backgroundColor, name = status.name;
    if (!status) {
        return null;
    }
    return (react_1.default.createElement("div", { className: "container" },
        react_1.default.createElement(StatusPreview_1.default, { textColor: textColor, backgroundColor: backgroundColor, name: name, minWidth: minWidth })));
};
exports["default"] = PlainStatus;


/***/ }),

/***/ "./src/main/frontend/page-status/view/page-status-view.style.ts":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __makeTemplateObject = (this && this.__makeTemplateObject) || function (cooked, raw) {
    if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
    return cooked;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ButtonAddStatusStyled = exports.MediumLoadingSpinnerStyled = exports.PageStatusViewStyled = void 0;
var styled_1 = __importDefault(__webpack_require__("./node_modules/@emotion/styled/dist/emotion-styled.browser.esm.js"));
var tokens_1 = __webpack_require__("./node_modules/@atlaskit/tokens/dist/esm/index.js");
exports.PageStatusViewStyled = styled_1.default.div(templateObject_1 || (templateObject_1 = __makeTemplateObject(["\n    display: inline-block;\n    padding: 4px 10px;\n    cursor: default;\n    \n    & .handy-status-view {\n        padding: 3px 5px 2px 5px !important;\n        border: 1px solid ", ";\n        border-radius: 3px;\n        font-weight: bold;\n        min-width: 76px;\n    }\n    \n    & .container {\n        display: inline-block;\n    }\n    \n    & .clickable {\n        cursor: pointer;\n    }\n"], ["\n    display: inline-block;\n    padding: 4px 10px;\n    cursor: default;\n    \n    & .handy-status-view {\n        padding: 3px 5px 2px 5px !important;\n        border: 1px solid ", ";\n        border-radius: 3px;\n        font-weight: bold;\n        min-width: 76px;\n    }\n    \n    & .container {\n        display: inline-block;\n    }\n    \n    & .clickable {\n        cursor: pointer;\n    }\n"])), (0, tokens_1.token)('color.border', '#CCCCCC'));
exports.MediumLoadingSpinnerStyled = styled_1.default.div(templateObject_2 || (templateObject_2 = __makeTemplateObject(["\n    margin-top: -2px;\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    padding-right: ", ";\n    width: 32px;\n    height: 32px;\n"], ["\n    margin-top: -2px;\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    padding-right: ", ";\n    width: 32px;\n    height: 32px;\n"])), (0, tokens_1.token)('space.150', '12px'));
exports.ButtonAddStatusStyled = styled_1.default.div(templateObject_3 || (templateObject_3 = __makeTemplateObject(["\n    margin: -2px 0;\n"], ["\n    margin: -2px 0;\n"])));
var templateObject_1, templateObject_2, templateObject_3;


/***/ }),

/***/ "./src/main/frontend/page-status/view/page-status-view.tsx":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var react_1 = __importDefault(__webpack_require__("./node_modules/react/index.js"));
var react_dom_1 = __importDefault(__webpack_require__("./node_modules/react-dom/index.js"));
var PageStatusView_1 = __importDefault(__webpack_require__("./src/main/frontend/page-status/view/components/PageStatusView.tsx"));
var page_status_service_1 = __webpack_require__("./src/main/frontend/page-status/services/page-status-service.ts");
react_dom_1.default.render(react_1.default.createElement(PageStatusView_1.default, null), document.getElementById(page_status_service_1.PAGE_STATUS_VIEW_ELEMENT_ID));


/***/ }),

/***/ "./src/main/frontend/shared/components/StatusPreview.tsx":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var react_1 = __importDefault(__webpack_require__("./node_modules/react/index.js"));
var StatusPreview = function (_a) {
    var textColor = _a.textColor, backgroundColor = _a.backgroundColor, name = _a.name, _b = _a.minWidth, minWidth = _b === void 0 ? 76 : _b;
    var style = {
        color: textColor,
        backgroundColor: backgroundColor,
        borderColor: backgroundColor,
        minWidth: minWidth,
    };
    return react_1.default.createElement("span", { className: "aui-lozenge handy-status-view", style: style }, name);
};
exports["default"] = StatusPreview;


/***/ }),

/***/ "./src/main/frontend/shared/context.ts":
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.APP_REST_API_BASE_URL = exports.getContextSpaceKey = exports.getContextPath = void 0;
var getContextPath = function () { return Confluence.getContextPath(); };
exports.getContextPath = getContextPath;
var getContextSpaceKey = function () { return AJS.Meta.get('space-key'); };
exports.getContextSpaceKey = getContextSpaceKey;
exports.APP_REST_API_BASE_URL = "".concat((0, exports.getContextPath)(), "/rest/handy-macros/2.0");


/***/ }),

/***/ "com.atlassian.plugins.atlassian-plugins-webresource-plugin:i18n/WRM.I18n":
/***/ ((module) => {

if(typeof WRM.I18n === 'undefined') { var e = new Error("Cannot find module 'WRM.I18n'"); e.code = 'MODULE_NOT_FOUND'; throw e; }

module.exports = WRM.I18n;

/***/ }),

/***/ "com.atlassian.plugins.atlassian-plugins-webresource-plugin:format/WRM.format":
/***/ ((module) => {

module.exports = WRM.format;

/***/ })

},
/******/ __webpack_require__ => { // webpackRuntimeModules
/******/ var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
/******/ __webpack_require__.O(0, ["vendors-node_modules_atlaskit_analytics-next-stable-react-context_dist_esm_index_js-node_modu-3ab870","vendors-node_modules_atlaskit_button_dist_esm_index_js-node_modules_atlaskit_icon_dist_esm_en-f99b7d"], () => (__webpack_exec__("./src/main/frontend/page-status/view/page-status-view.tsx")));
/******/ var __webpack_exports__ = __webpack_require__.O();
/******/ }
]);