"use strict";
(self["webpackChunkhandy_macros_server"] = self["webpackChunkhandy_macros_server"] || []).push([["page-status-dialog","ga4-events"],{

/***/ "./src/main/frontend/api/backend/status-macro-settings.ts":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.fetchSetStatuses = exports.fetchStatusSets = void 0;
var context_1 = __webpack_require__("./src/main/frontend/shared/context.ts");
var API_STATUS_MACRO_SETTINGS_PATH = "".concat(context_1.APP_REST_API_BASE_URL, "/status-macro/settings/sets");
var fetchStatusSets = function (statusSetId, spaceKey) { return __awaiter(void 0, void 0, void 0, function () {
    var urlSearchParams, response, message;
    var _a;
    return __generator(this, function (_b) {
        switch (_b.label) {
            case 0:
                urlSearchParams = new URLSearchParams({
                    statusSetId: (_a = statusSetId === null || statusSetId === void 0 ? void 0 : statusSetId.toString()) !== null && _a !== void 0 ? _a : '',
                    spaceKey: spaceKey !== null && spaceKey !== void 0 ? spaceKey : (0, context_1.getContextSpaceKey)(),
                });
                return [4 /*yield*/, fetch("".concat(API_STATUS_MACRO_SETTINGS_PATH, "?").concat(urlSearchParams))];
            case 1:
                response = _b.sent();
                if (!!response.ok) return [3 /*break*/, 3];
                return [4 /*yield*/, response.text()];
            case 2:
                message = _b.sent();
                throw new Error("Failed to fetch Status Sets. Reason: ".concat(message, ", ").concat(response.statusText));
            case 3: return [4 /*yield*/, response.json()];
            case 4: return [2 /*return*/, _b.sent()];
        }
    });
}); };
exports.fetchStatusSets = fetchStatusSets;
var fetchSetStatuses = function (statusSetId) { return __awaiter(void 0, void 0, void 0, function () {
    var response, message;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0: return [4 /*yield*/, fetch("".concat(API_STATUS_MACRO_SETTINGS_PATH, "/").concat(statusSetId, "/statuses"))];
            case 1:
                response = _a.sent();
                if (!!response.ok) return [3 /*break*/, 3];
                return [4 /*yield*/, response.text()];
            case 2:
                message = _a.sent();
                throw new Error("Failed to fetch Set Statuses. Reason: ".concat(message, ", ").concat(response.statusText));
            case 3: return [4 /*yield*/, response.json()];
            case 4: return [2 /*return*/, _a.sent()];
        }
    });
}); };
exports.fetchSetStatuses = fetchSetStatuses;


/***/ }),

/***/ "./src/main/frontend/api/backend/status-page.ts":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.fetchDeletePageStatus = exports.fetchPageStatusHistory = exports.fetchCreatePageStatus = exports.fetchUpdatePageStatus = exports.fetchPageStatusForEditor = exports.fetchPageStatus = void 0;
var context_1 = __webpack_require__("./src/main/frontend/shared/context.ts");
var PAGE_STATUS_URL = function (contentId) { return "".concat(context_1.APP_REST_API_BASE_URL, "/page/").concat(contentId, "/status"); };
var PAGE_STATUS_EDITOR_URL = function (contentId) { return "".concat(context_1.APP_REST_API_BASE_URL, "/page/").concat(contentId, "/status/editor"); };
var PAGE_STATUS_HISTORY_URL = function (contentId) { return "".concat(context_1.APP_REST_API_BASE_URL, "/page/").concat(contentId, "/status/history"); };
var fetchPageStatus = function (contentId) { return __awaiter(void 0, void 0, void 0, function () {
    var response, message;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0: return [4 /*yield*/, fetch(PAGE_STATUS_URL(contentId))];
            case 1:
                response = _a.sent();
                if (!!response.ok) return [3 /*break*/, 3];
                return [4 /*yield*/, response.text()];
            case 2:
                message = _a.sent();
                throw new Error("Failed to fetch Page Status, Reason: ".concat(message, ", ").concat(response.statusText));
            case 3: return [4 /*yield*/, response.json()];
            case 4: return [2 /*return*/, _a.sent()];
        }
    });
}); };
exports.fetchPageStatus = fetchPageStatus;
var fetchPageStatusForEditor = function (contentId, spaceKey) { return __awaiter(void 0, void 0, void 0, function () {
    var url, response;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                url = "".concat(PAGE_STATUS_EDITOR_URL(contentId), "?spaceKey=").concat(spaceKey);
                return [4 /*yield*/, fetch(url)];
            case 1:
                response = _a.sent();
                if (!response.ok) {
                    throw new Error('Failed to fetch Page Status for editor');
                }
                return [4 /*yield*/, response.json()];
            case 2: return [2 /*return*/, _a.sent()];
        }
    });
}); };
exports.fetchPageStatusForEditor = fetchPageStatusForEditor;
var fetchPostOrPutPageStatusForEditor = function (contentId, statusId, statusSetId, method) { return __awaiter(void 0, void 0, void 0, function () {
    var response, message;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0: return [4 /*yield*/, fetch(PAGE_STATUS_EDITOR_URL(contentId), {
                    method: method,
                    cache: 'no-cache',
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded',
                    },
                    body: new URLSearchParams({
                        statusId: statusId.toString(),
                        statusSetId: statusSetId.toString(),
                    })
                })];
            case 1:
                response = _a.sent();
                if (!!response.ok) return [3 /*break*/, 3];
                return [4 /*yield*/, response.text()];
            case 2:
                message = _a.sent();
                throw new Error("Failed to ".concat(method === 'POST' ? 'add' : 'update', " Page Status. Reason: ").concat(message, ", ").concat(response.statusText));
            case 3: return [2 /*return*/];
        }
    });
}); };
var fetchUpdatePageStatus = function (contentId, statusId, statusSetId) {
    return fetchPostOrPutPageStatusForEditor(contentId, statusId, statusSetId, 'PUT');
};
exports.fetchUpdatePageStatus = fetchUpdatePageStatus;
var fetchCreatePageStatus = function (contentId, statusId, statusSetId) {
    return fetchPostOrPutPageStatusForEditor(contentId, statusId, statusSetId, 'POST');
};
exports.fetchCreatePageStatus = fetchCreatePageStatus;
var fetchPageStatusHistory = function (contentId) { return __awaiter(void 0, void 0, void 0, function () {
    var response;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0: return [4 /*yield*/, fetch(PAGE_STATUS_HISTORY_URL(contentId))];
            case 1:
                response = _a.sent();
                if (!response.ok) {
                    throw new Error('Failed to fetch Page Status history');
                }
                return [4 /*yield*/, response.json()];
            case 2: return [2 /*return*/, _a.sent()];
        }
    });
}); };
exports.fetchPageStatusHistory = fetchPageStatusHistory;
var fetchDeletePageStatus = function (contentId) { return __awaiter(void 0, void 0, void 0, function () {
    var response;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0: return [4 /*yield*/, fetch(PAGE_STATUS_EDITOR_URL(contentId), {
                    method: 'DELETE'
                })];
            case 1:
                response = _a.sent();
                if (!response.ok) {
                    throw new Error('Fail to delete page status.');
                }
                return [2 /*return*/];
        }
    });
}); };
exports.fetchDeletePageStatus = fetchDeletePageStatus;


/***/ }),

/***/ "./src/main/frontend/page-status/dialog/components/ButtonCreateStatusSet.tsx":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var react_1 = __importDefault(__webpack_require__("./node_modules/react/index.js"));
var wrm_react_i18n_1 = __webpack_require__("./node_modules/@atlassian/wrm-react-i18n/wrm-react-i18n.js");
var button_1 = __importDefault(__webpack_require__("./node_modules/@atlaskit/button/dist/esm/index.js"));
var page_status_edit_context_1 = __webpack_require__("./src/main/frontend/page-status/dialog/page-status-edit-context.tsx");
var page_status_edit_service_1 = __webpack_require__("./src/main/frontend/page-status/services/page-status-edit-service.ts");
var ButtonCreateStatusSet = function () {
    var currentStatusSet = (0, page_status_edit_context_1.usePageStatusEditContext)().currentStatusSet;
    var settingsLink = (0, page_status_edit_service_1.getHandySettingsLink)(currentStatusSet === null || currentStatusSet === void 0 ? void 0 : currentStatusSet.owner);
    return (react_1.default.createElement("div", { id: "config-link" },
        react_1.default.createElement(button_1.default, { target: "blank", spacing: "none", appearance: "link", href: settingsLink }, wrm_react_i18n_1.I18n.getText('handy.page-status.dialog.button.new-status-set'))));
};
exports["default"] = ButtonCreateStatusSet;


/***/ }),

/***/ "./src/main/frontend/page-status/dialog/components/DialogAddPageStatus.tsx":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var react_1 = __importStar(__webpack_require__("./node_modules/react/index.js"));
var wrm_react_i18n_1 = __webpack_require__("./node_modules/@atlassian/wrm-react-i18n/wrm-react-i18n.js");
var modal_dialog_1 = __webpack_require__("./node_modules/@atlaskit/modal-dialog/dist/esm/index.js");
var status_page_1 = __webpack_require__("./src/main/frontend/api/backend/status-page.ts");
var page_status_dialog_context_1 = __webpack_require__("./src/main/frontend/page-status/dialog/page-status-dialog-context.tsx");
var page_status_edit_context_1 = __webpack_require__("./src/main/frontend/page-status/dialog/page-status-edit-context.tsx");
var page_status_edit_service_1 = __webpack_require__("./src/main/frontend/page-status/services/page-status-edit-service.ts");
var DialogHeader_1 = __importDefault(__webpack_require__("./src/main/frontend/page-status/dialog/components/DialogHeader.tsx"));
var page_status_dialog_style_1 = __webpack_require__("./src/main/frontend/page-status/dialog/page-status-dialog.style.ts");
var SelectorSetAndStatus_1 = __importDefault(__webpack_require__("./src/main/frontend/page-status/dialog/components/controls/SelectorSetAndStatus.tsx"));
var ButtonCreateStatusSet_1 = __importDefault(__webpack_require__("./src/main/frontend/page-status/dialog/components/ButtonCreateStatusSet.tsx"));
var DialogFooterPageStatus_1 = __importDefault(__webpack_require__("./src/main/frontend/page-status/dialog/components/footer/DialogFooterPageStatus.tsx"));
var DialogAddPageStatus = function () {
    var _a = (0, react_1.useState)(false), isSaving = _a[0], setIsSaving = _a[1];
    var _b = (0, page_status_dialog_context_1.usePageStatusDialogContext)(), contentId = _b.contentId, licensed = _b.licensed;
    var _c = (0, page_status_edit_context_1.usePageStatusEditContext)(), currentStatus = _c.currentStatus, currentStatusSet = _c.currentStatusSet, statusesCount = _c.statusesCount, acceptStatusChange = _c.acceptStatusChange;
    var isSubmitDisabled = !currentStatus || !currentStatusSet || (0, page_status_edit_service_1.isStatusSetUnknown)(currentStatusSet);
    var onSaveSuccess = function () {
        var params = {
            status: currentStatus,
            statusWidth: currentStatusSet === null || currentStatusSet === void 0 ? void 0 : currentStatusSet.width,
            licensed: licensed,
        };
        acceptStatusChange(params);
        (0, page_status_edit_service_1.trackGA4PageStatusAdded)(statusesCount);
    };
    var onSaveFailure = function (error) {
        console.log(error);
        setIsSaving(false);
        (0, page_status_edit_service_1.showAddStatusErrorFlagMessage)();
    };
    var onClickSave = (0, react_1.useCallback)(function () {
        if (isSaving || !currentStatus || !currentStatusSet)
            return;
        setIsSaving(true);
        var id = currentStatus.id;
        var statusSetId = currentStatusSet.id;
        (0, status_page_1.fetchCreatePageStatus)(contentId, id, statusSetId)
            .then(onSaveSuccess)
            .catch(onSaveFailure);
    }, [isSaving, contentId, currentStatus, currentStatusSet, statusesCount]);
    return (react_1.default.createElement(react_1.default.Fragment, null,
        react_1.default.createElement(DialogHeader_1.default, { title: wrm_react_i18n_1.I18n.getText('handy.page-status.dialog.title.add') }),
        react_1.default.createElement(modal_dialog_1.ModalBody, null,
            react_1.default.createElement(page_status_dialog_style_1.DialogPanelStyled, null,
                react_1.default.createElement(SelectorSetAndStatus_1.default, null),
                react_1.default.createElement(ButtonCreateStatusSet_1.default, null))),
        react_1.default.createElement(DialogFooterPageStatus_1.default, { isSaveDisabled: isSubmitDisabled, isCancelDisabled: isSaving, isSaveLoading: isSaving, onClickSave: onClickSave })));
};
exports["default"] = DialogAddPageStatus;


/***/ }),

/***/ "./src/main/frontend/page-status/dialog/components/DialogChangePageStatus.tsx":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var react_1 = __importStar(__webpack_require__("./node_modules/react/index.js"));
var wrm_react_i18n_1 = __webpack_require__("./node_modules/@atlassian/wrm-react-i18n/wrm-react-i18n.js");
var tabs_1 = __importStar(__webpack_require__("./node_modules/@atlaskit/tabs/dist/esm/index.js"));
var status_page_1 = __webpack_require__("./src/main/frontend/api/backend/status-page.ts");
var modal_dialog_1 = __webpack_require__("./node_modules/@atlaskit/modal-dialog/dist/esm/index.js");
var page_status_dialog_context_1 = __webpack_require__("./src/main/frontend/page-status/dialog/page-status-dialog-context.tsx");
var page_status_edit_context_1 = __webpack_require__("./src/main/frontend/page-status/dialog/page-status-edit-context.tsx");
var page_status_edit_service_1 = __webpack_require__("./src/main/frontend/page-status/services/page-status-edit-service.ts");
var DialogHeader_1 = __importDefault(__webpack_require__("./src/main/frontend/page-status/dialog/components/DialogHeader.tsx"));
var page_status_dialog_style_1 = __webpack_require__("./src/main/frontend/page-status/dialog/page-status-dialog.style.ts");
var SelectorSetAndStatus_1 = __importDefault(__webpack_require__("./src/main/frontend/page-status/dialog/components/controls/SelectorSetAndStatus.tsx"));
var ButtonCreateStatusSet_1 = __importDefault(__webpack_require__("./src/main/frontend/page-status/dialog/components/ButtonCreateStatusSet.tsx"));
var PageStatusHistory_1 = __importDefault(__webpack_require__("./src/main/frontend/page-status/dialog/components/history/PageStatusHistory.tsx"));
var DialogFooterPageStatus_1 = __importDefault(__webpack_require__("./src/main/frontend/page-status/dialog/components/footer/DialogFooterPageStatus.tsx"));
var DialogChangePageStatus = function () {
    var _a = (0, react_1.useState)(false), isSaving = _a[0], setIsSaving = _a[1];
    var _b = (0, page_status_dialog_context_1.usePageStatusDialogContext)(), contentId = _b.contentId, statusForEditor = _b.statusForEditor, licensed = _b.licensed;
    var _c = (0, page_status_edit_context_1.usePageStatusEditContext)(), currentStatus = _c.currentStatus, currentStatusSet = _c.currentStatusSet, statusesCount = _c.statusesCount, acceptStatusChange = _c.acceptStatusChange;
    var isSubmitDisabled = ((statusForEditor === null || statusForEditor === void 0 ? void 0 : statusForEditor.id) === (currentStatus === null || currentStatus === void 0 ? void 0 : currentStatus.id)) || (0, page_status_edit_service_1.isStatusSetUnknown)(currentStatusSet);
    var onSaveSuccess = function () {
        var params = {
            status: currentStatus,
            statusWidth: currentStatusSet === null || currentStatusSet === void 0 ? void 0 : currentStatusSet.width,
            licensed: licensed,
        };
        acceptStatusChange(params);
        (0, page_status_edit_service_1.trackGA4PageStatusEdited)(statusesCount);
    };
    var onSaveFailure = function (error) {
        console.log(error);
        setIsSaving(false);
        (0, page_status_edit_service_1.showChangeStatusErrorFlagMessage)();
    };
    var onClickSave = (0, react_1.useCallback)(function () {
        if (isSaving || !currentStatus || !currentStatusSet)
            return;
        setIsSaving(true);
        var id = currentStatus.id;
        var statusSetId = currentStatusSet.id;
        (0, status_page_1.fetchUpdatePageStatus)(contentId, id, statusSetId)
            .then(onSaveSuccess)
            .catch(onSaveFailure);
    }, [isSaving, contentId, currentStatus, currentStatusSet, statusesCount]);
    var onClickChangeTab = function (index) {
        if (index === 1 && currentStatus && currentStatusSet)
            (0, page_status_edit_service_1.trackGA4PageStatusHistorySeen)(statusesCount);
    };
    return (react_1.default.createElement(react_1.default.Fragment, null,
        react_1.default.createElement(DialogHeader_1.default, { title: wrm_react_i18n_1.I18n.getText('handy.page-status.dialog.title.change') }),
        react_1.default.createElement(modal_dialog_1.ModalBody, null,
            react_1.default.createElement(tabs_1.default, { id: "dialog-tabs", testId: "dialog-tabs", onChange: onClickChangeTab },
                react_1.default.createElement(tabs_1.TabList, null,
                    react_1.default.createElement(tabs_1.Tab, null, wrm_react_i18n_1.I18n.getText('handy.page-status.dialog.tab.title.status')),
                    react_1.default.createElement(tabs_1.Tab, null, wrm_react_i18n_1.I18n.getText('handy.page-status.dialog.tab.title.history'))),
                react_1.default.createElement(tabs_1.TabPanel, null,
                    react_1.default.createElement(page_status_dialog_style_1.DialogPanelStyled, null,
                        react_1.default.createElement(SelectorSetAndStatus_1.default, null),
                        react_1.default.createElement(ButtonCreateStatusSet_1.default, null))),
                react_1.default.createElement(tabs_1.TabPanel, null,
                    react_1.default.createElement(PageStatusHistory_1.default, null)))),
        react_1.default.createElement(DialogFooterPageStatus_1.default, { isDeletable: true, isSaveLoading: isSaving, onClickSave: onClickSave, isCancelDisabled: isSaving, isSaveDisabled: isSubmitDisabled })));
};
exports["default"] = DialogChangePageStatus;


/***/ }),

/***/ "./src/main/frontend/page-status/dialog/components/DialogConfirmStatusDeletion.tsx":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var react_1 = __importStar(__webpack_require__("./node_modules/react/index.js"));
var button_1 = __importStar(__webpack_require__("./node_modules/@atlaskit/button/dist/esm/index.js"));
var status_page_1 = __webpack_require__("./src/main/frontend/api/backend/status-page.ts");
var modal_dialog_1 = __webpack_require__("./node_modules/@atlaskit/modal-dialog/dist/esm/index.js");
var DialogHeader_1 = __importDefault(__webpack_require__("./src/main/frontend/page-status/dialog/components/DialogHeader.tsx"));
var wrm_react_i18n_1 = __webpack_require__("./node_modules/@atlassian/wrm-react-i18n/wrm-react-i18n.js");
var page_status_dialog_context_1 = __webpack_require__("./src/main/frontend/page-status/dialog/page-status-dialog-context.tsx");
var page_status_edit_context_1 = __webpack_require__("./src/main/frontend/page-status/dialog/page-status-edit-context.tsx");
var page_status_edit_service_1 = __webpack_require__("./src/main/frontend/page-status/services/page-status-edit-service.ts");
var DialogConfirmStatusDeletion = function () {
    var _a = (0, react_1.useState)(false), isDeleting = _a[0], setIsDeleting = _a[1];
    var _b = (0, page_status_dialog_context_1.usePageStatusDialogContext)(), contentId = _b.contentId, licensed = _b.licensed;
    var _c = (0, page_status_edit_context_1.usePageStatusEditContext)(), statusesCount = _c.statusesCount, toggleDeleteModalContent = _c.toggleDeleteModalContent, acceptStatusChange = _c.acceptStatusChange;
    var onDeleteSuccess = function () {
        var params = { licensed: licensed };
        acceptStatusChange(params);
        (0, page_status_edit_service_1.trackGA4PageStatusDeleted)(statusesCount);
    };
    var onDeleteFailure = function (error) {
        console.log(error);
        setIsDeleting(false);
        toggleDeleteModalContent();
        (0, page_status_edit_service_1.showDeleteStatusErrorFlagMessage)();
    };
    var onClickDelete = (0, react_1.useCallback)(function () {
        if (isDeleting)
            return;
        setIsDeleting(true);
        (0, status_page_1.fetchDeletePageStatus)(contentId)
            .then(onDeleteSuccess)
            .catch(onDeleteFailure);
    }, [isDeleting, licensed, contentId, statusesCount]);
    return (react_1.default.createElement(react_1.default.Fragment, null,
        react_1.default.createElement(DialogHeader_1.default, { title: wrm_react_i18n_1.I18n.getText('handy.page-status.dialog.deletion.title') }),
        react_1.default.createElement(modal_dialog_1.ModalBody, null,
            react_1.default.createElement("div", null, wrm_react_i18n_1.I18n.getText('handy.page-status.dialog.deletion.content'))),
        react_1.default.createElement(modal_dialog_1.ModalFooter, null,
            react_1.default.createElement(button_1.default, { appearance: "link", onClick: toggleDeleteModalContent, isDisabled: isDeleting }, wrm_react_i18n_1.I18n.getText('handy.macros.config.cancel')),
            react_1.default.createElement(button_1.LoadingButton, { appearance: "danger", isLoading: isDeleting, onClick: onClickDelete, className: "primary-button" }, wrm_react_i18n_1.I18n.getText('handy.macros.config.delete')))));
};
exports["default"] = DialogConfirmStatusDeletion;


/***/ }),

/***/ "./src/main/frontend/page-status/dialog/components/DialogHeader.tsx":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var react_1 = __importDefault(__webpack_require__("./node_modules/react/index.js"));
var modal_dialog_1 = __webpack_require__("./node_modules/@atlaskit/modal-dialog/dist/esm/index.js");
var DialogHeader = function (_a) {
    var title = _a.title;
    return (react_1.default.createElement(modal_dialog_1.ModalHeader, null,
        react_1.default.createElement(modal_dialog_1.ModalTitle, null, title)));
};
exports["default"] = DialogHeader;


/***/ }),

/***/ "./src/main/frontend/page-status/dialog/components/DialogSpinner.tsx":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var react_1 = __importDefault(__webpack_require__("./node_modules/react/index.js"));
var spinner_1 = __importDefault(__webpack_require__("./node_modules/@atlaskit/spinner/dist/esm/index.js"));
var page_status_dialog_style_1 = __webpack_require__("./src/main/frontend/page-status/dialog/page-status-dialog.style.ts");
var DialogSpinner = function () { return (react_1.default.createElement(page_status_dialog_style_1.CenteredContainer, null,
    react_1.default.createElement(spinner_1.default, { size: "xlarge" }))); };
exports["default"] = DialogSpinner;


/***/ }),

/***/ "./src/main/frontend/page-status/dialog/components/PageStatusDialog.tsx":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var react_1 = __importStar(__webpack_require__("./node_modules/react/index.js"));
var modal_dialog_1 = __webpack_require__("./node_modules/@atlaskit/modal-dialog/dist/esm/index.js");
var use_async_state_1 = __importDefault(__webpack_require__("./src/main/frontend/page-status/dialog/components/hooks/use-async-state.ts"));
var page_status_context_service_1 = __webpack_require__("./src/main/frontend/page-status/services/page-status-context-service.ts");
var page_status_edit_service_1 = __webpack_require__("./src/main/frontend/page-status/services/page-status-edit-service.ts");
var page_status_service_1 = __webpack_require__("./src/main/frontend/page-status/services/page-status-service.ts");
var page_status_dialog_context_1 = __webpack_require__("./src/main/frontend/page-status/dialog/page-status-dialog-context.tsx");
var PageStatusEdit_1 = __importDefault(__webpack_require__("./src/main/frontend/page-status/dialog/components/PageStatusEdit.tsx"));
var PageStatusDialog = function (_a) {
    var viewStatusId = _a.viewStatusId;
    var _b = (0, use_async_state_1.default)(page_status_dialog_context_1.PAGE_STATUS_DIALOG_CONTEXT_DEFAULT_VALUE, page_status_context_service_1.getPageStatusDialogContextData), context = _b[0], isLoading = _b[1], error = _b[2];
    var _c = (0, react_1.useState)(true), showPageStatusEdit = _c[0], setShowPageStatusEdit = _c[1];
    (0, react_1.useEffect)(function () {
        if (error) {
            closeDialog();
            (0, page_status_edit_service_1.showGetStatusContextErrorFlagMessage)();
        }
    }, [error]);
    var closeDialog = function () {
        setShowPageStatusEdit(false);
        (0, page_status_service_1.removePageStatusAjsDialog)();
    };
    if (!showPageStatusEdit) {
        return null;
    }
    return (react_1.default.createElement(page_status_dialog_context_1.PageStatusDialogContextProvider, { contextData: __assign(__assign({}, context), { closeDialog: closeDialog }) },
        react_1.default.createElement(modal_dialog_1.ModalTransition, null,
            react_1.default.createElement(PageStatusEdit_1.default, { isDialogContextLoading: isLoading, viewStatusId: viewStatusId }))));
};
exports["default"] = PageStatusDialog;


/***/ }),

/***/ "./src/main/frontend/page-status/dialog/components/PageStatusEdit.tsx":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var react_1 = __importStar(__webpack_require__("./node_modules/react/index.js"));
var modal_dialog_1 = __importDefault(__webpack_require__("./node_modules/@atlaskit/modal-dialog/dist/esm/index.js"));
var use_dialog_modal_1 = __importDefault(__webpack_require__("./src/main/frontend/page-status/dialog/components/hooks/use-dialog-modal.ts"));
var page_status_dialog_context_1 = __webpack_require__("./src/main/frontend/page-status/dialog/page-status-dialog-context.tsx");
var page_status_service_1 = __webpack_require__("./src/main/frontend/page-status/services/page-status-service.ts");
var page_status_edit_context_1 = __webpack_require__("./src/main/frontend/page-status/dialog/page-status-edit-context.tsx");
var page_status_edit_service_1 = __webpack_require__("./src/main/frontend/page-status/services/page-status-edit-service.ts");
var DialogSpinner_1 = __importDefault(__webpack_require__("./src/main/frontend/page-status/dialog/components/DialogSpinner.tsx"));
var DialogChangePageStatus_1 = __importDefault(__webpack_require__("./src/main/frontend/page-status/dialog/components/DialogChangePageStatus.tsx"));
var DialogAddPageStatus_1 = __importDefault(__webpack_require__("./src/main/frontend/page-status/dialog/components/DialogAddPageStatus.tsx"));
var DialogConfirmStatusDeletion_1 = __importDefault(__webpack_require__("./src/main/frontend/page-status/dialog/components/DialogConfirmStatusDeletion.tsx"));
var PageStatusEdit = function (_a) {
    var viewStatusId = _a.viewStatusId, isDialogContextLoading = _a.isDialogContextLoading;
    var _b = (0, react_1.useState)(page_status_edit_context_1.PAGE_STATUS_EDIT_CONTEXT_DEFAULT_VALUE), statusEditContext = _b[0], setStatusEditContext = _b[1];
    var _c = (0, react_1.useState)(false), isDeleteModalContentOpened = _c[0], setIsDeleteModalContentOpened = _c[1];
    var _d = (0, use_dialog_modal_1.default)(), isDialogSpinnerOpened = _d.isOpen, toggleDialogSpinner = _d.toggle;
    var _e = (0, use_dialog_modal_1.default)(), isDialogAddPageStatusOpened = _e.isOpen, toggleDialogAddPageStatus = _e.toggle;
    var _f = (0, use_dialog_modal_1.default)(), isDialogChangePageStatusOpened = _f.isOpen, toggleDialogChangePageStatus = _f.toggle;
    var _g = (0, use_dialog_modal_1.default)(), isDialogConfirmStatusDeletionOpened = _g.isOpen, toggleDialogConfirmStatusDeletion = _g.toggle;
    var _h = (0, page_status_dialog_context_1.usePageStatusDialogContext)(), statusForEditor = _h.statusForEditor, statusSetForEditor = _h.statusSetForEditor, isPageStatusPropertyExists = _h.isPageStatusPropertyExists, licensed = _h.licensed, closeDialog = _h.closeDialog;
    var reRenderPageStatusIfNeeded = function () {
        var shouldReRenderDueToMissingStatus = !!viewStatusId && !isPageStatusPropertyExists;
        var shouldReRenderDueToStatusChange = (!viewStatusId && statusForEditor && isPageStatusPropertyExists) ||
            (!!viewStatusId && viewStatusId !== (statusForEditor === null || statusForEditor === void 0 ? void 0 : statusForEditor.id));
        if (!shouldReRenderDueToMissingStatus && !shouldReRenderDueToStatusChange)
            return;
        var updatedPageStatus = { licensed: licensed };
        if (shouldReRenderDueToStatusChange && !shouldReRenderDueToMissingStatus) {
            updatedPageStatus.status = statusForEditor;
            updatedPageStatus.statusWidth = statusSetForEditor === null || statusSetForEditor === void 0 ? void 0 : statusSetForEditor.width;
        }
        (0, page_status_service_1.triggerPageStatusUpdate)(updatedPageStatus);
    };
    (0, react_1.useEffect)(function () {
        if (!isDialogContextLoading) {
            reRenderPageStatusIfNeeded();
            setStatusEditContext(function (prevState) { return (__assign(__assign({}, prevState), { currentStatus: statusForEditor, currentStatusSet: statusSetForEditor })); });
        }
    }, [isDialogContextLoading]);
    (0, react_1.useEffect)(function () {
        if (!isDialogContextLoading) {
            var showDialogChangePageStatus = !!statusForEditor && isPageStatusPropertyExists;
            toggleDialogChangePageStatus(showDialogChangePageStatus && !isDeleteModalContentOpened);
            toggleDialogAddPageStatus(!showDialogChangePageStatus && !isDeleteModalContentOpened);
            toggleDialogConfirmStatusDeletion(isDeleteModalContentOpened);
        }
        toggleDialogSpinner(isDialogContextLoading);
    }, [isDialogContextLoading, isDeleteModalContentOpened, statusForEditor, isPageStatusPropertyExists]);
    var toggleDeleteModalContent = function () {
        setIsDeleteModalContentOpened(!isDeleteModalContentOpened);
    };
    var changeCurrentStatus = function (status) {
        setStatusEditContext(function (prevState) { return (__assign(__assign({}, prevState), { currentStatus: status })); });
    };
    var changeCurrentStatusSet = function (statusSet) {
        setStatusEditContext(function (prevState) { return (__assign(__assign({}, prevState), { currentStatusSet: statusSet })); });
    };
    var cancelStatusChange = (0, react_1.useCallback)(function () {
        closeDialog();
    }, []);
    var acceptStatusChange = (0, react_1.useCallback)(function (params) {
        (0, page_status_service_1.triggerPageStatusUpdate)(params);
        closeDialog();
    }, []);
    var refreshStatusesCount = function (statusesCount) {
        setStatusEditContext(function (prevState) { return (__assign(__assign({}, prevState), { statusesCount: statusesCount })); });
    };
    return (react_1.default.createElement(page_status_edit_context_1.PageStatusDialogEditProvider, { contextData: __assign(__assign({}, statusEditContext), { toggleDeleteModalContent: toggleDeleteModalContent, changeCurrentStatus: changeCurrentStatus, changeCurrentStatusSet: changeCurrentStatusSet, refreshStatusesCount: refreshStatusesCount, cancelStatusChange: cancelStatusChange, acceptStatusChange: acceptStatusChange }) },
        react_1.default.createElement(modal_dialog_1.default, { testId: "hm-page-status-dialog-modal", shouldCloseOnEscapePress: false, shouldCloseOnOverlayClick: false, shouldScrollInViewport: true, width: isDeleteModalContentOpened ? 'medium' : page_status_edit_service_1.PAGE_STATUS_DIALOG_WIDTH, height: isDeleteModalContentOpened ? '' : page_status_edit_service_1.PAGE_STATUS_DIALOG_HEIGHT },
            isDialogSpinnerOpened && react_1.default.createElement(DialogSpinner_1.default, null),
            isDialogAddPageStatusOpened && react_1.default.createElement(DialogAddPageStatus_1.default, null),
            isDialogChangePageStatusOpened && react_1.default.createElement(DialogChangePageStatus_1.default, null),
            isDialogConfirmStatusDeletionOpened && react_1.default.createElement(DialogConfirmStatusDeletion_1.default, null))));
};
exports["default"] = PageStatusEdit;


/***/ }),

/***/ "./src/main/frontend/page-status/dialog/components/controls/FieldSelectSet.tsx":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var react_1 = __importStar(__webpack_require__("./node_modules/react/index.js"));
var wrm_react_i18n_1 = __webpack_require__("./node_modules/@atlassian/wrm-react-i18n/wrm-react-i18n.js");
var form_1 = __webpack_require__("./node_modules/@atlaskit/form/dist/esm/index.js");
var select_1 = __importDefault(__webpack_require__("./node_modules/@atlaskit/select/dist/esm/index.js"));
var page_status_options_service_1 = __webpack_require__("./src/main/frontend/page-status/services/page-status-options-service.ts");
var status_macro_settings_1 = __webpack_require__("./src/main/frontend/api/backend/status-macro-settings.ts");
var FieldSelectSet = function (_a) {
    var statusSet = _a.statusSet, onChange = _a.onChange, _b = _a.isDisabled, isDisabled = _b === void 0 ? false : _b;
    var _c = (0, react_1.useState)((0, page_status_options_service_1.makeSelectStatusSetOptionType)(statusSet)), value = _c[0], setValue = _c[1];
    var _d = (0, react_1.useState)([]), options = _d[0], setOptions = _d[1];
    var _e = (0, react_1.useState)(false), isLoading = _e[0], setIsLoading = _e[1];
    (0, react_1.useEffect)(function () {
        if (isDisabled)
            return;
        setIsLoading(true);
        (0, status_macro_settings_1.fetchStatusSets)()
            .then(function (statusSets) { return setOptions((0, page_status_options_service_1.toSelectStatusSetGroupOptionType)(statusSets)); })
            .catch(console.error)
            .finally(function () { return setIsLoading(false); });
    }, [isDisabled]);
    (0, react_1.useEffect)(function () { return setValue((0, page_status_options_service_1.makeSelectStatusSetOptionType)(statusSet)); }, [statusSet === null || statusSet === void 0 ? void 0 : statusSet.id]);
    return (react_1.default.createElement(form_1.Field, { isRequired: true, label: wrm_react_i18n_1.I18n.getText('com.stiltsoft.confluence.handy.macros.status-handy.param.set.label'), name: "set" }, function (fieldProps) { return (react_1.default.createElement(select_1.default, __assign({}, fieldProps, { value: value, blurInputOnSelect: true, spacing: "compact", options: options, menuPosition: "fixed", isLoading: isLoading, isDisabled: isDisabled, className: "select-status-set", placeholder: wrm_react_i18n_1.I18n.getText('com.stiltsoft.confluence.handy.macros.status-handy.param.set.placeholder'), onChange: function (option) { return option ? onChange(option.statusSet) : undefined; } }))); }));
};
exports["default"] = FieldSelectSet;


/***/ }),

/***/ "./src/main/frontend/page-status/dialog/components/controls/FieldSelectStatus.tsx":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var react_1 = __importStar(__webpack_require__("./node_modules/react/index.js"));
var wrm_react_i18n_1 = __webpack_require__("./node_modules/@atlassian/wrm-react-i18n/wrm-react-i18n.js");
var form_1 = __webpack_require__("./node_modules/@atlaskit/form/dist/esm/index.js");
var select_1 = __importDefault(__webpack_require__("./node_modules/@atlaskit/select/dist/esm/index.js"));
var page_status_options_service_1 = __webpack_require__("./src/main/frontend/page-status/services/page-status-options-service.ts");
var StatusPreview_1 = __importDefault(__webpack_require__("./src/main/frontend/shared/components/StatusPreview.tsx"));
var status_macro_settings_1 = __webpack_require__("./src/main/frontend/api/backend/status-macro-settings.ts");
var page_status_edit_context_1 = __webpack_require__("./src/main/frontend/page-status/dialog/page-status-edit-context.tsx");
var FieldSelectStatus = function (_a) {
    var status = _a.status, statusSet = _a.statusSet, onChange = _a.onChange, _b = _a.isDisabled, isDisabled = _b === void 0 ? false : _b;
    var _c = (0, react_1.useState)((0, page_status_options_service_1.makeSelectStatusOptionType)(status)), value = _c[0], setValue = _c[1];
    var _d = (0, react_1.useState)([]), options = _d[0], setOptions = _d[1];
    var _e = (0, react_1.useState)(false), isLoading = _e[0], setIsLoading = _e[1];
    var refreshStatusesCount = (0, page_status_edit_context_1.usePageStatusEditContext)().refreshStatusesCount;
    var toStatusOptionLabel = function (option, labelMeta) {
        if (labelMeta.context === 'value') {
            return option.label;
        }
        var status = option.status;
        var name = status.name, textColor = status.textColor, backgroundColor = status.backgroundColor;
        return react_1.default.createElement(StatusPreview_1.default, { textColor: textColor, backgroundColor: backgroundColor, name: name, minWidth: statusSet.width });
    };
    var onFetchSetStatusesSuccess = function (statuses) {
        var _a;
        setOptions((0, page_status_options_service_1.toSelectStatusOptionTypes)(statuses));
        refreshStatusesCount(statuses.length);
        var selectedStatusId = (_a = status === null || status === void 0 ? void 0 : status.id) !== null && _a !== void 0 ? _a : -1;
        var isStatusSelected = !!statuses.find(function (element) { return element.id === selectedStatusId; });
        if (!isStatusSelected)
            onChange(statuses.length ? statuses[0] : undefined);
    };
    (0, react_1.useEffect)(function () {
        if (isDisabled)
            return;
        setIsLoading(true);
        (0, status_macro_settings_1.fetchSetStatuses)(statusSet.id)
            .then(onFetchSetStatusesSuccess)
            .catch(console.error)
            .finally(function () { return setIsLoading(false); });
    }, [statusSet, isDisabled]);
    (0, react_1.useEffect)(function () { return setValue((0, page_status_options_service_1.makeSelectStatusOptionType)(status)); }, [status === null || status === void 0 ? void 0 : status.id]);
    return (react_1.default.createElement(form_1.Field, { isRequired: true, label: wrm_react_i18n_1.I18n.getText('com.stiltsoft.confluence.handy.macros.status-handy.param.status.label'), name: "status" }, function (fieldProps) { return (react_1.default.createElement(select_1.default, __assign({}, fieldProps, { value: value, spacing: "compact", blurInputOnSelect: true, options: options, menuPosition: "fixed", isLoading: isLoading, isDisabled: isDisabled, className: "select-status", placeholder: wrm_react_i18n_1.I18n.getText('com.stiltsoft.confluence.handy.macros.status-handy.param.status.placeholder'), formatOptionLabel: toStatusOptionLabel, onChange: function (option) { return onChange(option === null || option === void 0 ? void 0 : option.status); } }))); }));
};
exports["default"] = FieldSelectStatus;


/***/ }),

/***/ "./src/main/frontend/page-status/dialog/components/controls/SelectorSetAndStatus.tsx":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var react_1 = __importDefault(__webpack_require__("./node_modules/react/index.js"));
var page_status_dialog_context_1 = __webpack_require__("./src/main/frontend/page-status/dialog/page-status-dialog-context.tsx");
var page_status_edit_context_1 = __webpack_require__("./src/main/frontend/page-status/dialog/page-status-edit-context.tsx");
var FieldSelectSet_1 = __importDefault(__webpack_require__("./src/main/frontend/page-status/dialog/components/controls/FieldSelectSet.tsx"));
var page_status_edit_service_1 = __webpack_require__("./src/main/frontend/page-status/services/page-status-edit-service.ts");
var FieldSelectStatus_1 = __importDefault(__webpack_require__("./src/main/frontend/page-status/dialog/components/controls/FieldSelectStatus.tsx"));
var SelectorSetAndStatus = function () {
    var canUserEditContent = (0, page_status_dialog_context_1.usePageStatusDialogContext)().canUserEditContent;
    var _a = (0, page_status_edit_context_1.usePageStatusEditContext)(), currentStatus = _a.currentStatus, currentStatusSet = _a.currentStatusSet, changeCurrentStatus = _a.changeCurrentStatus, changeCurrentStatusSet = _a.changeCurrentStatusSet;
    return (react_1.default.createElement("div", { className: "select-set-status-controls" },
        react_1.default.createElement(FieldSelectSet_1.default, { statusSet: currentStatusSet, onChange: changeCurrentStatusSet, isDisabled: !canUserEditContent }),
        (!!currentStatusSet && !(0, page_status_edit_service_1.isStatusSetUnknown)(currentStatusSet)) &&
            react_1.default.createElement(FieldSelectStatus_1.default, { status: currentStatus, onChange: changeCurrentStatus, statusSet: currentStatusSet, isDisabled: !canUserEditContent })));
};
exports["default"] = SelectorSetAndStatus;


/***/ }),

/***/ "./src/main/frontend/page-status/dialog/components/footer/ButtonCancel.tsx":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var react_1 = __importDefault(__webpack_require__("./node_modules/react/index.js"));
var wrm_react_i18n_1 = __webpack_require__("./node_modules/@atlassian/wrm-react-i18n/wrm-react-i18n.js");
var button_1 = __importDefault(__webpack_require__("./node_modules/@atlaskit/button/dist/esm/index.js"));
var ButtonCancel = function (_a) {
    var onClick = _a.onClick, isDisabled = _a.isDisabled, appearance = _a.appearance;
    return (react_1.default.createElement(button_1.default, { onClick: onClick, id: "hm-dialog-button-cancel", appearance: appearance, isDisabled: isDisabled }, wrm_react_i18n_1.I18n.getText('handy.macros.config.cancel')));
};
exports["default"] = ButtonCancel;


/***/ }),

/***/ "./src/main/frontend/page-status/dialog/components/footer/ButtonDelete.tsx":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var react_1 = __importDefault(__webpack_require__("./node_modules/react/index.js"));
var wrm_react_i18n_1 = __webpack_require__("./node_modules/@atlassian/wrm-react-i18n/wrm-react-i18n.js");
var button_1 = __importDefault(__webpack_require__("./node_modules/@atlaskit/button/dist/esm/index.js"));
var ButtonDelete = function (_a) {
    var onClick = _a.onClick, isDisabled = _a.isDisabled;
    return (react_1.default.createElement(button_1.default, { onClick: onClick, appearance: "link", id: "hm-dialog-button-delete", isDisabled: isDisabled }, wrm_react_i18n_1.I18n.getText('handy.macros.config.delete')));
};
exports["default"] = ButtonDelete;


/***/ }),

/***/ "./src/main/frontend/page-status/dialog/components/footer/ButtonDocumentation.tsx":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var react_1 = __importDefault(__webpack_require__("./node_modules/react/index.js"));
var wrm_react_i18n_1 = __webpack_require__("./node_modules/@atlassian/wrm-react-i18n/wrm-react-i18n.js");
var tooltip_1 = __importDefault(__webpack_require__("./node_modules/@atlaskit/tooltip/dist/esm/index.js"));
var info_1 = __importDefault(__webpack_require__("./node_modules/@atlaskit/icon/glyph/info.js"));
var tokens_1 = __webpack_require__("./node_modules/@atlaskit/tokens/dist/esm/index.js");
var page_status_edit_service_1 = __webpack_require__("./src/main/frontend/page-status/services/page-status-edit-service.ts");
var atlaskit_colors_1 = __importDefault(__webpack_require__("./src/main/frontend/shared/atlaskit-colors.ts"));
var ButtonDocumentation = function () { return (react_1.default.createElement("div", { id: "button-documentation", onClick: page_status_edit_service_1.openPageStatusDocsPage },
    react_1.default.createElement(tooltip_1.default, { content: wrm_react_i18n_1.I18n.getText('handy.page-status.dialog.button.documentation.hint') },
        react_1.default.createElement(info_1.default, { size: "medium", primaryColor: (0, tokens_1.token)('color.icon', atlaskit_colors_1.default.N500), label: wrm_react_i18n_1.I18n.getText('handy.page-status.dialog.button.documentation.hint') })))); };
exports["default"] = ButtonDocumentation;


/***/ }),

/***/ "./src/main/frontend/page-status/dialog/components/footer/ButtonHelp.tsx":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var react_1 = __importDefault(__webpack_require__("./node_modules/react/index.js"));
var wrm_react_i18n_1 = __webpack_require__("./node_modules/@atlassian/wrm-react-i18n/wrm-react-i18n.js");
var question_circle_1 = __importDefault(__webpack_require__("./node_modules/@atlaskit/icon/glyph/question-circle.js"));
var tooltip_1 = __importDefault(__webpack_require__("./node_modules/@atlaskit/tooltip/dist/esm/index.js"));
var tokens_1 = __webpack_require__("./node_modules/@atlaskit/tokens/dist/esm/index.js");
var page_status_edit_service_1 = __webpack_require__("./src/main/frontend/page-status/services/page-status-edit-service.ts");
var ButtonHelp = function () { return (react_1.default.createElement("div", { id: "button-help", onClick: page_status_edit_service_1.openReportIssuePage },
    react_1.default.createElement(tooltip_1.default, { content: wrm_react_i18n_1.I18n.getText('handy.page-status.dialog.button.help.hint') },
        react_1.default.createElement(question_circle_1.default, { size: "medium", primaryColor: (0, tokens_1.token)('color.icon'), label: wrm_react_i18n_1.I18n.getText('handy.page-status.dialog.button.help.hint') })))); };
exports["default"] = ButtonHelp;


/***/ }),

/***/ "./src/main/frontend/page-status/dialog/components/footer/ButtonSave.tsx":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var react_1 = __importDefault(__webpack_require__("./node_modules/react/index.js"));
var wrm_react_i18n_1 = __webpack_require__("./node_modules/@atlassian/wrm-react-i18n/wrm-react-i18n.js");
var button_1 = __webpack_require__("./node_modules/@atlaskit/button/dist/esm/index.js");
var ButtonSave = function (_a) {
    var onClick = _a.onClick, isLoading = _a.isLoading, isDisabled = _a.isDisabled;
    return (react_1.default.createElement(button_1.LoadingButton, { id: "hm-dialog-button-save", onClick: onClick, appearance: "primary", isLoading: isLoading, isDisabled: isDisabled }, wrm_react_i18n_1.I18n.getText('handy.macros.config.save')));
};
exports["default"] = ButtonSave;


/***/ }),

/***/ "./src/main/frontend/page-status/dialog/components/footer/DialogFooterPageStatus.tsx":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var react_1 = __importStar(__webpack_require__("./node_modules/react/index.js"));
var button_1 = __webpack_require__("./node_modules/@atlaskit/button/dist/esm/index.js");
var modal_dialog_1 = __webpack_require__("./node_modules/@atlaskit/modal-dialog/dist/esm/index.js");
var page_status_dialog_context_1 = __webpack_require__("./src/main/frontend/page-status/dialog/page-status-dialog-context.tsx");
var page_status_edit_context_1 = __webpack_require__("./src/main/frontend/page-status/dialog/page-status-edit-context.tsx");
var page_status_dialog_style_1 = __webpack_require__("./src/main/frontend/page-status/dialog/page-status-dialog.style.ts");
var ButtonHelp_1 = __importDefault(__webpack_require__("./src/main/frontend/page-status/dialog/components/footer/ButtonHelp.tsx"));
var ButtonDocumentation_1 = __importDefault(__webpack_require__("./src/main/frontend/page-status/dialog/components/footer/ButtonDocumentation.tsx"));
var ButtonDelete_1 = __importDefault(__webpack_require__("./src/main/frontend/page-status/dialog/components/footer/ButtonDelete.tsx"));
var ButtonCancel_1 = __importDefault(__webpack_require__("./src/main/frontend/page-status/dialog/components/footer/ButtonCancel.tsx"));
var ButtonSave_1 = __importDefault(__webpack_require__("./src/main/frontend/page-status/dialog/components/footer/ButtonSave.tsx"));
var page_status_edit_service_1 = __webpack_require__("./src/main/frontend/page-status/services/page-status-edit-service.ts");
var DialogFooterPageStatus = function (_a) {
    var isCancelDisabled = _a.isCancelDisabled, isSaveDisabled = _a.isSaveDisabled, isSaveLoading = _a.isSaveLoading, _b = _a.isDeletable, isDeletable = _b === void 0 ? false : _b, onClickSave = _a.onClickSave;
    var canUserEditContent = (0, page_status_dialog_context_1.usePageStatusDialogContext)().canUserEditContent;
    var _c = (0, page_status_edit_context_1.usePageStatusEditContext)(), statusesCount = _c.statusesCount, cancelStatusChange = _c.cancelStatusChange, toggleDeleteModalContent = _c.toggleDeleteModalContent;
    var onClickDelete = (0, react_1.useCallback)(function () {
        toggleDeleteModalContent();
        (0, page_status_edit_service_1.trackGA4PageStatusDeleteClicked)(statusesCount);
    }, [statusesCount]);
    return (react_1.default.createElement(modal_dialog_1.ModalFooter, null,
        react_1.default.createElement(page_status_dialog_style_1.DialogFooterActionsStyled, null,
            react_1.default.createElement("div", { className: "dialog-footer-left-container" },
                react_1.default.createElement(ButtonHelp_1.default, null),
                react_1.default.createElement(ButtonDocumentation_1.default, null)),
            react_1.default.createElement("div", { className: "dialog-footer-reight-container" },
                react_1.default.createElement(button_1.ButtonGroup, null,
                    isDeletable && react_1.default.createElement(ButtonDelete_1.default, { onClick: onClickDelete, isDisabled: !canUserEditContent }),
                    react_1.default.createElement(ButtonCancel_1.default, { onClick: cancelStatusChange, isDisabled: isCancelDisabled, appearance: isDeletable ? 'default' : 'link' }),
                    react_1.default.createElement(ButtonSave_1.default, { onClick: onClickSave, isLoading: isSaveLoading, isDisabled: isSaveDisabled }))))));
};
exports["default"] = DialogFooterPageStatus;


/***/ }),

/***/ "./src/main/frontend/page-status/dialog/components/history/PageStatusHistory.tsx":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var react_1 = __importStar(__webpack_require__("./node_modules/react/index.js"));
var page_status_dialog_context_1 = __webpack_require__("./src/main/frontend/page-status/dialog/page-status-dialog-context.tsx");
var status_page_1 = __webpack_require__("./src/main/frontend/api/backend/status-page.ts");
var StatusHistoryStateless_1 = __importDefault(__webpack_require__("./src/main/frontend/page-status/dialog/components/history/StatusHistoryStateless.tsx"));
var PageStatusHistoryEmptyState_1 = __importDefault(__webpack_require__("./src/main/frontend/page-status/dialog/components/history/PageStatusHistoryEmptyState.tsx"));
var PageStatusHistory = function () {
    var _a = (0, react_1.useState)([]), history = _a[0], setHistory = _a[1];
    var _b = (0, react_1.useState)(true), isLoading = _b[0], setIsLoading = _b[1];
    var contentId = (0, page_status_dialog_context_1.usePageStatusDialogContext)().contentId;
    (0, react_1.useEffect)(function () {
        (0, status_page_1.fetchPageStatusHistory)(contentId)
            .then(function (history) { return setHistory(history); })
            .catch(console.error)
            .finally(function () { return setIsLoading(false); });
    }, []);
    return (react_1.default.createElement(StatusHistoryStateless_1.default, { rowsPerPage: 4, history: history, isLoading: isLoading, emptyState: react_1.default.createElement(PageStatusHistoryEmptyState_1.default, null) }));
};
exports["default"] = PageStatusHistory;


/***/ }),

/***/ "./src/main/frontend/page-status/dialog/components/history/PageStatusHistoryEmptyState.tsx":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var react_1 = __importDefault(__webpack_require__("./node_modules/react/index.js"));
var wrm_react_i18n_1 = __webpack_require__("./node_modules/@atlassian/wrm-react-i18n/wrm-react-i18n.js");
var page_status_dialog_style_1 = __webpack_require__("./src/main/frontend/page-status/dialog/page-status-dialog.style.ts");
var PageStatusHistoryEmptyState = function () { return (react_1.default.createElement(page_status_dialog_style_1.PageStatusHistoryEmptyStateStyled, null,
    react_1.default.createElement("h4", null, wrm_react_i18n_1.I18n.getText('handy.page-status.dialog.empty-state.title')),
    react_1.default.createElement("p", null, wrm_react_i18n_1.I18n.getText('handy.page-status.dialog.empty-state.description')))); };
exports["default"] = PageStatusHistoryEmptyState;


/***/ }),

/***/ "./src/main/frontend/page-status/dialog/components/history/StatusHistoryStateless.tsx":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var react_1 = __importDefault(__webpack_require__("./node_modules/react/index.js"));
var wrm_react_i18n_1 = __webpack_require__("./node_modules/@atlassian/wrm-react-i18n/wrm-react-i18n.js");
var spinner_1 = __importDefault(__webpack_require__("./node_modules/@atlaskit/spinner/dist/esm/index.js"));
var dynamic_table_1 = __importDefault(__webpack_require__("./node_modules/@atlaskit/dynamic-table/dist/esm/index.js"));
var HistoryChangeItemDate_1 = __importDefault(__webpack_require__("./src/main/frontend/page-status/dialog/components/history/item/HistoryChangeItemDate.tsx"));
var HistoryChangeItemUser_1 = __importDefault(__webpack_require__("./src/main/frontend/page-status/dialog/components/history/item/HistoryChangeItemUser.tsx"));
var HistoryChangeItemTransition_1 = __importDefault(__webpack_require__("./src/main/frontend/page-status/dialog/components/history/item/HistoryChangeItemTransition.tsx"));
var page_status_dialog_style_1 = __webpack_require__("./src/main/frontend/page-status/dialog/page-status-dialog.style.ts");
var head = {
    cells: [
        {
            key: 'date',
            content: "".concat(wrm_react_i18n_1.I18n.getText('handy.page-status.dialog.history.table.column.date')),
            isSortable: false,
        },
        {
            key: 'user',
            content: "".concat(wrm_react_i18n_1.I18n.getText('handy.page-status.dialog.history.table.column.user')),
            isSortable: false,
        },
        {
            key: 'update',
            content: "".concat(wrm_react_i18n_1.I18n.getText('handy.page-status.dialog.history.table.column.status-update')),
            isSortable: false,
        },
    ],
};
var getRows = function (history) {
    return history.map(function (change, index) { return ({
        key: "row-".concat(index),
        cells: [
            {
                key: "date-".concat(index),
                content: react_1.default.createElement(HistoryChangeItemDate_1.default, { date: change.date }),
            },
            {
                key: "user-".concat(index),
                content: react_1.default.createElement(HistoryChangeItemUser_1.default, { user: change === null || change === void 0 ? void 0 : change.user }),
            },
            {
                key: "update-".concat(index),
                content: (react_1.default.createElement(HistoryChangeItemTransition_1.default, { prevStatus: change.oldStatus, currentStatus: change.newStatus, currentStatusWidth: change.newStatusWidth, prevStatusWidth: change.oldStatusWidth })),
            },
        ],
    }); });
};
var StatusHistoryStateless = function (_a) {
    var isLoading = _a.isLoading, history = _a.history, rowsPerPage = _a.rowsPerPage, emptyState = _a.emptyState;
    if (isLoading)
        return (react_1.default.createElement(page_status_dialog_style_1.CenteredContainer, null,
            react_1.default.createElement(spinner_1.default, { size: "xlarge" })));
    if (!history.length)
        return emptyState;
    return (react_1.default.createElement(page_status_dialog_style_1.HistoryTableStyled, null,
        react_1.default.createElement(dynamic_table_1.default, { head: head, isFixedSize: true, defaultPage: 1, testId: "history-table", rows: getRows(history), rowsPerPage: rowsPerPage })));
};
exports["default"] = StatusHistoryStateless;


/***/ }),

/***/ "./src/main/frontend/page-status/dialog/components/history/item/HistoryChangeItemDate.tsx":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var react_1 = __importDefault(__webpack_require__("./node_modules/react/index.js"));
var HistoryChangeItemDate = function (_a) {
    var date = _a.date;
    return react_1.default.createElement("div", { className: "snapshot-date" }, date);
};
exports["default"] = HistoryChangeItemDate;


/***/ }),

/***/ "./src/main/frontend/page-status/dialog/components/history/item/HistoryChangeItemTransition.tsx":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var react_1 = __importDefault(__webpack_require__("./node_modules/react/index.js"));
var wrm_react_i18n_1 = __webpack_require__("./node_modules/@atlassian/wrm-react-i18n/wrm-react-i18n.js");
var StatusPreview_1 = __importDefault(__webpack_require__("./src/main/frontend/shared/components/StatusPreview.tsx"));
var PreviousStatus = function (_a) {
    var status = _a.status, minWidth = _a.minWidth;
    return (react_1.default.createElement(react_1.default.Fragment, null,
        react_1.default.createElement(StatusPreview_1.default, { name: status.name, textColor: status.textColor, backgroundColor: status.backgroundColor, minWidth: minWidth }),
        react_1.default.createElement("span", null, "\u2192")));
};
var getPrevStatusView = function (prevStatus, prevStatusWidth) {
    if (!prevStatus) {
        return react_1.default.createElement("span", null,
            wrm_react_i18n_1.I18n.getText('handy.macros.status.history.created'),
            " ");
    }
    return react_1.default.createElement(PreviousStatus, { status: prevStatus, minWidth: prevStatusWidth });
};
var HistoryChangeItemTransition = function (_a) {
    var prevStatus = _a.prevStatus, currentStatus = _a.currentStatus, currentStatusWidth = _a.currentStatusWidth, prevStatusWidth = _a.prevStatusWidth;
    return (react_1.default.createElement("div", { className: "status-update" },
        getPrevStatusView(prevStatus, prevStatusWidth),
        react_1.default.createElement(StatusPreview_1.default, { name: currentStatus.name, textColor: currentStatus.textColor, backgroundColor: currentStatus.backgroundColor, minWidth: currentStatusWidth })));
};
exports["default"] = HistoryChangeItemTransition;


/***/ }),

/***/ "./src/main/frontend/page-status/dialog/components/history/item/HistoryChangeItemUser.tsx":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var react_1 = __importDefault(__webpack_require__("./node_modules/react/index.js"));
var ConfluenceUserAvatar_1 = __importDefault(__webpack_require__("./src/main/frontend/page-status/dialog/components/history/item/user/ConfluenceUserAvatar.tsx"));
var ConfluenceUserLink_1 = __importDefault(__webpack_require__("./src/main/frontend/page-status/dialog/components/history/item/user/ConfluenceUserLink.tsx"));
var HistoryChangeItemUser = function (_a) {
    var user = _a.user;
    return (react_1.default.createElement("div", { className: "snapshot-user" },
        react_1.default.createElement(ConfluenceUserAvatar_1.default, { user: user }),
        react_1.default.createElement(ConfluenceUserLink_1.default, { user: user })));
};
exports["default"] = HistoryChangeItemUser;


/***/ }),

/***/ "./src/main/frontend/page-status/dialog/components/history/item/user/ConfluenceUserAvatar.tsx":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var react_1 = __importDefault(__webpack_require__("./node_modules/react/index.js"));
var avatar_1 = __importDefault(__webpack_require__("./node_modules/@atlaskit/avatar/dist/esm/index.js"));
var page_status_edit_service_1 = __webpack_require__("./src/main/frontend/page-status/services/page-status-edit-service.ts");
var ConfluenceUserAvatar = function (_a) {
    var user = _a.user;
    if (!(user === null || user === void 0 ? void 0 : user.avatarUrl))
        return null;
    return react_1.default.createElement(avatar_1.default, { size: "xsmall", appearance: "square", src: (0, page_status_edit_service_1.getConfluenceAvatarUrl)(user.avatarUrl) });
};
exports["default"] = ConfluenceUserAvatar;


/***/ }),

/***/ "./src/main/frontend/page-status/dialog/components/history/item/user/ConfluenceUserLink.tsx":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var react_1 = __importDefault(__webpack_require__("./node_modules/react/index.js"));
var wrm_react_i18n_1 = __webpack_require__("./node_modules/@atlassian/wrm-react-i18n/wrm-react-i18n.js");
var page_status_edit_service_1 = __webpack_require__("./src/main/frontend/page-status/services/page-status-edit-service.ts");
var ConfluenceUserLink = function (_a) {
    var user = _a.user;
    if (!(user === null || user === void 0 ? void 0 : user.name)) {
        return react_1.default.createElement("span", null, wrm_react_i18n_1.I18n.getText('handy.macros.anonymous'));
    }
    return (react_1.default.createElement("a", { target: "_top", className: "user-link url fn confluence-userlink", title: user.name, href: (0, page_status_edit_service_1.getConfluenceUserLink)(user.name), "data-username": user.name }, user.fullName));
};
exports["default"] = ConfluenceUserLink;


/***/ }),

/***/ "./src/main/frontend/page-status/dialog/components/hooks/use-async-state.ts":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
var react_1 = __webpack_require__("./node_modules/react/index.js");
var useAsyncState = function (defaultValue, request, dependencies, onError) {
    var _a = (0, react_1.useState)(defaultValue), data = _a[0], setData = _a[1];
    var _b = (0, react_1.useState)(true), isLoading = _b[0], setIsLoading = _b[1];
    var _c = (0, react_1.useState)(''), error = _c[0], setError = _c[1];
    (0, react_1.useEffect)(function () {
        request()
            .then(setData)
            .catch(function (err) {
            setError(err);
            if (onError) {
                onError();
            }
        })
            .finally(function () { return setIsLoading(false); });
    }, dependencies !== null && dependencies !== void 0 ? dependencies : []); // eslint-disable-line react-hooks/exhaustive-deps
    return [data, isLoading, error, setData];
};
exports["default"] = useAsyncState;


/***/ }),

/***/ "./src/main/frontend/page-status/dialog/components/hooks/use-dialog-modal.ts":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
var react_1 = __webpack_require__("./node_modules/react/index.js");
var useDialogModal = function () {
    var _a = (0, react_1.useState)(false), isOpen = _a[0], setIsOpen = _a[1];
    var toggle = function (value) {
        setIsOpen(value);
    };
    return {
        isOpen: isOpen,
        toggle: toggle
    };
};
exports["default"] = useDialogModal;


/***/ }),

/***/ "./src/main/frontend/page-status/dialog/page-status-dialog-context.tsx":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.usePageStatusDialogContext = exports.PageStatusDialogContextProvider = exports.PAGE_STATUS_DIALOG_CONTEXT_DEFAULT_VALUE = void 0;
var react_1 = __importStar(__webpack_require__("./node_modules/react/index.js"));
var PageStatusDialogContext = (0, react_1.createContext)(undefined);
exports.PAGE_STATUS_DIALOG_CONTEXT_DEFAULT_VALUE = {
    contentId: '',
    canUserEditContent: false,
    licensed: false,
    isPageStatusPropertyExists: false,
    closeDialog: function () {
    },
};
var PageStatusDialogContextProvider = function (_a) {
    var contextData = _a.contextData, children = _a.children;
    return (react_1.default.createElement(PageStatusDialogContext.Provider, { value: contextData }, children));
};
exports.PageStatusDialogContextProvider = PageStatusDialogContextProvider;
var usePageStatusDialogContext = function () {
    var context = (0, react_1.useContext)(PageStatusDialogContext);
    if (!context) {
        throw new Error('usePageStatusDialogContext must be used within a PageStatusDialogContextProvider');
    }
    return context;
};
exports.usePageStatusDialogContext = usePageStatusDialogContext;


/***/ }),

/***/ "./src/main/frontend/page-status/dialog/page-status-dialog.style.ts":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __makeTemplateObject = (this && this.__makeTemplateObject) || function (cooked, raw) {
    if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
    return cooked;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PageStatusHistoryEmptyStateStyled = exports.HistoryTableStyled = exports.DialogPanelStyled = exports.DialogFooterActionsStyled = exports.CenteredContainer = void 0;
var styled_1 = __importDefault(__webpack_require__("./node_modules/@emotion/styled/dist/emotion-styled.browser.esm.js"));
var tokens_1 = __webpack_require__("./node_modules/@atlaskit/tokens/dist/esm/index.js");
exports.CenteredContainer = styled_1.default.div(templateObject_1 || (templateObject_1 = __makeTemplateObject(["\n    display: flex;\n    justify-content: center;\n    align-items: center;\n    height: 100%;\n    width: 100%;\n"], ["\n    display: flex;\n    justify-content: center;\n    align-items: center;\n    height: 100%;\n    width: 100%;\n"])));
exports.DialogFooterActionsStyled = styled_1.default.div(templateObject_2 || (templateObject_2 = __makeTemplateObject(["\n    width: 100%;\n    display: flex;\n    position: relative;\n    justify-content: space-between;\n    align-content: center;\n    align-items: center;\n    \n    & .dialog-footer-left-container {\n        display: flex;\n        align-content: center;\n        flex-wrap: wrap;\n        height: 100%;\n    }\n    \n    & #button-help, #button-documentation {\n        cursor: pointer;\n        height: 24px;\n        width: 24px;\n        margin-right: ", ";\n    }\n"], ["\n    width: 100%;\n    display: flex;\n    position: relative;\n    justify-content: space-between;\n    align-content: center;\n    align-items: center;\n    \n    & .dialog-footer-left-container {\n        display: flex;\n        align-content: center;\n        flex-wrap: wrap;\n        height: 100%;\n    }\n    \n    & #button-help, #button-documentation {\n        cursor: pointer;\n        height: 24px;\n        width: 24px;\n        margin-right: ", ";\n    }\n"])), (0, tokens_1.token)('space.150', '12px'));
exports.DialogPanelStyled = styled_1.default.div(templateObject_3 || (templateObject_3 = __makeTemplateObject(["\n    box-sizing: border-box;\n    width: 100%;\n    display: flex;\n    justify-content: space-between;\n    flex-direction: column;\n    position: relative;\n    -webkit-user-select: none; /* Safari */\n    -ms-user-select: none; /* IE 10 and IE 11 */\n    user-select: none; /* Standard syntax */\n    border-radius: 3px;\n\n    & .select-set-status-controls input:focus-visible {\n        box-shadow: none;\n    }\n"], ["\n    box-sizing: border-box;\n    width: 100%;\n    display: flex;\n    justify-content: space-between;\n    flex-direction: column;\n    position: relative;\n    -webkit-user-select: none; /* Safari */\n    -ms-user-select: none; /* IE 10 and IE 11 */\n    user-select: none; /* Standard syntax */\n    border-radius: 3px;\n\n    & .select-set-status-controls input:focus-visible {\n        box-shadow: none;\n    }\n"])));
exports.HistoryTableStyled = styled_1.default.div(templateObject_4 || (templateObject_4 = __makeTemplateObject(["\n    display: flex;\n    flex-direction: column;\n    overflow: auto;\n    padding-bottom: 2px;\n    width: 100%;\n    \n    & table {\n        cursor: default;\n        width: auto;\n        min-width: 464px;\n    }\n\n    & table td:last-child {\n        overflow: visible;\n    }\n    \n    & th {\n        font-size: 12px;\n    }\n\n    & .snapshot-date {\n        width: 130px;\n    }\n\n    & .snapshot-user {\n        display: flex;\n        align-items: center;\n        width: 100px;\n    }\n\n    & .user-link {\n        display: inline-block;\n        overflow: hidden;\n        white-space: nowrap;\n        text-overflow: ellipsis;\n    }\n\n    & .status-update {\n        display: flex;\n        align-items: center;\n        min-width: 200px;\n    }\n\n    & .status-update .handy-status-view:first-child {\n        margin-right: 5px;\n    }\n\n    & .status-update .handy-status-view:last-child{\n        margin-left: 5px;\n    }\n"], ["\n    display: flex;\n    flex-direction: column;\n    overflow: auto;\n    padding-bottom: 2px;\n    width: 100%;\n    \n    & table {\n        cursor: default;\n        width: auto;\n        min-width: 464px;\n    }\n\n    & table td:last-child {\n        overflow: visible;\n    }\n    \n    & th {\n        font-size: 12px;\n    }\n\n    & .snapshot-date {\n        width: 130px;\n    }\n\n    & .snapshot-user {\n        display: flex;\n        align-items: center;\n        width: 100px;\n    }\n\n    & .user-link {\n        display: inline-block;\n        overflow: hidden;\n        white-space: nowrap;\n        text-overflow: ellipsis;\n    }\n\n    & .status-update {\n        display: flex;\n        align-items: center;\n        min-width: 200px;\n    }\n\n    & .status-update .handy-status-view:first-child {\n        margin-right: 5px;\n    }\n\n    & .status-update .handy-status-view:last-child{\n        margin-left: 5px;\n    }\n"])));
exports.PageStatusHistoryEmptyStateStyled = styled_1.default.div(templateObject_5 || (templateObject_5 = __makeTemplateObject(["\n    width: 100%;\n    display: flex;\n    flex-direction: column;\n    align-items: center;\n    justify-content: center;\n"], ["\n    width: 100%;\n    display: flex;\n    flex-direction: column;\n    align-items: center;\n    justify-content: center;\n"])));
var templateObject_1, templateObject_2, templateObject_3, templateObject_4, templateObject_5;


/***/ }),

/***/ "./src/main/frontend/page-status/dialog/page-status-dialog.tsx":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var react_1 = __importDefault(__webpack_require__("./node_modules/react/index.js"));
var react_dom_1 = __importDefault(__webpack_require__("./node_modules/react-dom/index.js"));
var page_status_service_1 = __webpack_require__("./src/main/frontend/page-status/services/page-status-service.ts");
var PageStatusDialog_1 = __importDefault(__webpack_require__("./src/main/frontend/page-status/dialog/components/PageStatusDialog.tsx"));
var page_status_edit_service_1 = __webpack_require__("./src/main/frontend/page-status/services/page-status-edit-service.ts");
var render = function () {
    var root = document.getElementById(page_status_service_1.PAGE_STATUS_DIALOG_ROOT_ELEMENT_ID);
    if (!root)
        return;
    (0, page_status_service_1.loadGA4Resource)();
    var statusIdString = root.dataset.statusId;
    react_dom_1.default.render(react_1.default.createElement(PageStatusDialog_1.default, { viewStatusId: (0, page_status_edit_service_1.getParsedIntOrUndefined)(statusIdString) }), root);
};
render();
window.document.addEventListener(page_status_service_1.PAGE_STATUS_EDITOR_OPENED_EVENT_NAME, render, false);


/***/ }),

/***/ "./src/main/frontend/page-status/dialog/page-status-edit-context.tsx":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.usePageStatusEditContext = exports.PageStatusDialogEditProvider = exports.PAGE_STATUS_EDIT_CONTEXT_DEFAULT_VALUE = void 0;
var react_1 = __importStar(__webpack_require__("./node_modules/react/index.js"));
var PageStatusEditContext = (0, react_1.createContext)(undefined);
exports.PAGE_STATUS_EDIT_CONTEXT_DEFAULT_VALUE = {
    statusesCount: 0,
    changeCurrentStatus: function () {
    },
    changeCurrentStatusSet: function () {
    },
    cancelStatusChange: function () {
    },
    acceptStatusChange: function () {
    },
    toggleDeleteModalContent: function () {
    },
    refreshStatusesCount: function () {
    },
};
var PageStatusDialogEditProvider = function (_a) {
    var contextData = _a.contextData, children = _a.children;
    return (react_1.default.createElement(PageStatusEditContext.Provider, { value: contextData }, children));
};
exports.PageStatusDialogEditProvider = PageStatusDialogEditProvider;
var usePageStatusEditContext = function () {
    var context = (0, react_1.useContext)(PageStatusEditContext);
    if (!context) {
        throw new Error('usePageStatusDialogContext must be used within a PageStatusDialogContextProvider');
    }
    return context;
};
exports.usePageStatusEditContext = usePageStatusEditContext;


/***/ }),

/***/ "./src/main/frontend/page-status/services/page-status-context-service.ts":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getPageStatusDialogContextData = void 0;
var context_1 = __webpack_require__("./src/main/frontend/shared/context.ts");
var status_page_1 = __webpack_require__("./src/main/frontend/api/backend/status-page.ts");
var getPageStatusDialogContextData = function () { return __awaiter(void 0, void 0, void 0, function () {
    var contentId, spaceKey, pageStatusForEditor, status_1, statusSet, canUserEditContent, licensed, isContentPropertyStatus, error_1, message;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                contentId = Confluence.getContentId();
                spaceKey = (0, context_1.getContextSpaceKey)();
                _a.label = 1;
            case 1:
                _a.trys.push([1, 3, , 4]);
                return [4 /*yield*/, (0, status_page_1.fetchPageStatusForEditor)(contentId, spaceKey)];
            case 2:
                pageStatusForEditor = _a.sent();
                status_1 = pageStatusForEditor.status, statusSet = pageStatusForEditor.statusSet, canUserEditContent = pageStatusForEditor.canUserEditContent, licensed = pageStatusForEditor.licensed, isContentPropertyStatus = pageStatusForEditor.isContentPropertyStatus;
                return [2 /*return*/, {
                        contentId: contentId,
                        canUserEditContent: canUserEditContent,
                        licensed: licensed,
                        isPageStatusPropertyExists: isContentPropertyStatus,
                        statusForEditor: status_1,
                        statusSetForEditor: statusSet,
                        closeDialog: function () { },
                    }];
            case 3:
                error_1 = _a.sent();
                message = 'Cannot get Page Status context data!';
                console.log(message, error_1);
                throw Error(message);
            case 4: return [2 /*return*/];
        }
    });
}); };
exports.getPageStatusDialogContextData = getPageStatusDialogContextData;


/***/ }),

/***/ "./src/main/frontend/page-status/services/page-status-edit-service.ts":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.trackGA4PageStatusHistorySeen = exports.trackGA4PageStatusEdited = exports.trackGA4PageStatusAdded = exports.trackGA4PageStatusDeleted = exports.trackGA4PageStatusDeleteClicked = exports.isUserOwner = exports.isSpaceOwner = exports.isGlobalOwner = exports.getHandySettingsLink = exports.openReportIssuePage = exports.openPageStatusDocsPage = exports.showAddStatusErrorFlagMessage = exports.showDeleteStatusErrorFlagMessage = exports.showChangeStatusErrorFlagMessage = exports.showGetStatusContextErrorFlagMessage = exports.getParsedIntOrUndefined = exports.isStatusSetUnknown = exports.getConfluenceAvatarUrl = exports.getConfluenceUserLink = exports.PAGE_STATUS_DIALOG_HEIGHT = exports.PAGE_STATUS_DIALOG_WIDTH = void 0;
var wrm_react_i18n_1 = __webpack_require__("./node_modules/@atlassian/wrm-react-i18n/wrm-react-i18n.js");
var context_1 = __webpack_require__("./src/main/frontend/shared/context.ts");
var page_status_service_1 = __webpack_require__("./src/main/frontend/page-status/services/page-status-service.ts");
var ga4_events_1 = __webpack_require__("./src/main/frontend/shared/ga4/ga4-events.ts");
var PAGE_STATUS_DOCS_URL = 'https://docs.stiltsoft.com/hmfc/server-dc/handy-page-status/how-to-use-handy-page-status';
var REPORT_ISSUE_URL = 'https://stiltsoft.customercase.com/forums/support-requests/ideas/create?category=Handy%20Macros%20for%20Confluence';
var USER_SETTINGS_LINK = "".concat((0, context_1.getContextPath)(), "/users/handy-macros.action");
var SPACE_SETTINGS_LINK = function (spaceKey) { return "".concat((0, context_1.getContextPath)(), "/plugins/handy-macros/space-settings.action?key=").concat(spaceKey); };
var GLOBAL_SETTINGS_LINK = "".concat((0, context_1.getContextPath)(), "/admin/plugins/handy-macros/config.action");
exports.PAGE_STATUS_DIALOG_WIDTH = 515;
exports.PAGE_STATUS_DIALOG_HEIGHT = 380;
var getConfluenceUserLink = function (userName) { return "".concat((0, context_1.getContextPath)(), "/display/~").concat(userName); };
exports.getConfluenceUserLink = getConfluenceUserLink;
var getConfluenceAvatarUrl = function (avatarUrl) { return "".concat((0, context_1.getContextPath)()).concat(avatarUrl); };
exports.getConfluenceAvatarUrl = getConfluenceAvatarUrl;
var isStatusSetUnknown = function (statusSet) { return (statusSet === null || statusSet === void 0 ? void 0 : statusSet.name) === 'unknown'; };
exports.isStatusSetUnknown = isStatusSetUnknown;
var getParsedIntOrUndefined = function (value) {
    return (value === null || value === void 0 ? void 0 : value.trim()) ? parseInt(value, 10) : undefined;
};
exports.getParsedIntOrUndefined = getParsedIntOrUndefined;
var showGetStatusContextErrorFlagMessage = function () {
    (0, page_status_service_1.showFlag)({
        type: 'error',
        title: 'Oops! Something went wrong...',
        body: wrm_react_i18n_1.I18n.getText('handy.page-status.dialog.get.context.error'),
    });
};
exports.showGetStatusContextErrorFlagMessage = showGetStatusContextErrorFlagMessage;
var showChangeStatusErrorFlagMessage = function () {
    (0, page_status_service_1.showFlag)({
        type: 'error',
        body: "".concat(wrm_react_i18n_1.I18n.getText('handy.page-status.dialog.change.error', '<b>', '</b>')),
    });
};
exports.showChangeStatusErrorFlagMessage = showChangeStatusErrorFlagMessage;
var showDeleteStatusErrorFlagMessage = function () {
    (0, page_status_service_1.showFlag)({
        type: 'error',
        body: "".concat(wrm_react_i18n_1.I18n.getText('handy.page-status.dialog.delete.error', '<b>', '</b>')),
    });
};
exports.showDeleteStatusErrorFlagMessage = showDeleteStatusErrorFlagMessage;
var showAddStatusErrorFlagMessage = function () {
    (0, page_status_service_1.showFlag)({
        type: 'error',
        body: "".concat(wrm_react_i18n_1.I18n.getText('handy.page-status.dialog.add.error', '<b>', '</b>')),
    });
};
exports.showAddStatusErrorFlagMessage = showAddStatusErrorFlagMessage;
var openPageStatusDocsPage = function () { var _a; return (_a = window.open(PAGE_STATUS_DOCS_URL, '_blank')) === null || _a === void 0 ? void 0 : _a.focus(); };
exports.openPageStatusDocsPage = openPageStatusDocsPage;
var openReportIssuePage = function () { var _a; return (_a = window.open(REPORT_ISSUE_URL, '_blank')) === null || _a === void 0 ? void 0 : _a.focus(); };
exports.openReportIssuePage = openReportIssuePage;
var getHandySettingsLink = function (owner) {
    if ((0, exports.isGlobalOwner)(owner)) {
        return GLOBAL_SETTINGS_LINK;
    }
    if ((0, exports.isSpaceOwner)(owner)) {
        var spaceKey = (0, context_1.getContextSpaceKey)();
        return SPACE_SETTINGS_LINK(spaceKey);
    }
    return USER_SETTINGS_LINK;
};
exports.getHandySettingsLink = getHandySettingsLink;
var isGlobalOwner = function (owner) { return owner === 'global'; };
exports.isGlobalOwner = isGlobalOwner;
var isSpaceOwner = function (owner) { return owner === null || owner === void 0 ? void 0 : owner.startsWith('space'); };
exports.isSpaceOwner = isSpaceOwner;
var isUserOwner = function (owner) { return owner === null || owner === void 0 ? void 0 : owner.startsWith('user'); };
exports.isUserOwner = isUserOwner;
var trackGA4PageStatusDeleteClicked = function (statusesCount) {
    return trackGA4PageStatusEvent(ga4_events_1.ga4pageStatusDeleteClicked, statusesCount);
};
exports.trackGA4PageStatusDeleteClicked = trackGA4PageStatusDeleteClicked;
var trackGA4PageStatusDeleted = function (statusesCount) {
    return trackGA4PageStatusEvent(ga4_events_1.ga4pageStatusDeleted, statusesCount);
};
exports.trackGA4PageStatusDeleted = trackGA4PageStatusDeleted;
var trackGA4PageStatusAdded = function (statusesCount) {
    return trackGA4PageStatusEvent(ga4_events_1.ga4pageStatusAdded, statusesCount);
};
exports.trackGA4PageStatusAdded = trackGA4PageStatusAdded;
var trackGA4PageStatusEdited = function (statusesCount) {
    return trackGA4PageStatusEvent(ga4_events_1.ga4pageStatusEdited, statusesCount);
};
exports.trackGA4PageStatusEdited = trackGA4PageStatusEdited;
var trackGA4PageStatusHistorySeen = function (statusesCount) {
    return trackGA4PageStatusEvent(ga4_events_1.ga4pageStatusHistorySeen, statusesCount);
};
exports.trackGA4PageStatusHistorySeen = trackGA4PageStatusHistorySeen;
var trackGA4PageStatusEvent = function (ga4pageStatusAccessor, statusesCount) {
    ga4pageStatusAccessor({ statuses_count: statusesCount });
};


/***/ }),

/***/ "./src/main/frontend/page-status/services/page-status-options-service.ts":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.toSelectStatusSetGroupOptionType = exports.toSelectStatusOptionTypes = exports.toSelectStatusOptionType = exports.makeSelectStatusSetOptionType = exports.makeSelectStatusOptionType = void 0;
var wrm_react_i18n_1 = __webpack_require__("./node_modules/@atlassian/wrm-react-i18n/wrm-react-i18n.js");
var page_status_edit_service_1 = __webpack_require__("./src/main/frontend/page-status/services/page-status-edit-service.ts");
var makeSelectStatusOptionType = function (status) {
    return status ? (0, exports.toSelectStatusOptionType)(status) : undefined;
};
exports.makeSelectStatusOptionType = makeSelectStatusOptionType;
var makeSelectStatusSetOptionType = function (set) {
    return set ? toSelectStatusSetOptionType(set) : undefined;
};
exports.makeSelectStatusSetOptionType = makeSelectStatusSetOptionType;
var toSelectStatusOptionType = function (status) { return (__assign({ status: status }, toSelectOptionType(status.name, status.id))); };
exports.toSelectStatusOptionType = toSelectStatusOptionType;
var toSelectStatusOptionTypes = function (statuses) {
    return statuses.map(exports.toSelectStatusOptionType);
};
exports.toSelectStatusOptionTypes = toSelectStatusOptionTypes;
var toSelectStatusSetOptionType = function (set) { return (__assign({ statusSet: set }, toSelectOptionType(set.name, set.id))); };
var toSelectStatusSetGroupOptionType = function (sets) {
    var groupedOptions = [
        { label: wrm_react_i18n_1.I18n.getText('handy.macros.set.global'), options: [] },
        { label: wrm_react_i18n_1.I18n.getText('handy.macros.set.space'), options: [] },
        { label: wrm_react_i18n_1.I18n.getText('handy.macros.set.personal'), options: [] },
    ];
    sets.forEach(function (set) {
        var owner = set.owner;
        var groupIndex = 0;
        if ((0, page_status_edit_service_1.isSpaceOwner)(owner)) {
            groupIndex = 1;
        }
        else if ((0, page_status_edit_service_1.isUserOwner)(owner)) {
            groupIndex = 2;
        }
        else if (!(0, page_status_edit_service_1.isGlobalOwner)(owner)) {
            console.error('Unknown owner type', JSON.stringify(set));
            return;
        }
        groupedOptions[groupIndex] = __assign(__assign({}, groupedOptions[groupIndex]), { options: __spreadArray(__spreadArray([], groupedOptions[groupIndex].options, true), [
                toSelectStatusSetOptionType(set)
            ], false) });
    });
    return groupedOptions;
};
exports.toSelectStatusSetGroupOptionType = toSelectStatusSetGroupOptionType;
var toSelectOptionType = function (label, value) { return ({
    label: label,
    value: value,
}); };


/***/ }),

/***/ "./src/main/frontend/page-status/services/page-status-service.ts":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.loadGA4Resource = exports.showFlag = exports.triggerPageStatusUpdate = exports.removePageStatusAjsDialog = exports.handlePageStatusClick = exports.PAGE_STATUS_VIEW_ELEMENT_ID = exports.PAGE_STATUS_DIALOG_ROOT_ELEMENT_ID = exports.PAGE_STATUS_CHANGED_EVENT_NAME = exports.PAGE_STATUS_EDITOR_OPENED_EVENT_NAME = void 0;
var wrm_react_i18n_1 = __webpack_require__("./node_modules/@atlassian/wrm-react-i18n/wrm-react-i18n.js");
exports.PAGE_STATUS_EDITOR_OPENED_EVENT_NAME = 'HandyPageStatusEditorOpened';
exports.PAGE_STATUS_CHANGED_EVENT_NAME = 'HandyPageStatusChanged';
exports.PAGE_STATUS_DIALOG_ROOT_ELEMENT_ID = 'hm-page-status-dialog-root';
exports.PAGE_STATUS_VIEW_ELEMENT_ID = 'hm-page-status-view';
var DIALOG_RESOURCE_KEY = 'com.stiltsoft.confluence.handy.macros:page-status-dialog';
var GA4_RESOURCE_KEY = 'com.stiltsoft.confluence.handy.macros:google-analytics4';
var handlePageStatusClick = function (statusId) {
    var loadingIndicator = Confluence.PageLoadingIndicator($('body'));
    var dialogResourcePromise = WRM.require("wr!".concat(DIALOG_RESOURCE_KEY));
    dialogResourcePromise.then(function () {
        var dialogRootElement = document.getElementById(exports.PAGE_STATUS_DIALOG_ROOT_ELEMENT_ID);
        if (!dialogRootElement) {
            var ajsDialog = createPageStatusAjsDialog(statusId);
            renderAjsDialog(ajsDialog);
        }
        dispatchEventForPageStatusEditorReRender();
    });
    loadingIndicator.showUntilDialogVisible(dialogResourcePromise, wrm_react_i18n_1.I18n.getText('handy.page-status.dialog.loading.error'));
};
exports.handlePageStatusClick = handlePageStatusClick;
var renderAjsDialog = function (dialog) {
    dialog.show();
    dialog.hide();
};
var dispatchEventForPageStatusEditorReRender = function () { return document.dispatchEvent(new CustomEvent(exports.PAGE_STATUS_EDITOR_OPENED_EVENT_NAME)); };
var createPageStatusAjsDialog = function (statusId) {
    return AJS.dialog2("<div id=\"".concat(exports.PAGE_STATUS_DIALOG_ROOT_ELEMENT_ID, "\" data-status-id=").concat(statusId ? statusId : '', "></div>"));
};
var removePageStatusAjsDialog = function () { return AJS.dialog2("#".concat(exports.PAGE_STATUS_DIALOG_ROOT_ELEMENT_ID)).remove(); };
exports.removePageStatusAjsDialog = removePageStatusAjsDialog;
var triggerPageStatusUpdate = function (params) {
    return document.dispatchEvent(new CustomEvent(exports.PAGE_STATUS_CHANGED_EVENT_NAME, { detail: params }));
};
exports.triggerPageStatusUpdate = triggerPageStatusUpdate;
var showFlag = function (options) { return AJS.flag(options); };
exports.showFlag = showFlag;
var loadGA4Resource = function () {
    if (!window.handyGtag) {
        void WRM.require("wr!".concat(GA4_RESOURCE_KEY));
    }
};
exports.loadGA4Resource = loadGA4Resource;


/***/ }),

/***/ "./src/main/frontend/shared/atlaskit-colors.ts":
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
var colors = {
    R50: '#FFEBE6',
    R75: '#FFBDAD',
    R100: '#FF8F73',
    R200: '#FF7452',
    R300: '#FF5630',
    R400: '#DE350B',
    R500: '#BF2600',
    Y50: '#FFFAE6',
    Y100: '#FFE380',
    Y200: '#FFC400',
    Y300: '#FFAB00',
    Y400: '#FF991F',
    Y500: '#FF8B00',
    G50: '#E3FCEF',
    G100: '#79F2C0',
    G200: '#57D9A3',
    G300: '#36B37E',
    G400: '#00875A',
    G500: '#006644',
    B50: '#DEEBFF',
    B75: '#B3D4FF',
    B100: '#4C9AFF',
    B200: '#2684FF',
    B300: '#0065FF',
    B400: '#0052CC',
    B500: '#0747A6',
    N0: '#FFFFFF',
    N10: '#FAFBFC',
    N20: '#F4F5F7',
    N30: '#EBECF0',
    N40: '#DFE1E6',
    N50: '#C1C7D0',
    N60: '#B3BAC5',
    N70: '#A5ADBA',
    N80: '#97A0AF',
    N90: '#8993A4',
    N100: '#7A869A',
    N200: '#6B778C',
    N300: '#5E6C84',
    N500: '#42526E',
    N400: '#505F79',
    N600: '#344563',
    N700: '#253858',
    N800: '#172B4D',
    N900: '#091E42',
    P50: '#EAE6FF',
    P100: '#998DD9',
    P200: '#8777D9',
    P300: '#6554C0',
    P400: '#5243AA',
    P500: '#403294',
    T50: '#E6FCFF',
    T100: '#79E2F2',
    T200: '#00C7E6',
    T300: '#00B8D9',
    T400: '#00A3BF',
    T500: '#008DA6',
};
exports["default"] = colors;


/***/ }),

/***/ "./src/main/frontend/shared/components/StatusPreview.tsx":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var react_1 = __importDefault(__webpack_require__("./node_modules/react/index.js"));
var StatusPreview = function (_a) {
    var textColor = _a.textColor, backgroundColor = _a.backgroundColor, name = _a.name, _b = _a.minWidth, minWidth = _b === void 0 ? 76 : _b;
    var style = {
        color: textColor,
        backgroundColor: backgroundColor,
        borderColor: backgroundColor,
        minWidth: minWidth,
    };
    return react_1.default.createElement("span", { className: "aui-lozenge handy-status-view", style: style }, name);
};
exports["default"] = StatusPreview;


/***/ }),

/***/ "./src/main/frontend/shared/context.ts":
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.APP_REST_API_BASE_URL = exports.getContextSpaceKey = exports.getContextPath = void 0;
var getContextPath = function () { return Confluence.getContextPath(); };
exports.getContextPath = getContextPath;
var getContextSpaceKey = function () { return AJS.Meta.get('space-key'); };
exports.getContextSpaceKey = getContextSpaceKey;
exports.APP_REST_API_BASE_URL = "".concat((0, exports.getContextPath)(), "/rest/handy-macros/2.0");


/***/ }),

/***/ "./src/main/frontend/shared/ga4/ga4-events.ts":
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ga4pageStatusDisableGlobal = exports.ga4pageStatusEnableGlobal = exports.ga4macroInserted = exports.ga4pageStatusHistorySeen = exports.ga4pageStatusEdited = exports.ga4pageStatusAdded = exports.ga4pageStatusDeleted = exports.ga4pageStatusDeleteClicked = exports.ga4reminderUsage = exports.ga4statusSelected = exports.ga4featureUsed = void 0;
// https://confluence.stiltsoft.com/pages/viewpage.action?pageId=241141953#HandyMacrosDataCenterGoogleAnalyticsEvents(GA4)-ga4customevents
var events = {
    // confluencePageView
    FEATURE_USED: 'confPageView_feature_used',
    STATUS_SELECTED: 'confPageView_status_selected',
    REMINDER_USAGE: 'confPageView_reminderMacro_usage',
    PAGE_STATUS_DELETE_CLICKED: 'confPageView_pageStatus_deleteClicked',
    PAGE_STATUS_DELETED: 'confPageView_pageStatus_deleted',
    PAGE_STATUS_ADDED: 'confPageView_pageStatus_added',
    PAGE_STATUS_EDITED: 'confPageView_pageStatus_edited',
    PAGE_STATUS_HISTORY_SEEN: 'confPageView_pageStatus_historySeen',
    // confluencePageEdit
    MACRO_INSERTED: 'confPageEdit_macro_inserted',
    // appConfiguration
    PAGE_STATUS_ENABLE_GLOBAL: 'appConfig_pageStatus_enableGlobal',
    PAGE_STATUS_DISABLE_GLOBAL: 'appConfig_pageStatus_disableGlobal',
};
var ga4SendEvent = function (eventName, eventParams) {
    if (eventParams === void 0) { eventParams = {}; }
    if (eventName.length > 40) {
        console.error('Event name length should be <= 40:', eventName, eventName.length);
    }
    if (window.handyGtag) {
        window.handyGtag('event', eventName, eventParams);
        console.log('Custom event sent to ga4: ', eventName, 'event parameters: ', eventParams);
    }
    else {
        console.log('Trying to send custom event while gtag is not initialized');
    }
};
var ga4featureUsed = function (params) { return ga4SendEvent(events.FEATURE_USED, params); };
exports.ga4featureUsed = ga4featureUsed;
var ga4statusSelected = function (params) { return ga4SendEvent(events.STATUS_SELECTED, params); };
exports.ga4statusSelected = ga4statusSelected;
var ga4reminderUsage = function (params) { return ga4SendEvent(events.REMINDER_USAGE, params); };
exports.ga4reminderUsage = ga4reminderUsage;
var ga4pageStatusDeleteClicked = function (params) { return ga4SendEvent(events.PAGE_STATUS_DELETE_CLICKED, params); };
exports.ga4pageStatusDeleteClicked = ga4pageStatusDeleteClicked;
var ga4pageStatusDeleted = function (params) { return ga4SendEvent(events.PAGE_STATUS_DELETED, params); };
exports.ga4pageStatusDeleted = ga4pageStatusDeleted;
var ga4pageStatusAdded = function (params) { return ga4SendEvent(events.PAGE_STATUS_ADDED, params); };
exports.ga4pageStatusAdded = ga4pageStatusAdded;
var ga4pageStatusEdited = function (params) { return ga4SendEvent(events.PAGE_STATUS_EDITED, params); };
exports.ga4pageStatusEdited = ga4pageStatusEdited;
var ga4pageStatusHistorySeen = function (params) { return ga4SendEvent(events.PAGE_STATUS_HISTORY_SEEN, params); };
exports.ga4pageStatusHistorySeen = ga4pageStatusHistorySeen;
var ga4macroInserted = function (params) { return ga4SendEvent(events.MACRO_INSERTED, params); };
exports.ga4macroInserted = ga4macroInserted;
var ga4pageStatusEnableGlobal = function () { return ga4SendEvent(events.PAGE_STATUS_ENABLE_GLOBAL); };
exports.ga4pageStatusEnableGlobal = ga4pageStatusEnableGlobal;
var ga4pageStatusDisableGlobal = function () { return ga4SendEvent(events.PAGE_STATUS_DISABLE_GLOBAL); };
exports.ga4pageStatusDisableGlobal = ga4pageStatusDisableGlobal;
window.HandyGA4Events = {
    ga4featureUsed: exports.ga4featureUsed,
    ga4statusSelected: exports.ga4statusSelected,
    ga4macroInserted: exports.ga4macroInserted,
    ga4pageStatusEnableGlobal: exports.ga4pageStatusEnableGlobal,
    ga4pageStatusDisableGlobal: exports.ga4pageStatusDisableGlobal,
};


/***/ }),

/***/ "com.atlassian.plugins.atlassian-plugins-webresource-plugin:i18n/WRM.I18n":
/***/ ((module) => {

if(typeof WRM.I18n === 'undefined') { var e = new Error("Cannot find module 'WRM.I18n'"); e.code = 'MODULE_NOT_FOUND'; throw e; }

module.exports = WRM.I18n;

/***/ }),

/***/ "com.atlassian.plugins.atlassian-plugins-webresource-plugin:format/WRM.format":
/***/ ((module) => {

module.exports = WRM.format;

/***/ })

},
/******/ __webpack_require__ => { // webpackRuntimeModules
/******/ var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
/******/ __webpack_require__.O(0, ["vendors-node_modules_atlaskit_analytics-next-stable-react-context_dist_esm_index_js-node_modu-3ab870","vendors-node_modules_atlaskit_button_dist_esm_index_js-node_modules_atlaskit_icon_dist_esm_en-f99b7d","vendors-node_modules_bind-event-listener_dist_index_js-node_modules_prop-types_index_js-node_-a57af8","vendors-node_modules_atlaskit_avatar_dist_esm_index_js-node_modules_atlaskit_dynamic-table_di-6fc01c"], () => (__webpack_exec__("./src/main/frontend/page-status/dialog/page-status-dialog.tsx")));
/******/ var __webpack_exports__ = __webpack_require__.O();
/******/ }
]);