window.define(
    'stiltsoft/HandyStatusRestAPI',
    ['jquery', 'ajs', 'confluence/root'],
    ($, ajs, confluence) => {

        const cloneStatusSet = (statusSetId, async) =>
            new Promise((resolve, reject) => {
                $.ajax({
                    type: 'POST',
                    url: `${confluence.getContextPath()}/rest/handy-macros/2.0/status-macro/settings/sets/${statusSetId}/clone`,
                    contentType: 'application/x-www-form-urlencoded; charset=utf-8',
                    cache: false,
                    async: async,
                    dataType: 'json',
                    success: resolve,
                    error: reject,
                });
            });

        const updateStatusMacro = (statusMacroId, data, async) =>
            new Promise((resolve, reject) => {
                $.ajax({
                    type: 'PUT',
                    url: `${confluence.getContextPath()}/rest/handy-macros/2.0/status-macro/${statusMacroId}`,
                    contentType: 'application/x-www-form-urlencoded; charset=utf-8',
                    cache: false,
                    async: async,
                    dataType: 'json',
                    data: data,
                    success: resolve,
                    error: reject,
                });
            });

        const draftStatusMacro = (statusMacroId, data, async) =>
            new Promise((resolve, reject) => {
                $.ajax({
                    type: 'POST',
                    url: `${confluence.getContextPath()}/rest/handy-macros/2.0/status-macro/${statusMacroId}/draft`,
                    contentType: 'application/x-www-form-urlencoded; charset=utf-8',
                    cache: false,
                    async: async,
                    dataType: 'json',
                    data: data,
                    success: resolve,
                    error: reject,
                });
            });

        const fetchStatusMacro = (statusMacroId, contentId, async) =>
            new Promise((resolve, reject) => {
                $.ajax({
                    type: 'GET',
                    url: `${confluence.getContextPath()}/rest/handy-macros/2.0/status-macro/${statusMacroId}`,
                    contentType: 'application/x-www-form-urlencoded; charset=utf-8',
                    cache: false,
                    async: async,
                    dataType: 'json',
                    data: {contentId: contentId},
                    success: resolve,
                    error: reject,
                });
            });

        const fetchStatusSets = (statusSetId, spaceKey) =>
            new Promise((resolve, reject) => {
                $.ajax({
                    type: 'GET',
                    url: `${confluence.getContextPath()}/rest/handy-macros/2.0/status-macro/settings/sets`,
                    contentType: 'application/x-www-form-urlencoded; charset=utf-8',
                    dataType: 'json',
                    data: {
                        statusSetId: statusSetId,
                        spaceKey: spaceKey,
                    },
                    success: resolve,
                    error: reject,
                });
            });

        const fetchSetStatuses = (statusSetId) =>
            new Promise((resolve, reject) => {
                $.ajax({
                    type: 'GET',
                    url: `${confluence.getContextPath()}/rest/handy-macros/2.0/status-macro/settings/sets/${statusSetId}/statuses`,
                    contentType: 'application/x-www-form-urlencoded; charset=utf-8',
                    dataType: 'json',
                    success: resolve,
                    error: reject,
                });
            });

        return {
            cloneStatusSet: cloneStatusSet,
            updateStatusMacro: updateStatusMacro, //TODO unused?
            draftStatusMacro: draftStatusMacro,
            fetchStatusMacro: fetchStatusMacro,
            fetchStatusSets: fetchStatusSets,
            fetchSetStatuses: fetchSetStatuses,
        };
    });