window.require(
    ['ajs', 'confluence/root', 'jquery', 'stiltsoft/HandyMacrosPageEditorPasteProcessor'],
    (ajs, confluence, $, pasteProcessor) => {

        const cloneStatusMacro = (macroId) => {
            let newMacroId;
            $.ajax({
                type: 'POST',
                url: `${confluence.getContextPath()}/rest/handy-macros/2.0/status-macro/${macroId}/clone`,
                contentType: 'application/x-www-form-urlencoded; charset=utf-8',
                cache: false,
                async: false,
                dataType: 'json',
                data: {contentId: ajs.params.contentId ? ajs.params.contentId : undefined},
                success: (id) => {
                    newMacroId = '' + id;
                },
            });
            return newMacroId;
        };

        const onPasteHandyStatus = ($macro, sourceMacroParams) => {
            const updatedMacroParams = Object.assign({}, sourceMacroParams);
            updatedMacroParams.id = cloneStatusMacro(sourceMacroParams.id);
            return updatedMacroParams;
        };

        const initPasteProcessor = () => pasteProcessor.init('status-handy', onPasteHandyStatus)

        ajs.bind('init.rte', initPasteProcessor);
    });