(function ($) {
    window.HandyStatusMacro = function () {
        var self = this;

        self.macro = null;
        self.macroParams = null;
        self.set = null;
        self.status = null;
        self.outline = null;
        self.setSelect = null;
        self.statusSelect = null;
        self.outlineInput = null;
        self.cloneBtn = null;
    };

    HandyStatusMacro.prototype.init = function (onChange, onUnlicensed, onSetInit, onInitSetError, onStatusInit, saveAsync, onSave) {
        var self = this;

        self.onChange = onChange;
        self.onUnlicensed = onUnlicensed;
        self.onSetInit = onSetInit;
        self.onInitSetError = onInitSetError;
        self.onStatusInit = onStatusInit;
        self.saveAsync = saveAsync;
        self.onSave = onSave;
    };

    HandyStatusMacro.prototype.bindInputEvents = function () {
        var self = this;

        self.setSelect.bind('change', function () {
            if (self.set !== self.setSelect.val()) {
                self.status = undefined;
            }
            self.set = self.setSelect.val();
            self.width = self.setSelect.find('option:selected').data('width');
            self.initStatusSelect();
        });

        self.statusSelect.bind('change', function () {
            self.status = self.statusSelect.val();
            self.macroParams["Status"] = self.statusSelect.find('option:selected').text();
            self.onChange();
        });

        self.outlineInput.bind('change', function () {
            self.outline = self.outlineInput.is(':checked');
            self.onChange();
        });
    };

    HandyStatusMacro.prototype.initInputs = function () {
        var self = this;

        const url = Confluence.getContextPath() + '/rest/handy-macros/2.0/status-macro/' + self.macroParams['id'];

        $.ajax({
            contentType: "application/x-www-form-urlencoded; charset=utf-8",
            type: 'GET',
            url: url,
            async: false,
            cache: false,
            dataType: 'json',
            data: {
                contentId: AJS.params.contentId ? AJS.params.contentId : undefined,
            },
            success: function (data) {
                self.macroParams['id'] = data.id + '';
                self.set = data.set;
                self.status = data.status;
                self.outline = data.outline;
                self.labelled = data.labelled;
                self.prefix = data.prefix;
                self.width = data.width;
                self.initOutlineInput();
                self.initSetSelect();
                if (!data.licensed) {
                    self.setSelect.add(self.statusSelect).add(self.outlineInput).add($('.status-handy-outline')).hide();
                    self.onUnlicensed();
                }
            },
            error: function (errorResponse) {
                console.error('Cannot get macro. ' + errorResponse.status);
                self.setSelect.hide();
                self.statusSelect.hide();
                if (self.cloneBtn) self.cloneBtn.hide();
            }
        });
    };

    HandyStatusMacro.prototype.initOutlineInput = function () {
        var self = this;
        self.outlineInput.prop('checked', self.outline);
    };

    HandyStatusMacro.prototype.initSetSelect = function () {
        var self = this;

        $.ajax({
            contentType: "application/x-www-form-urlencoded; charset=utf-8",
            type: 'GET',
            url: Confluence.getContextPath() + '/rest/handy-macros/2.0/status-macro/settings/sets',
            dataType: 'json',
            data: {
                statusSetId: self.set,
                spaceKey: AJS.params.spaceKey
            },
            success: function (data) {
                self.setSelect.empty();
                AJS.params.currentUserFullname
                var globalOptions = $();
                var spaceOptions = $();
                var personalOptions = $();
                $.each(data, function (i, statusesSet) {
                    var selected = "";
                    if (self.set === statusesSet.id) {
                        selected = ' selected';
                    }
                    var disabled = statusesSet.isEmpty ? ' disabled title="' + AJS.I18n.getText("handy.status.set.empty") + '"' : '';
                    var width = statusesSet.viewType === 0 ? 88 : (statusesSet.width + 12);
                    var option = $("<option value='" + statusesSet.id + "'" + selected + disabled +
                        " data-parent='" + statusesSet.parent + "' data-width='" + width + "'></option>")
                        .text(statusesSet.name);

                    if (statusesSet.owner.startsWith("global")) {
                        globalOptions = globalOptions.add(option);
                    } else if (statusesSet.owner.startsWith("space")) {
                        spaceOptions = spaceOptions.add(option);
                    } else if (statusesSet.owner.startsWith("user")) {
                        personalOptions = personalOptions.add(option);
                    } else {
                        console.error('Unknown owner type', JSON.stringify(statusesSet));
                    }
                });

                addGroup(globalOptions, AJS.I18n.getText("handy.macros.set.global"));
                addGroup(spaceOptions, AJS.I18n.getText("handy.macros.set.space"));
                addGroup(personalOptions, AJS.I18n.getText("handy.macros.set.personal"));

                self.setSelect.trigger('change');
                self.onSetInit(data);
                self.initStatusSelect();
            },
            error: self.onInitSetError
        });

        function addGroup(options, label) {
            if (options.length) {
                var group = $('<optgroup label="' + label + '"></optgroup>');
                group.append(options);
                self.setSelect.append(group);
            }
        }
    };

    HandyStatusMacro.prototype.initStatusSelect = function () {
        var self = this;

        const url = Confluence.getContextPath() +
            '/rest/handy-macros/2.0/status-macro/settings/sets/' + self.set + '/statuses';

        $.ajax({
            contentType: "application/x-www-form-urlencoded; charset=utf-8",
            type: 'GET',
            url: url,
            dataType: 'json',
            success: function (statuses) { //todo check a case when a macro has statusId, but it was deleted from DB
                self.statusSelect.empty();
                if (statuses.length > 0) {
                    $.each(statuses, function (i, statusObject) {
                        var selected = "";
                        if (self.status === statusObject.id) {
                            selected = 'selected';
                        }

                        self.statusSelect.append($("<option value='" + statusObject.id + "'" + selected + "></option>").text(statusObject.name));
                    });

                    self.statusSelect.trigger('change');
                    self.onStatusInit();
                    self.bindInputEvents();
                }
            }
        });
    };

    HandyStatusMacro.prototype.saveMacro = function () {
        var self = this;

        const macroId = self.macroParams['id'];
        const url = Confluence.getContextPath() + '/rest/handy-macros/2.0/status-macro/' + macroId;

        $.ajax({
            contentType: "application/x-www-form-urlencoded; charset=utf-8",
            type: 'PUT',
            cache: false,
            async: self.saveAsync,
            url: url,
            dataType: 'json',
            data: {
                contentId: AJS.params.contentId ? AJS.params.contentId : undefined,
                statusId: self.status,
                outline: self.outline,
                statusSetId: self.set,
                labelled: self.labelled,
                prefix: self.prefix
            },
            success: self.onSave
        });
    };

})(jQuery);
