(function ($, AnalyticsExtender) {

    window.HandyStatusMacroReloader = {};

    var handyStatusMacroJsOverride;

    var HandyStatusMacroJsOverride = function () {
    };

    HandyStatusMacroJsOverride.prototype.beforeParamsRetrieved = function (params) {
        var self = handyStatusMacroJsOverride;

        self.statusMacro.macroParams = params;
        self.statusMacro.labelled = params.labelled;
        self.statusMacro.prefix = params.prefix;
        HandyStatusMacroReloader.params = params;
        self.statusMacro.saveMacro();
        return {"Status": self.statusMacro.statusSelect.find('option:selected').text(), "id": params['id']};
    };

    HandyStatusMacroJsOverride.prototype.postPreview = function (iframe) {
        $(iframe).contents().find('[id="main"]:eq(1)').remove();
    };

    HandyStatusMacroJsOverride.prototype.beforeParamsSet = function (params) {
        $('.hmc-fr').remove();
        $('#macro-browser-dialog .macro-desc .macro-doco-link').before(AJS.I18n.getText("handy.macros.feature-request"));

        var self = handyStatusMacroJsOverride;

        HandyStatusMacroReloader.params = params;
        HandyStatusMacroReloader.beforeParamsSet = self.beforeParamsSet;
        var paramWrappers = $('#macro-param-div-set, #macro-param-div-status, #macro-param-div-outline, #macro-param-div-labelled, #macro-param-div-prefix');
        paramWrappers.show().parent().find('.aui-message').remove();
        $('#macro-param-div-config').remove();

        var globalConfig = AJS.params.isAdmin ? ' ' + AJS.I18n.getText("handy.macros.config.global.link", Confluence.getContextPath()) : '';
        var spaceConfig = AJS.params.isSpaceAdmin ? ' ' + AJS.I18n.getText("handy.macros.config.space.link", Confluence.getContextPath(), AJS.params.spaceKey) : '';
        var config = AJS.I18n.getText("handy.macros.config.link", Confluence.getContextPath()) + spaceConfig + globalConfig;

        var emptyStatuses = function () {
            AJS.messages.warning(paramWrappers.hide().parent(), {
                title: "Warning!",
                body: AJS.I18n.getText("handy.macros.empty") + config.toLowerCase()
            });
        };

        if (!params['id']) {
            $.ajax({
                contentType: "application/x-www-form-urlencoded; charset=utf-8",
                type: 'POST',
                cache: false,
                async: false,
                url: Confluence.getContextPath() + '/rest/handy-macros/2.0/status-macro',
                dataType: 'json',
                data: {
                    contentId: AJS.params.contentId ? AJS.params.contentId : undefined,
                    spaceKey: AJS.params.spaceKey
                },
                success: function (data) {
                    if (!data) {
                        emptyStatuses();
                    } else {
                        params['id'] = data.id;
                    }
                }
            });
        }

        if (!params['id']) {
            return params;
        }

        $('#macro-param-div-id').hide().after('<div id="macro-param-div-config" class="macro-param-div">' + config + '</div>')
            .find('input').val(params['id']);

        self.statusMacro = new HandyStatusMacro();
        self.statusMacro.init(
            function () {
                $('#macro-browser-preview-link').click();
            }, function () {
                var form = paramWrappers.hide().parent();
                AJS.messages.warning(form, {
                    body: AJS.I18n.getText("handy.macros.license.fail", Confluence.getContextPath()),
                    closeable: false
                });
            }, function (data) {
                AJS.MacroBrowser.paramChanged();
                if (data.length === 0) {
                    emptyStatuses();
                }
            }, function () {
                AJS.messages.error($('#macro-param-div-set'), {
                    title: "Error!",
                    body: "Error occurred: unable to retrieve data from server. See logs for details"
                });
            }, AJS.MacroBrowser.paramChanged, false, function (data) {
                params['id'] = data;
            });

        self.statusMacro.macroParams = params;
        self.statusMacro.setSelect = $('#macro-param-set');
        self.statusMacro.statusSelect = $('#macro-param-status');
        self.statusMacro.outlineInput = $('#macro-param-outline');
        self.statusMacro.initInputs();
        params.labelled = self.statusMacro.labelled;
        params.prefix = self.statusMacro.prefix;

        var prefixWrapper = $('#macro-param-div-prefix');
        var labelledCheckBox = $('#macro-param-labelled').change(function () {
            if (labelledCheckBox.is(':checked')) {
                prefixWrapper.show();
            } else {
                prefixWrapper.hide();
            }
        });

        if (!params.labelled) {
            prefixWrapper.hide();
        }

        return params;
    };

    handyStatusMacroJsOverride = new HandyStatusMacroJsOverride();

    var instance = AnalyticsExtender.extend(handyStatusMacroJsOverride);

    AJS.MacroBrowser.setMacroJsOverride("status-handy", instance);

})(AJS.$, require('stiltsoft/handy-macros/analytics/client/extender'));
