(function($) {

    if (!AJS || !AJS.toInit) {
        return;
    }

    function init() {
        if (window.location.hash && window.location.hash.indexOf('handy-reminder-') >= 0) {
            var span = $("span" + window.location.hash);
            span.addClass('active');
            $('html, body').animate({
                scrollTop: span.offset().top - 100
            }, 400).one('click', function() {
                if (window.location.hash && window.location.hash.indexOf('handy-reminder-')) {
                    window.location.hash = '';
                }
            });
        }

        $('.reminder-macro-icon').click(function() {
            var icon = $(this);
            if (icon.data('editable') != true) {
                return false;
            }
            var id = icon.data('id');
            var contentId = icon.data('page-id');
            var description = $('#hr-desc-' + id);
            var dateSpan = $('#hr-date-' + id);

            var init = function(data) {
                if (!$.datepicker) {
                    setTimeout(function() {init(data)}, 100);
                    return;
                }

                if (data.paused) {
                    icon.addClass('inactive');
                } else {
                    icon.removeClass('inactive');
                }

                var date = new Date(data.date + 300000);
                data.date = $.datepicker.formatDate("dd.mm.yy", date);
                if (data.lastDate) {
                    data.lastDate = $.datepicker.formatDate("dd.mm.yy", new Date(data.lastDate));
                } else {
                    data.lastDate = '';
                }
                data.hours = date.getHours();
                data.minutes = date.getMinutes();

                var body = $(HandyReminder.dialog({data: data}));
                var descInput = body.find('.hrd-desc');
                var dateInput = body.find('.hrd-date');
                var hoursInput = body.find('.hrd-time-h');
                var minutesInput = body.find('.hrd-time-m');
                var lastDateInput = body.find('.hrd-lastdate');
                var recipientsInput = body.find('.hrd-recipients');
                var typeSelect = body.find('.hrd-type');
                var recipientsContainer = body.find('.reminder-recipients-container');
                var activeInput = body.find('.hrd-active');
                var showDescInput = body.find('.hrd-show-desc');
                var showDateInput = body.find('.hrd-show-date');
                var amountInput = body.find('.hrd-amount');
                var dayOfWeekInput = body.find('.hrd-day-of-week');

                var dialog = new AJS.Dialog({
                    width: 425,
                    height: 480,
                    id: "reminder-dialog",
                    closeOnOutsideClick: false
                });

                dialog.addHeader(AJS.I18n.getText("handy.reminder.dialog.title"));
                dialog.addPanel('panel', body, 'reminder-dialog-panel');
                dialog.addButton(AJS.I18n.getText("handy.macros.config.save"), function() {
                    var error = reminderUtils.saveMacro();
                    if (error) {
                        var isReadOnly = error.responseText.indexOf('com.atlassian.confluence.api.service.exceptions.ReadOnlyException') !== -1;
                        AJS.flag({
                            type: 'error',
                            body: isReadOnly ? AJS.I18n.getText("handy.macros.read-only-mode") : AJS.I18n.getText("handy.macros.config.error.body")
                        });
                    } 

                    if (activeInput.is(':checked')) {
                        icon.removeClass('inactive');
                    } else {
                        icon.addClass('inactive');
                    }
                    description.text(descInput.val());
                    if (showDescInput.is(':checked')) {
                        description.show();
                    } else {
                        description.hide();
                    }

                    var date = $.datepicker.parseDate("dd.mm.yy", dateInput.val());
                    dateSpan.find('.handy-date-value').text(HandyDateUtils.formatDate(date));
                    HandyDateUtils.updateTimeStyle(dateSpan, date.setDate(date.getDate() - 1));
                    if (showDateInput.is(':checked')) {
                        dateSpan.show();
                    } else {
                        dateSpan.hide();
                    }
                    dialog.remove();
                    return false;
                }, "reminder-dialog-save");

                dialog.addLink(AJS.I18n.getText("handy.macros.config.cancel"), function (dialog) {
                    dialog.remove();
                }, '#');

                var saveBtn = $('.reminder-dialog-save').prop('disabled', true);

                var reminderUtils = new ReminderUtils(id, descInput, dateInput, hoursInput, minutesInput, lastDateInput,
                    recipientsInput, typeSelect, activeInput, showDescInput, showDateInput, amountInput, dayOfWeekInput,
                    recipientsContainer, saveBtn, contentId);
                dialog.show();
                reminderUtils.initInputs();

                typeSelect.trigger('change');

                descInput.add(lastDateInput).add(activeInput).add(typeSelect).bind('keyup input change', function() {
                    dateInput.trigger('change');
                });

                var warning = $(HandyReminder.warning());
                dialog.page[0].buttonpanel.prepend(warning);
                if (data.paused) {
                    warning.show();
                }
                activeInput.change(function() {
                    if (activeInput.is(':checked')) {
                        warning.hide();
                    } else {
                        warning.show();
                    }
                });
            };

            const url = Confluence.getContextPath() + '/rest/handy-macros/2.0/reminder-macro/' + id;
            $.ajax({
                contentType: "application/x-www-form-urlencoded; charset=utf-8",
                type: 'GET',
                cache: false,
                url: url,
                dataType: 'json',
                data: {
                    contentId: contentId,
                },
                success: function(data) {
                    init(data);
                }
            });

            return false;
        });
    }

    if (window.ConfluenceMobile) {
        ConfluenceMobile.contentEventAggregator.on("displayed", function () {
            if (!Confluence.getContextPath) {
                Confluence.getContextPath = AJS.contextPath;
            }
            init();
        });
    } else {
        AJS.toInit(function() {
            init();
        });
    }

})(AJS.$ || $);


