(function($) {

    window.ReminderUtils = function(id, descInput, dateInput, hoursInput, minutesInput, lastDateInput, recipientsInput,
                                    typeSelect, activeInput, showDescInput, showDateInput, amountInput, dayOfWeekInput, recipientsContainer,
                                    saveBtn, contentId) {
        this.id = id;
        this.descInput = descInput;
        this.dateInput = dateInput;
        this.hoursInput = hoursInput;
        this.minutesInput = minutesInput;
        this.lastDateInput = lastDateInput;
        this.recipientsInput = recipientsInput;
        this.typeSelect = typeSelect;
        this.activeInput = activeInput;
        this.showDescInput = showDescInput;
        this.showDateInput = showDateInput;
        this.amountInput = amountInput;
        this.dayOfWeekInput = dayOfWeekInput;
        this.recipientsContainer = recipientsContainer;
        this.contentId = contentId;
        this.saveBtn = saveBtn;
    };

    ReminderUtils.prototype.initInputs = function() {
        var self = this;

        Confluence.Binder.autocompleteUserOrGroup(self.recipientsInput.parent());
        self.recipientsInput.bind("selected.autocomplete-user-or-group", function(e, data) {
            self.recipientsInput.val('');
            var recipient;
            var recipients =  self.recipientsContainer.find('tr[data-type="' + data.content.type + '"]');
            if (data.content.type == 'user') {
                if (recipients.filter('[id="' + data.content.userKey + '"]').length) {
                    return;
                }

                recipient = HandyReminderUtils.recipientUser({
                    name: data.content.username,
                    fullName: data.content.title,
                    key: data.content.userKey,
                    avatar: data.content.thumbnailLink.href
                });
            } else {
                if (recipients.filter('[id="' + data.content.name + '"]').length) {
                    return;
                }

                recipient = HandyReminderUtils.recipientGroup({name: data.content.name});
            }
            self.recipientsContainer.append(recipient);
            Confluence.Binder.userHover();
            self.dateInput.trigger('change');
        });

        $('.reminder-recipients-container')
            .off('click', '.reminder-remove')
            .on('click', '.reminder-remove', function () {
                $(this).parents('.reminder-raw').remove();
                self.dateInput.trigger('change');
            });

        var minDate = $.datepicker.formatDate("dd.mm.yy", new Date());
        self.dateInput.attr('min', minDate);
        self.lastDateInput.attr('min', self.dateInput.val() || minDate);

        var lastDatePicker;
        if (self.dateInput.datePicker) {
            self.dateInput.datePicker({overrideBrowserDefault: true, dateFormat: "dd.mm.yy"});
            lastDatePicker = self.lastDateInput.datePicker({overrideBrowserDefault: true, dateFormat: "dd.mm.yy"});
        } else {
            self.dateInput.datepicker({dateFormat: "dd.mm.yy", minDate: new Date()});
            self.lastDateInput.datepicker({dateFormat: "dd.mm.yy", minDate: $.datepicker.parseDate("dd.mm.yy", self.dateInput.val() || minDate)});
            $('#ui-datepicker-div').click(function(e) {e.stopPropagation()});
        }

        self.typeSelect.change(function() {
            var amountWrapper = self.amountInput.parents('#macro-param-div-amount');
            var index = self.typeSelect.find('option:selected').index();
            if (index === 0) {
                self.lastDateInput.parents('#macro-param-div-lastdate').fadeOut().hide();
                amountWrapper.fadeOut().hide();
                self.showDateInput.parents('#macro-param-div-show-date').fadeIn().show();
            } else {
                self.lastDateInput.parents('#macro-param-div-lastdate').fadeIn().show();
                amountWrapper.fadeIn().show();
                self.showDateInput.parents('#macro-param-div-show-date').fadeOut().hide();
                self.showDateInput.prop('checked', false);
            }

            if (index === 4) {
                self.dayOfWeekInput.parents('#macro-param-div-day-of-week').fadeIn().show();
            } else {
                self.dayOfWeekInput.parents('#macro-param-div-day-of-week').fadeOut().hide();
            }

            var label = amountWrapper.find('label, .handy-reminder-label');
            switch (index) {
                case 1:
                    label.text(AJS.I18n.getText('com.stiltsoft.confluence.handy.macros.handy-reminder.param.amount.label'));
                    break;
                case 2:
                    label.text(AJS.I18n.getText('handy-reminder.param.amount.wd'));
                    break;
                case 3:
                    label.text(AJS.I18n.getText('handy-reminder.param.amount.week'));
                    break;
                case 4:
                    label.text(AJS.I18n.getText('handy-reminder.param.amount.month'));
                    break;
                case 5:
                    label.text(AJS.I18n.getText('handy-reminder.param.amount.year'));
                    break;
            }
        });

        self.dateInput.bind('input change keyup', function() {
            var val = self.dateInput.val().trim();
            if (val) {
                try {
                    var date = $.datepicker.parseDate("dd.mm.yy", val);
                    self.saveBtn.prop('disabled', false);
                    if (self.lastDateInput.attr('min') != self.dateInput.val()) {
                        var lastVal = self.lastDateInput.val();
                        self.lastDateInput.attr('min', self.dateInput.val() || minDate);
                        if (lastDatePicker) {
                            lastDatePicker.reset();
                            self.lastDateInput.val(lastVal);
                        } else {
                            self.lastDateInput.datepicker('option', 'minDate', $.datepicker.parseDate("dd.mm.yy", self.dateInput.val() || minDate));
                        }
                    }
                    self.setDayOfWeek(date);
                } catch(e) {
                    self.saveBtn.prop('disabled', true);
                }
            } else {
                self.saveBtn.prop('disabled', true);
            }
        });

        self.hoursInput.add(self.minutesInput).change(function() {
            self.dateInput.trigger('change');
        });

        self.showDescInput.add(self.showDateInput).change(function() {
            self.saveBtn.prop('disabled', false);
        });

        self.amountInput.bind('input', function () {
            self.dateInput.trigger('change');
        });

        self.dayOfWeekInput.change(function () {
            var selected = self.dayOfWeekInput.find('option:selected');
            self.dayOfWeekInput.attr('data-dow', selected.attr('data-dow'));
            self.dayOfWeekInput.attr('data-dn', selected.attr('data-dn'));
            self.saveBtn.prop('disabled', false);
        });

        self.setDayOfWeek();
    };

    ReminderUtils.prototype.setDayOfWeek = function (date) {
        var self = this;

        if (!date) {
            const dateInputValue = self.dateInput.val().trim();

            if (dateInputValue) {
                try {
                    date = $.datepicker.parseDate("dd.mm.yy", dateInputValue);
                } catch (e) {
                    date = new Date();
                }
            } else {
                date = new Date();
            }
        }

        var dayOfMonth = date.getDate();
        var dn = self.dayOfWeekInput.attr('data-dn');
        var isDOW = self.dayOfWeekInput.attr('data-dow') > 0;
        var dayOfWeek = date.getDay() + 1;
        var dayNumber = Math.ceil(date.getDate() / 7);
        var dayNumberText;
        var shouldAddLatDayOption = false;

        switch (dayNumber) {
            case 1:
                dayNumberText = AJS.I18n.getText('handy-reminder.param.day-of-week.day.first');
                break;
            case 2:
                dayNumberText = AJS.I18n.getText('handy-reminder.param.day-of-week.day.second');
                break;
            case 3:
                dayNumberText = AJS.I18n.getText('handy-reminder.param.day-of-week.day.third');
                break;
            case 4:
                var daysInMonth = new Date(date.getFullYear(), date.getMonth() + 1, 0).getDate();
                shouldAddLatDayOption = daysInMonth - dayOfMonth < 7;
                dayNumberText = AJS.I18n.getText('handy-reminder.param.day-of-week.day.fourth');
                break;
            default:
                dayNumberText = AJS.I18n.getText('handy-reminder.param.day-of-week.day.last');
        }
        var dayOfWeekText;
        switch (dayOfWeek) {
            case 1:
                dayOfWeekText = AJS.I18n.getText('sunday');
                break;
            case 2:
                dayOfWeekText = AJS.I18n.getText('monday');
                break;
            case 3:
                dayOfWeekText = AJS.I18n.getText('tuesday');
                break;
            case 4:
                dayOfWeekText = AJS.I18n.getText('wednesday');
                break;
            case 5:
                dayOfWeekText = AJS.I18n.getText('thursday');
                break;
            case 6:
                dayOfWeekText = AJS.I18n.getText('friday');
                break;
            case 7:
                dayOfWeekText = AJS.I18n.getText('saturday');
                break;
        }

        var selected = isDOW ? '' : 'selected=""selected"';
        self.dayOfWeekInput.empty();
        self.dayOfWeekInput.append('<option data-dow="" data-dn="" ' + selected + '>' +
            AJS.I18n.getText('handy-reminder.param.day-of-week.n', dayOfMonth) + '</option>');
        
        selected = !(isDOW && (!shouldAddLatDayOption || dn == 4)) ? '' : 'selected=""selected"';
        self.dayOfWeekInput.append('<option data-dow="' + dayOfWeek + '" data-dn="' + dayNumber + '" ' + selected + '>' +
            AJS.I18n.getText('handy-reminder.param.day-of-week.day', dayNumberText, dayOfWeekText) + '</option>');

        if (shouldAddLatDayOption) {
            dayNumberText = AJS.I18n.getText('handy-reminder.param.day-of-week.day.last');
            selected = !(isDOW && dn == 5) ? '' : 'selected=""selected"';
            self.dayOfWeekInput.append('<option data-dow="' + dayOfWeek + '" data-dn="5" ' + selected + '>' +
                AJS.I18n.getText('handy-reminder.param.day-of-week.day', dayNumberText, dayOfWeekText) + '</option>');
        }

        self.dayOfWeekInput.change();
    };

    ReminderUtils.prototype.saveMacro = function() {
        var self = this;

        var users = [];
        self.recipientsContainer.find('tr[data-type="user"]').each(function() {
            users.push($(this).attr('id'));
        });

        var groups = [];
        self.recipientsContainer.find('tr[data-type="group"]').each(function() {
            groups.push($(this).attr('id'));
        });

        var lastDate;
        try {
            var date = $.datepicker.parseDate("dd.mm.yy", self.lastDateInput.val());
            date.setHours(23, 59, 59, 0);
            lastDate = date.getTime();
        } catch (e) {}

        var nextDate = $.datepicker.parseDate("dd.mm.yy", self.dateInput.val());
        nextDate.setHours(self.hoursInput.val(), self.minutesInput.val() - 5, 0, 0);

        var amount = self.amountInput.val();
        amount = parseInt(amount);
        amount = isNaN(amount) ? 1 : amount;

        var error = false;

        const macroId = self.id;
        const url = Confluence.getContextPath() + '/rest/handy-macros/2.0/reminder-macro/' + macroId;
        $.ajax({
            contentType: "application/x-www-form-urlencoded; charset=utf-8",
            type: 'PUT',
            cache: false,
            async: false,
            url: url,
            dataType: 'json',
            data: {
                contentId: self.contentId,
                users: users,
                groups: groups,
                date: nextDate.getTime(),
                lastDate: lastDate,
                type: self.typeSelect.find('option:selected').index(),
                amount: amount,
                desc: self.descInput.val(),
                paused: !self.activeInput.is(':checked'),
                showDesc: self.showDescInput.is(':checked'),
                showDate: self.showDateInput.is(':checked'),
                dayOfWeek: self.dayOfWeekInput.attr('data-dow') || undefined,
                dayNumber: self.dayOfWeekInput.attr('data-dn') || undefined
            },
            error: function (xhr) {
                error = xhr;
            }
        });

        return error;
    };

})(AJS.$ || $);



