window.require(
    ['ajs', 'confluence/root', 'jquery', 'stiltsoft/HandyMacrosPageEditorPasteProcessor'],
    (ajs, confluence, $, pasteProcessor) => {

        const cloneReminderMacro = (macroId) => {
            let newMacroId;
            $.ajax({
                type: 'POST',
                url: `${confluence.getContextPath()}/rest/handy-macros/2.0/reminder-macro/${macroId}/clone`,
                contentType: 'application/x-www-form-urlencoded; charset=utf-8',
                cache: false,
                async: false,
                dataType: 'json',
                data: {contentId: ajs.params.contentId ? ajs.params.contentId : undefined},
                success: (id) => {
                    newMacroId = '' + id;
                },
            });
            return newMacroId;
        };

        const onPasteHandyReminder = ($macro, sourceMacroParams) => {
            const updatedMacroParams = Object.assign({}, sourceMacroParams);
            updatedMacroParams.id = cloneReminderMacro(sourceMacroParams.id);
            return updatedMacroParams;
        };

        const initPasteProcessor = () => pasteProcessor.init('handy-reminder', onPasteHandyReminder)

        ajs.bind('init.rte', initPasteProcessor);
    });
