(function($, AnalyticsExtender) {

    var reminderUtils;
    var HandyReminderMacroJsOverride = function() {
    };

    HandyReminderMacroJsOverride.prototype.beforeParamsRetrieved = function(params) {
        reminderUtils.saveMacro();
        return params;
    };

    HandyReminderMacroJsOverride.prototype.beforeParamsSet = function(params) {
        $('#macro-browser-dialog .macro-desc .macro-doco-link').before(AJS.I18n.getText("handy.macros.feature-request"));

        $('#macro-param-div-time-m label').text(':');

        var showLicenseError = function() {
            var form = $('#macro-param-div-date, #macro-param-div-type, #macro-param-div-description, ' +
                '#macro-param-div-recipients, #macro-param-div-active, #macro-param-div-show-desc, ' +
                '#macro-param-div-lastdate, #macro-param-div-amount, #macro-param-div-show-date').hide().parent();
            AJS.messages.warning(form, {
                body: AJS.I18n.getText("handy.macros.license.fail", Confluence.getContextPath()),
                closeable: false
            });
        };

        if (!params['id']) {
            $.ajax({
                contentType: "application/x-www-form-urlencoded; charset=utf-8",
                type: 'POST',
                cache: false,
                async: false,
                url: Confluence.getContextPath() + '/rest/handy-macros/2.0/reminder-macro',
                dataType: 'json',
                data: {
                    contentId: AJS.params.contentId ? AJS.params.contentId : undefined,
                    users: [],
                    groups: [],
                    date: new Date().setHours(7, 55, 0, 0) + 24*60*60*1000,
                    type: 0,
                    desc: '',
                    paused: false
                },
                success: function(data) {
                    if (!data) {
                        showLicenseError();
                    } else {
                        params['id'] = data;
                    }
                }
            });
        }

        var id = params['id'];

        if (!id) {
            return params;
        }

        var descInput = $(HandyReminderMacro.desc());
        var dateInput = $('#macro-param-date');
        var hoursInput = $('#macro-param-time-h');
        var minutesInput = $('#macro-param-time-m');
        var lastDateInput = $('#macro-param-lastdate');
        var recipientsInput = $('#macro-param-recipients');
        var typeSelect = $('#macro-param-type');
        var recipientsContainer = $(HandyReminderMacro.recipientsContainer());
        var pauseInput = $('#macro-param-active');
        var showDescInput = $('#macro-param-show-desc');
        var showDateInput = $('#macro-param-show-date');
        var amountInput = $('#macro-param-amount');
        var dayOfWeekInput = $('#macro-param-day-of-week');

        $('#macro-param-description').replaceWith(descInput);

        recipientsInput.val('').addClass('autocomplete-user-or-group').attr('data-none-message', AJS.I18n.getText('macro.browser.smartfields.not.found'));
        recipientsInput.parent().append(recipientsContainer);

        amountInput.attr('type', 'number');
        amountInput.attr('min', '1');

        const url = Confluence.getContextPath() + '/rest/handy-macros/2.0/reminder-macro/' + id;
        $.ajax({
            contentType: "application/x-www-form-urlencoded; charset=utf-8",
            type: 'GET',
            cache: false,
            async: false,
            url: url,
            dataType: 'json',
            data: {
                contentId: AJS.params.contentId ? AJS.params.contentId : undefined,
            },
            success: function(data) {
                if (!data.licensed) {
                    showLicenseError()
                } else {
                    descInput.val(data.desc);
                    var date = new Date(data.date + 300000);
                    params['date'] = $.datepicker.formatDate("dd.mm.yy", date);
                    params['time-h'] = date.getHours();
                    params['time-m'] = date.getMinutes() < 10 ? '0' + date.getMinutes() : date.getMinutes();
                    params['lastdate'] = data.lastDate ? $.datepicker.formatDate("dd.mm.yy", new Date(data.lastDate)) : '';
                    params['type'] = typeSelect.find('option').eq(data.type).prop('selected', true).text();
                    params['active'] = !data.paused;
                    params['show-desc'] = data.showDesc;
                    params['show-date'] = data.showDate;
                    params['amount'] = data.amount;
                    if(params['id'] != data.id) {
                        params['id'] = data.id
                        id = data.id;
                    }

                    dayOfWeekInput.attr('data-dow', data.dayOfWeek).attr('data-dn', data.dayNumber);
                    dateInput.val(params['date']).trigger('change');

                    reminderUtils = new ReminderUtils(id, descInput, dateInput, hoursInput, minutesInput, lastDateInput, recipientsInput,
                        typeSelect, pauseInput, showDescInput, showDateInput, amountInput, dayOfWeekInput, recipientsContainer, $('.button-panel-button.ok'),
                        AJS.params.contentId ? AJS.params.contentId : undefined);
                    reminderUtils.initInputs();

                    typeSelect.trigger('change');

                    data.users.forEach(function(user) {
                        recipientsContainer.append(HandyReminderUtils.recipientUser({
                            name: user.name,
                            fullName: user.fullName,
                            key: user.key,
                            avatar: Confluence.getContextPath() + user.avatarUrl
                        }));
                    });
                    Confluence.Binder.userHover();

                    data.groups.forEach(function(group) {
                        recipientsContainer.append(HandyReminderUtils.recipientGroup({name: group}));
                    });
                }
            }
        });

        var sendTestMail = $(HandyReminderMacro.sendTestMail());
        $('#macro-param-div-active').after(sendTestMail);
        var mailMessageDiv = $('<div></div>');
        sendTestMail.after(mailMessageDiv);

        sendTestMail.click(function() {
            const url = Confluence.getContextPath() + '/rest/handy-macros/2.0/reminder-macro/' + id + '/test-mail';
            $.ajax({
                contentType: "application/x-www-form-urlencoded; charset=utf-8",
                type: 'POST',
                cache: false,
                async: false,
                url: url,
                dataType: 'json',
                data: {
                    contentId: AJS.params.contentId ? AJS.params.contentId : undefined,
                    text: descInput.val(),
                    title: $('#content-title').val(),
                    spaceKey: AJS.params.spaceKey
                },
                success: function() {
                    AJS.messages.info(mailMessageDiv, {
                        body: AJS.I18n.getText("handy.macros.reminder.test-mail-sent"),
                        closeable: true
                    });
                },
                error: function () {
                    AJS.messages.error(mailMessageDiv, {
                        body: AJS.I18n.getText("handy.macros.reminder.test-mail-not-sent"),
                        closeable: true
                    });
                }
            });

            return false;
        });

        var timer = null;
        dateInput.add(lastDateInput).bind('input change', function() {
            if (timer) {
                clearTimeout(timer);
            }
            timer = setTimeout(function() {
                $('#macro-browser-preview-link').click();
            }, 330);
        });

        typeSelect.add(pauseInput).add(showDescInput).add(dayOfWeekInput).add(showDateInput).change(function() {
            $('#macro-browser-preview-link').click();
        });

        return params;
    };

    var instance = AnalyticsExtender.extend(new HandyReminderMacroJsOverride());

    AJS.MacroBrowser.setMacroJsOverride("handy-reminder", instance);

})(AJS.$,require('stiltsoft/handy-macros/analytics/client/extender'));
