window.define('stiltsoft/handy-macros/timestamp-utils', ['exports'], function(exports) {
    const formatOptions = [
        {label: 'dd.MM.yyyy HH:mm (25.09.2019 12:42)', value: 'dd.MM.yyyy HH:mm'},
        {label: 'dd.MM.yyyy HH:mm:ss (25.09.2019 12:42:13)', value: 'dd.MM.yyyy HH:mm:ss'},
        {label: 'MM/dd/yyyy hh:mm a (09/25/2019 12:42 PM)', value: 'MM/dd/yyyy hh:mm a'},
        {label: 'MMM dd, yyyy hh:mm a (Sep 25, 2019 01:02 PM)', value: 'MMM dd, yyyy hh:mm a'},
        {label: 'dd.MM.yyyy (25.09.2019)', value: 'dd.MM.yyyy'},
        {label: 'MM/dd/yyyy (09/25/2019)', value: 'MM/dd/yyyy'},
        {label: 'MMM dd, yyyy (Sep 25, 2019)', value: 'MMM dd, yyyy'},
        {label: 'HH:mm (13:16)', value: 'HH:mm'},
        {label: 'HH:mm:ss (13:16:45)', value: 'HH:mm:ss'},
        {label: 'hh:mm a (13:16 PM)', value: 'hh:mm a'},
    ];

    function inputAutocomplete(input, parent, options) {
        input.autocomplete(
            {
                source: options,
                minLength: 0,
                appendTo: parent,
                select: function(data, ui) {
                    input.val(ui.item.value);
                    input.trigger('change');
                },
                classes: {
                    'ui-autocomplete': 'hm'
                }
            }
        );
        input.focus(function() {
            input.autocomplete('search', '');
        });
        const widget = input.autocomplete('widget');
        if (widget) {
            widget.click(function(e) {
                e.stopPropagation();
            });
        } else {
            const autocompleteResources = 'com.stiltsoft.confluence.handy.macros:jquery-autocomplete-resources';
            WRM.require(autocompleteResources, function() {
                inputAutocomplete(input, parent, options);
            });
        }
    }

    exports.dateFormatAutocomplete = function(input) {
        inputAutocomplete(input, parent, formatOptions);
    };
});
