(function($, AnalyticsExtender, TimestampUtils, CookieManager) {

    const TimestampMacroJsOverride = function() {};

    TimestampMacroJsOverride.prototype.beforeParamsSet = function(params) {
        $('#macro-browser-dialog .macro-desc .macro-doco-link').before(AJS.I18n.getText('handy.macros.feature-request'));

        const format = $('#macro-param-format').on('change', function() {
            CookieManager.setCookie('handy-ts-format', format.val());
            $('#macro-browser-preview-link').trigger('click');
        });

        if (params.time === undefined) {
            $.ajax({
                async: false,
                cache: false,
                type: 'GET',
                contentType: 'application/json; charset=utf-8',
                url: AJS.params.contextPath + '/rest/handy-macros/2.0/timestamp',
                dataType: 'json',
                success: function(data) {
                    params.time = data;
                },
                error: function() {
                    params.time = new Date().getTime();
                },
                timeout: 90000
            });
        }

        if (!params.format) {
            params.format = CookieManager.getCookie('handy-ts-format') || 'dd.MM.yyyy HH:mm';
        }

        TimestampUtils.dateFormatAutocomplete(format);

        return params;
    };

    const instance = AnalyticsExtender.extend(new TimestampMacroJsOverride());

    AJS.MacroBrowser.setMacroJsOverride('timestamp', instance);
})(
    AJS.$,
    require('stiltsoft/handy-macros/analytics/client/extender'),
    require('stiltsoft/handy-macros/timestamp-utils'),
    require('stiltsoft/handy-macros/cookie-manager'),
);
