(function($) {

    AJS.bind("init.rte", function() {

        function setUpTaskReport(jsOverride) {
            var beforeParamsSet = jsOverride.beforeParamsSet;

            jsOverride.beforeParamsSet = function (params) {
                var select = $('#macro-param-pageSize');
                var input = $('<input class="text macro-param-input" id="macro-param-pageSize">');
                select.after(input);
                input.val(params["pageSize"]);
                select.remove();

                if (typeof beforeParamsSet === "function") {
                    return beforeParamsSet(params);
                }
                return params;
            }
        }

        function checkTaskReportReady(i) {
            var jsOverride = AJS.MacroBrowser.Macros["tasks-report-macro"];
            if (jsOverride) {
                setUpTaskReport(jsOverride);
            } else if (i < 10) {
                setTimeout(function () {
                    checkTaskReportReady(++i);
                }, 500);
            }
        }

        checkTaskReportReady(0);
    });

})(AJS.$);
