(function($, AnalyticsExtender) {

    const selects ={
        'type': {
            'child-pages': {
                title: AJS.I18n.getText('handy-post-organizer.param.type.child-pages'),
                hiddenParams: ['content-type', 'labels', 'labels-logic', 'space', 'limit', 'sort']
            },
            'search': {
                title: AJS.I18n.getText('handy-post-organizer.param.type.search'),
                hiddenParams: []
            },
            'custom': {
                title: AJS.I18n.getText('handy-post-organizer.param.type.custom'),
                hiddenParams: ['content-type', 'labels', 'labels-logic', 'space', 'limit', 'sort', 'text-source', 'text-length', 'image-source', 'image-name']
            }
        },
        'content-type': {
            'all': {
                title: AJS.I18n.getText('handy-post-organizer.param.content-type.all'),
                hiddenParams: []
            },
            'pages': {
                title: AJS.I18n.getText('handy-post-organizer.param.content-type.pages'),
                hiddenParams: []
            },
            'blog-posts': {
                title: AJS.I18n.getText('handy-post-organizer.param.content-type.blog-posts'),
                hiddenParams: []
            }
        },
        'view': {
            'fixed': {
                title: AJS.I18n.getText('handy-post-organizer.param.view.fixed'),
                hiddenParams: ['column-width']
            },
            'responsive': {
                title: AJS.I18n.getText('handy-post-organizer.param.view.responsive'),
                hiddenParams: ['columns-number']
            }
        },
        'sort': {
            'date': {
                title: AJS.I18n.getText('handy-post-organizer.param.sort.date'),
                hiddenParams: []
            },
            'title': {
                title: AJS.I18n.getText('handy-post-organizer.param.sort.title'),
                hiddenParams: []
            },
            'modified': {
                title: AJS.I18n.getText('handy-post-organizer.param.sort.last-modified-date'),
                hiddenParams: []
            },
        },
        'text-source': {
            'beginning': {
                title: AJS.I18n.getText('handy-post-organizer.param.text-source.beginning'),
                hiddenParams: ['show-page-title']
            },
            'excerpt': {
                title: AJS.I18n.getText('handy-post-organizer.param.text-source.excerpt'),
                hiddenParams: ['text-length', 'image-source', 'image-name', 'max-image-height']
            }
        },
        'image-source': {
            'first': {
                title: AJS.I18n.getText('handy-post-organizer.param.image-source.first'),
                hiddenParams: ['image-name']
            },
            'first-or-empty': {
                title: AJS.I18n.getText('handy-post-organizer.param.image-source.first-or-empty'),
                hiddenParams: ['image-name', 'max-image-height']
            },
            'name': {
                title: AJS.I18n.getText('handy-post-organizer.param.image-source.name'),
                hiddenParams: []
            },
            'none': {
                title: AJS.I18n.getText('handy-post-organizer.param.image-source.none'),
                hiddenParams: ['image-name', 'max-image-height']
            },
        },
        'show-date': {
            'none': {
                title: AJS.I18n.getText('handy-post-organizer.param.show-date.none'),
                hiddenParams: []
            },
            'created': {
                title: AJS.I18n.getText('handy-post-organizer.param.show-date.created'),
                hiddenParams: []
            },
            'last-modified': {
                title: AJS.I18n.getText('handy-post-organizer.param.show-date.last-modified'),
                hiddenParams: []
            },
        },
        'labels-logic': {
            'or': {
                title: AJS.I18n.getText('handy-post-organizer.param.label-logic.or'),
                hiddenParams: []
            },
            'and': {
                title: AJS.I18n.getText('handy-post-organizer.param.label-logic.and'),
                hiddenParams: []
            }
        }
    };
    const numberInputs = ['limit', 'text-length', 'columns-number', 'column-width', 'max-image-height'];
    const TEXT_LENGTH_MIN = '0';
    const TEXT_LENGTH_LIMIT = '500';
    const CARDS_MIN = '1';
    const CARDS_LIMIT = '50';
    const COLUMNS_NUMBER_MIN = '1';
    const COLUMNS_NUMBER_LIMIT = '20';
    const COLUMNS_WIDTH_MIN = '50';
    const COLUMNS_WIDTH_LIMIT = '3000';
    const IMAGE_HEIGHT_MIN = '0';
    const IMAGE_HEIGHT_MAX = '300';

    const MacroJsOverride = function () {
    };

    MacroJsOverride.prototype.beforeParamsSet = function(params) {
        $('#macro-browser-dialog .macro-desc .macro-doco-link').before(AJS.I18n.getText('handy.macros.feature-request'));

        showCreatedCompatibility(params);

        $.each(selects, function (selectName) {
            const select = $('#macro-param-' + selectName);
            const selectOpts = selects[selectName];
            setSelectOptionNames(select, selectOpts);
            bindSelect(select, selectOpts, params, selectName);
        });

        numberInputs.forEach(function(inputName) {
           $('#macro-param-' + inputName)
               .val(params[inputName])
               .on('blur', checkFields);
        });

        return params;
    };

    // HANDY-572
    // https://community.atlassian.com/t5/Confluence-questions/How-to-make-a-parameter-a-label-picker-in-the-Macro-Browser/qaq-p/377605
    MacroJsOverride.prototype.beforeParamsRetrieved = function (params) {
        initLabelsInput(params);
        return params;
    };

    MacroJsOverride.prototype.fields = {
        'string': {
            'limit': function(param) {
                const inputParams = {
                    name: param.name,
                    label: param.displayName,
                    min: CARDS_MIN,
                    max: CARDS_LIMIT
                }
                return getNumberInput(inputParams);
            },
            'text-length': function(param) {
                const inputParams = {
                    name: param.name,
                    label: param.displayName,
                    min: TEXT_LENGTH_MIN,
                    max: TEXT_LENGTH_LIMIT
                }
                return getNumberInput(inputParams);
            },
            'columns-number': function(param) {
                const inputParams = {
                    name: param.name,
                    label: param.displayName,
                    min: COLUMNS_NUMBER_MIN,
                    max: COLUMNS_NUMBER_LIMIT
                }
                return getNumberInput(inputParams);
            },
            'column-width': function(param) {
                const inputParams = {
                    name: param.name,
                    label: param.displayName,
                    min: COLUMNS_WIDTH_MIN,
                    max: COLUMNS_WIDTH_LIMIT
                }
                return getNumberInput(inputParams);
            },
            'max-image-height': function(param) {
                const inputParams = {
                    name: param.name,
                    label: param.displayName,
                    min: IMAGE_HEIGHT_MIN,
                    max: IMAGE_HEIGHT_MAX
                }
                return getNumberInput(inputParams);
            },
        }
    }

    function setSelectOptionNames(select, options) {
        select.find('option').each(function () {
            const option = $(this);
            const value = option.text().trim();
            option.attr('value', value);
            option.text(options[value].title);
        });
    }

    function bindSelect(select, options, params, selectName) {
        select.change(function() {
            const hiddenClass = 'hpo-hidden-' + selectName;
            $('.' + hiddenClass).removeClass(hiddenClass);
            const option = options[select.val()];
            if (option) {
                const ids = option.hiddenParams.map(function (type) {
                    return '#macro-param-div-' + type;
                });
                $(ids.join(',')).addClass(hiddenClass);
            }
        }).val(params[selectName] || Object.keys(options)[0]).trigger('change');
    }

    function initLabelsInput(params) {
        var labelsInput = $('#macro-param-labels');

        if (params && params.labels) {
            labelsInput.val(params.labels);
        }

        labelsInput.auiSelect2(Confluence.UI.Components.LabelPicker.build({
            separator : ",",
            queryOpts : {
                spaceKey : AJS.Meta.get('space-key')
            }
        }));
    }

    function getNumberInput(inputParams) {
        const paramDiv = $(Confluence.Templates.MacroBrowser.macroParameter());
        const input = $('#macro-param-text-length', paramDiv);

        const numberInputWithLabel = Stiltsoft.HandyMacros.Input.numberInputWithLabel(inputParams);
        paramDiv.empty();
        paramDiv.append(numberInputWithLabel);

        return AJS.MacroBrowser.Field(paramDiv, input);
    }

    function checkFields() {
        var form = $('.macro-input-fields form').get(0);
        var isValid = form.reportValidity();
        AJS.MacroBrowser.UI.enableSaveButton(isValid);
    }

    function showCreatedCompatibility(params) {
        if (params['show-created'] === 'true') {
            params['show-date'] = 'created';
            delete params['show-created'];
        }
    }

    var instance = AnalyticsExtender.extend(new MacroJsOverride());

    AJS.MacroBrowser.setMacroJsOverride("handy-post-organizer", instance);

})(AJS.$,require('stiltsoft/handy-macros/analytics/client/extender'));



