(function ($, AnalyticsExtender) {

    var HandyButtonMacroJsOverride = function () {
    };

    HandyButtonMacroJsOverride.prototype.beforeParamsSet = function (params) {
        $('#macro-browser-dialog .macro-desc .macro-doco-link').before(AJS.I18n.getText("handy.macros.feature-request"));

        var colorSelect = $('#macro-param-color').hide();
        colorSelect.before(HandyButtonMacro.colorDropDown());

        var $dropdownColorButton = $('#handy-button-dd');
        var $dropdownColorItem = $('#handy-button-colors .handy-button-color-item');

        $('#handy-button-colors').on('click', '.handy-button-color-item', event => {
            const $colorItem = $(event.currentTarget);
            colorSelect.find('option:contains(' + $colorItem.data('color') + ')').prop('selected', true);
            const $clonedColorItem = $colorItem.clone();
            $dropdownColorButton.html($clonedColorItem);

            $dropdownColorButton.trigger('click');
        });

        if (params['color']) {
            $dropdownColorButton.html($dropdownColorItem.filter('[data-color="' + params['color'] + '"]').clone());
        }

        $('#macro-browser-dialog').find('.button-panel-button.ok, .button-panel-cancel-link').one('click', function () {
            if ($dropdownColorButton.hasClass('active')) {
                $dropdownColorButton.trigger("aui-button-invoke");
            }
        });

        HandyButtonEditor.bindAutocompleteUrlInput($('#macro-param-link'));

        return params;
    };
    var instance = AnalyticsExtender.extend(new HandyButtonMacroJsOverride());
    AJS.MacroBrowser.setMacroJsOverride("button-handy", instance);

})(AJS.$, require('stiltsoft/handy-macros/analytics/client/extender'));

