(function ($) {
    function init() {
        const body = $('body');
        $('a[href*="handytip-"]').not('[data-aui-trigger]').attr('data-aui-trigger', true).each(function (i) {
            const a = $(this);
            const href = a.attr('href');
            const id = href.substring(href.indexOf('handytip-'));
            a.attr('aria-controls', id + i);

            const dialog = $('<aui-inline-dialog responds-to="hover"></aui-inline-dialog>');
            const textarea = $('textarea#' + id);
            const sanitizedBody = HandyMacrosDOMPurify.sanitize(textarea.val(), {FORBID_TAGS: ['style', 'link', 'script', 'base', 'head', 'meta']});
            dialog.attr('id', id + i).html(sanitizedBody);
            body.append(dialog);
        });
        
        $('.handytip-textarea').remove();
    }

    function bindDOMChange() {
        var timer = null;
        var onInsert = function (target) {
            if (target.find('a[href*="handytip-"]').length) {
                if (timer) {
                    clearTimeout(timer);
                    timer = null;
                }
                timer = setTimeout(init, 100);
            }
        };

        var wikiContent = $('.wiki-content');
        if (wikiContent.length && wikiContent.find('.microBlogWrapper').length === 0) {
            if (window.MutationObserver) {
                var observer = new MutationObserver(function (events) {
                    events.some(function (event) {
                        if (event.addedNodes.length) {
                            return onInsert($(event.addedNodes));
                        }
                    });
                });
                observer.observe(wikiContent[0], {
                    childList: true,
                    subtree: true
                });
            } else {
                wikiContent.bind('DOMNodeInserted', function (e) {
                    onInsert($(e.target));
                });
            }
        }
    }


    if (window.ConfluenceMobile) {
        ConfluenceMobile.contentEventAggregator.on("displayed", function () {
            init();
            bindDOMChange();
        });
    } else {
        AJS.toInit(function () {
            init();
            bindDOMChange();
        });
    }

})(AJS.$ || $);
