(function($, AnalyticsClient) {

    if (!AJS || !AJS.toInit) {
        return;
    }

    var HandyTasks = {

        init: function () {
            var self = this;
            var editable = $('#editPageLink').length > 0;

            self.taskLists = $('.wiki-content').find('.inline-task-list');
            self.taskLists.each(function () {
                var taskList = $(this);
                if (taskList.parents('.tasks-report, .inline-task-list').length === 0 && taskList.children('li').length > 1) {
                    if (editable) self.initTaskList(taskList);
                    self.initFilters(taskList);
                    self.initTaskListCharts(taskList);
                    self.initExpander(taskList);
                }
            });
        },

        initTaskList: function (taskList) {
            var self = this;
            var adder = $(HandyTasksTemplate.adder());
            taskList.append(adder);

            var shower = adder.find('.handy-task-adder-shower');
            var controls = adder.find('.handy-task-adder-controls-container');
            var saveBtn = controls.find('.save');
            var cancel = controls.find('.cancel');

            shower.click(function () {
                adder.removeClass('view');
                self.initEditor(adder, saveBtn, cancel);
                return false;
            });

            cancel.click(function () {
                adder.addClass('view');
                if (AJS.Rte && AJS.Rte.getEditor()) {
                    AJS.Confluence.QuickEdit.deactivateEditor();
                }
            });

            saveBtn.click(function () {
                $.ajax({
                    contentType: "application/x-www-form-urlencoded; charset=utf-8",
                    type: 'POST',
                    url: Confluence.getContextPath() + '/rest/handy-macros/2.0/task',
                    dataType: 'json',
                    data: {
                        contentId: taskList.attr('data-inline-tasks-content-id'),
                        lastTaskId: taskList.find('li[data-inline-task-id]').last().attr('data-inline-task-id'),
                        summary: AJS.Rte.Content.getHtml()
                    },
                    success: function (data) {
                        AnalyticsClient.sendFeatureUsedEvent("Handy Tasks");
                        cancel.click();
                        var newTask = $(HandyTasksTemplate.task({data: data}));

                        adder.before(newTask);
                        Confluence.Binder.userHover();
                        taskList.trigger('handy-task-added');

                        if (window.HandyDate) {
                            self.getTaskListPageId(taskList);
                            HandyDate.init();
                        }
                    },
                    error: self.showError
                });
            });
        },

        initEditor: function(adder, saveBtn, cancel) {
            AJS.Confluence.QuickEdit.activateEditor({
                preInitialise: function (options) {AJS.log(options);
                    AJS.Confluence.QuickEdit.QuickComment.preInitialise(options)
                },
                postInitialise: function () {
                    $(AJS.Rte.getEditorFrame()).contents().find('body').css({'margin': 0, 'padding': '8px', 'box-sizing': 'border-box'});
                },
                toolbar: true,
                $container : adder.find('.handy-task-adder-controls'),
                $form : adder.find('.ht-editor-form'),
                saveHandler: function () {
                    saveBtn.click();
                    return false;
                },
                cancelHandler: function () {
                    cancel.click();
                },
                fetchContent: function () {
                    var responseDeferred = new $.Deferred();
                    responseDeferred.resolve({editorContent: ''});
                    return responseDeferred;
                },
                fallbackUrl: '',
                closeAnyExistingEditor: true,
                postDeactivate: function () {
                    cancel.click();
                },
                plugins: AJS.Confluence.Editor._Profiles.createProfileForCommentEditor().plugins
            }).fail(function (e) {
                HandyTasks.showError(e);
                cancel.click();
            });
        },

        getDatePickerValue: function (value) {
            var self = this;
            try {
                self.date = $.datepicker.parseDate(HandyDateUtils.getLocaleFormat(), value, HandyDateUtils.localisations[HandyDateUtils.getLocale()]);
                return $.datepicker.formatDate('yy-mm-dd', self.date);
            } catch (e) {
                return '';
            }
        },

        initTaskListCharts: function (taskList) {
            var self = this;
            var progressBarLi = $(HandyTasksTemplate.progress());
            var progressBar = progressBarLi.find('.aui-progress-indicator');
            taskList.prepend(progressBarLi);
            self.updateProgressBar(taskList, progressBar);

            AJS.bind("inline-tasks.status-update.complete", function (e, status) {
                if (taskList.find('[data-inline-task-id="' + status.taskId + '"]').length) {
                    self.updateProgressBar(taskList, progressBar);
                }
            });

            taskList.bind('handy-task-added', function () {
                self.updateProgressBar(taskList, progressBar);
            });
        },

        updateProgressBar: function (taskList, progressBar) {
            var self = this;
            var lis = taskList.children('li');
            var unchecked = lis.length - 3;
            var checked = lis.filter('.checked').length;

            if (AJS.progressBars) {
                AJS.progressBars.update(progressBar, checked / unchecked);
            } else {
                setTimeout(function () {
                    self.updateProgressBar(taskList, progressBar);
                }, 200);
            }
            
            taskList.find('.handy-task-progress-value').text(checked + ' / ' + unchecked);
        },

        initFilters: function (taskList) {
            var filters = $(HandyTasksTemplate.filters());
            taskList.prepend(filters);

            var allFilters = filters.find('.handy-task-filter');
            allFilters.click(function () {
                allFilters.addClass('aui-lozenge-subtle');
                var filter = $(this).removeClass('aui-lozenge-subtle');
                var lis = taskList.children().not('.handy-task-filters, .handy-task-list-progress, .handy-task-adder-container');
                lis.removeClass('htddf');
                if (!filter.hasClass('all')) {
                    lis.filter('.checked').addClass('htddf');
                    lis = lis.not('.ckecked');
                    
                    if (filter.hasClass('overdue')) {
                        lis.filter(function () {
                            return $(this).find('time.date-past').length === 0;
                        }).addClass('htddf');
                    } else if (filter.hasClass('upcoming')) {
                        lis.filter(function () {
                            return $(this).find('time.date-upcoming').length === 0;
                        }).addClass('htddf');
                    } else if (filter.hasClass('due')) {
                        lis.filter(function () {
                            return $(this).find('time.date-upcoming, time.date-past').length > 0;
                        }).addClass('htddf');
                    }
                }
            });

            var assigneeFilter = filters.find('.handy-task-assignee-filter');
            Confluence.Binder.autocompleteUserOrGroup(assigneeFilter);
            var userContainer = assigneeFilter.find('.ht-selected-user');
            var userInput = assigneeFilter.find('.autocomplete-user');
            userInput.bind("selected.autocomplete-user-or-group", function(e, data) {
                var user = data.content;

                var lis = taskList.children().not('.handy-task-filters, .handy-task-list-progress, .handy-task-adder-container');
                lis.filter(function () {
                    return $(this).find('a[data-username="' + user.key + '"]').length === 0;
                }).addClass('htaf');

                userInput.val('');
                userContainer.html(HandyTasksTemplate.user({user: user}));
                userInput.hide();

                userContainer.find('.aui-iconfont-remove-label').click(function () {
                    userInput.show();
                    userContainer.html('');
                    lis.removeClass('htaf');
                });
                
                Confluence.Binder.userHover();
            });
        },

        initExpander: function (taskList) {
            var self = this;
            var expander = $(HandyTasksTemplate.expander());
            taskList.prepend(expander);
            taskList.addClass('htl');

            var key = self.getTaskListKey(taskList);
            
            expander.click(function () {
                localStorage.setItem(key, 'true');
                taskList.addClass('handy-task-opened');
            });

            if (localStorage.getItem(key)) {
                taskList.addClass('handy-task-opened');
            }

            taskList.find('.htl-close').click(function () {
                localStorage.removeItem(key);
                taskList.removeClass('handy-task-opened');
            });

            $(window).scroll(function () {
                self.relocateExpander(taskList, expander);
            });

            self.relocateExpander(taskList, expander);
        },

        relocateExpander: function (taskList, expander) {
            var $window = $(window);
            var top = taskList.offset().top;
            var height = taskList.height();
            var bottom = top + height;
            var scrollTop = $window.scrollTop();
            var scrollBottom = scrollTop + $window.height();
            expander.css({
                top: Math.min(Math.max(0, scrollTop - top), height),
                bottom: Math.min(Math.max(0, bottom - scrollBottom), height)
            });
        },

        getTaskListKey: function (taskList) {
            return 'htl' + this.getTaskListPageId(taskList) + taskList.find('li[data-inline-task-id]').eq(0).attr('data-inline-task-id');
        },

        getTaskListPageId: function (taskList) {
            return taskList.attr('data-inline-tasks-content-id');
        },

        showError: function(xhr) {
            var isReadOnly = xhr && (xhr === 'READ_ONLY' ||
                xhr.responseText.indexOf('com.atlassian.confluence.api.service.exceptions.ReadOnlyException') !== -1);
            AJS.flag({
                type: 'error',
                body: isReadOnly ? AJS.I18n.getText("handy.macros.read-only-mode") : AJS.I18n.getText("handy.macros.config.error.body")
            });
        }
    };


    if (window.ConfluenceMobile) {
        ConfluenceMobile.contentEventAggregator.on("displayed", function () {
            if (!Confluence.getContextPath) {
                Confluence.getContextPath = AJS.contextPath;
            }
            HandyTasks.init();
        });
    } else {
        AJS.toInit(function() {
            HandyTasks.init();
        });
    }

})(AJS.$ || $, require('stiltsoft/handy-macros/analytics/client'));




