(function ($, AnalyticsClient) {

    if (!AJS || !AJS.toInit) {
        return;
    }

    AJS.toInit(function () {
        $('.wiki-content').find('h1,h2,h3,h4,h5,h6')
            .filter('[id]')
            .filter(function () {
                return $(this).find('div').length === 0;
            })
            .each(function () {
                var header = $(this);
                var span = $('<span class="handy-header aui-icon aui-icon-small aui-iconfont-link" title="' +
                    AJS.I18n.getText('handy.header.title') + '"></span>');
                header.prepend(span);
                span.click(function () {
                    var urlHolder = $('<span/>').text(AJS.params.baseUrl + "/pages/viewpage.action?pageId=" + getContentId() + '#' + header.attr('id'));
                    $('body').append(urlHolder);
                    var selection = window.getSelection();
                    var range = document.createRange();
                    range.setStartBefore(urlHolder[0]);
                    range.setEndAfter(urlHolder[0]);
                    selection.removeAllRanges();
                    selection.addRange(range);
                    document.execCommand('copy');
                    selection.removeAllRanges();
                    urlHolder.remove();
                    AnalyticsClient.sendFeatureUsedEvent('Handy Heading');
                    if (span.hasClass('aui-iconfont-link')) {
                        span.removeClass('aui-iconfont-link').addClass('aui-iconfont-approve');
                        span.animate({opacity: 0}, {
                            complete: function () {
                                span.addClass('aui-iconfont-link').removeClass('aui-iconfont-approve').css('opacity', '');
                            }, duration: 1500
                        });
                    }
                    return false;
                });
            });

        function getContentId() {
            return AJS.params.contentId || AJS.Meta.get("content-id") || AJS.params.pageId || AJS.Meta.get("page-id");
        }
    });

})(AJS.$ || $, require('stiltsoft/handy-macros/analytics/client'));




