(function ($, AnalyticsClient) {

    if (!AJS || !AJS.toInit) {
        return;
    }

    window.HandyDiff = {

        acknBtn: null,
        viewBtn: null,
        pageVersion: null,
        currentPageVersion: null,
        contentId: null,

        init: function () {
            const self = this;
            self.acknBtn = $('#handy-diff-acknowledge');
            self.viewBtn = $('#handy-diff-view');
            self.currentPageVersion = $('meta[name="page-version"]').attr('content');
            self.contentId = AJS.params.contentId || AJS.Meta.get('content-id') || AJS.params.pageId || AJS.Meta.get('page-id');
            if (self.acknBtn.length) {
                self.initAcknowledge();
            }
            if (self.viewBtn.length) {
                self.initView();
            }
        },

        initAcknowledge: function () {
            const self = this;

            $(document.body).append($(Handy.Templates.Diff.acknowledgeDialog()));

            self.acknBtn.attr('data-aui-trigger', '');
            self.acknBtn.attr('aria-controls', 'handy-acknowledge-changes');

            self.acknBtn.prepend('<span class="aui-icon aui-icon-small aui-iconfont-success"></span>');
            self.acknBtn.on('click', function () {
                $.ajax({
                    contentType: 'application/x-www-form-urlencoded; charset=utf-8',
                    type: 'PUT',
                    cache: false,
                    url: Confluence.getContextPath() + '/rest/handy-macros/2.0/diff',
                    data: {
                        contentId: self.contentId,
                        version: self.currentPageVersion,
                    },
                    dataType: 'json',
                    success: function () {
                        AnalyticsClient.sendFeatureUsedEvent('Handy Page Diff');
                        self.hideButtons();
                        if (opener) {
                            opener.HandyDiff.hideButtons();
                        }
                    },
                });
                return false;
            });

            const acknowledgeDialog = document.getElementById('handy-acknowledge-changes');

            acknowledgeDialog.addEventListener('aui-hide', function (e) {
                self.viewBtn.removeClass('handy-diff-hl');
                self.acknBtn.removeClass('active');
            });

            self.acknBtn.on('mouseenter', function () {
                self.viewBtn.addClass('handy-diff-hl');
                self.acknBtn.addClass('active');
            }).on('mouseleave', function () {
                if (!self.acknBtn.is('.active')) {
                    self.viewBtn.removeClass('handy-diff-hl');
                }
            });
        },

        initView: function () {
            const self = this;

            $(document.body).append($(Handy.Templates.Diff.viewDialog()));

            self.viewBtn.html('<span class="aui-icon aui-icon-small aui-iconfont-pages-large"></span>');
            self.viewBtn.parent().css('padding-left', 0);
            const newCount = $('<span class="diff-count"></span>');
            self.viewBtn.append(newCount);

            $.ajax({
                contentType: 'application/x-www-form-urlencoded; charset=utf-8',
                type: 'GET',
                cache: false,
                url: Confluence.getContextPath() + '/rest/handy-macros/2.0/diff/version',
                data: {
                    contentId: self.contentId,
                },
                dataType: 'json',
                success: function (version) {
                    self.pageVersion = version;
                    const diff = self.currentPageVersion - self.pageVersion;
                    const diffStr = diff > 9 ? '9+' : diff;
                    newCount.text(diffStr);
                    let contributors = null;

                    self.viewBtn.attr('data-aui-trigger', '');
                    self.viewBtn.attr('aria-controls', 'handy-view-changes');

                    const viewDialog = document.getElementById('handy-view-changes');
                    const contentDiv = viewDialog.querySelector('.aui-inline-dialog-contents');

                    viewDialog.addEventListener('aui-show', function (e) {
                        const show = function () {
                            $(contentDiv).html(Handy.Templates.Diff.viewDialogContent({
                                users: contributors,
                                changes: diff,
                            }));
                        };
                        if (contributors) {
                            show();

                        } else {
                            $.ajax({
                                contentType: 'application/x-www-form-urlencoded; charset=utf-8',
                                type: 'GET',
                                cache: false,
                                url: Confluence.getContextPath() + '/rest/handy-macros/2.0/diff/contributors',
                                data: {
                                    contentId: self.contentId,
                                    version: self.pageVersion,
                                },
                                dataType: 'json',
                                success: function (modifiers) {
                                    contributors = modifiers;
                                    show();
                                },
                            });
                        }
                    });

                    viewDialog.addEventListener('aui-hide', function (e) {
                        self.acknBtn.removeClass('handy-diff-hl');
                        self.viewBtn.removeClass('active');
                    });
                },
            });

            self.viewBtn.on('mouseenter', function () {
                self.acknBtn.addClass('handy-diff-hl');
                self.viewBtn.addClass('active');
            }).on('mouseleave', function () {
                if (!self.viewBtn.is('.active')) {
                    self.acknBtn.removeClass('handy-diff-hl');
                }
            }).on('click', function () {
                self.viewBtn.trigger('blur');
                window.open(Confluence.getContextPath() + '/pages/diffpagesbyversion.action?pageId=' + self.contentId +
                    '&selectedPageVersions=' + self.currentPageVersion + '&selectedPageVersions=' + self.pageVersion +
                    '&handyDiff=' + self.contentId, '_blank').focus();
            });
        },

        hideButtons: function () {
            const self = this;

            self.viewBtn.parent().fadeOut();
            self.acknBtn.parent().fadeOut();
        },
    };

    AJS.toInit(function () {
        HandyDiff.init();
    });

})(AJS.$ || $, require('stiltsoft/handy-macros/analytics/client'));
