(function($,  AnalyticsClient) {

    if (!AJS || !AJS.toInit) {
        return;
    }
    var timeoutDatePicker = null;

    window.HandyDate = {

        datetimeElementsSelector:
            'span[hd-id] time:not(.handy-date-time), ' +
            '.metadata-summary-macro time:not(.handy-date-time), ' +
            'time[data-colname]:not(.handy-date-time), ' +
            '.inline-task-list time:not(.handy-date-time), ' +
            'time.hr-date:not(.handy-date-time)',

        init: function() {
            var self = this;
            
            if (timeoutDatePicker) {
                clearTimeout(timeoutDatePicker);
                timeoutDatePicker = null;
            }
            if (!$.fn.datepicker) {
                timeoutDatePicker = setTimeout(function() {
                    HandyDate.init();
                }, 100);
                return;
            }

            var localeDateFormat = HandyDateUtils.getLocaleFormat();
            var locale = HandyDateUtils.getLocale();

            $(this.datetimeElementsSelector).each(function() {
                var time = $(this).addClass('handy-date-time');
                time.wrapInner("<span class='handy-date-value'></span>");
                var text = time.find('.handy-date-value');
                var input = $('<input type="text" class="handy-date-input">');
                input.val(HandyDateUtils.formatDate(HandyDateUtils.parseDate(time.attr("datetime"), "yy-mm-dd")));
                time.prepend(input);

                if (time.hasClass('hr-date')) {
                    input.attr('min', HandyDateUtils.formatDate(new Date()));
                }

                var isPPR = time.parents('.metadata-summary-macro').length > 0;
                if (isPPR) {
                    var cellIndex = time.parents('td')[0].cellIndex;
                    var tr = time.parents('tr').eq(0);
                    var colName = time.parents('table.metadata-summary-macro').find('th').eq(cellIndex).text().trim();
                    var contentId = tr.find('td[data-content-id]').attr('data-content-id');
                    var elementId = tr.find('time').index(time);

                    time.attr("data-colname", colName);
                    time.attr("data-contentId", contentId);
                    time.attr("data-elementId", elementId);
                } else {
                    isPPR = time.attr("data-colname");
                }

                input.one('click', function () {
                    HandyDateUtils.initInput(input);
                    input.trigger('click').focus();
                }).focus(function() {
                    input.blur();
                }).bind('keyup keydown keypress', function() {
                    return false;
                }).change(function(event) {
                    if (event.originalEvent) {
                        return;
                    }
                    AnalyticsClient.sendFeatureUsedEvent('Handy Date');
                    input.blur();
                    var value = input.val();
                    var textValue = value;
                    var date = $.datepicker.parseDate(localeDateFormat, value, HandyDateUtils.localisations[locale]);
                    value = $.datepicker.formatDate('yy-mm-dd', date);

                    var success = function () {
                        text.text(textValue).trigger('DOMCharacterDataModified');
                        HandyDateUtils.updateTimeStyle(time, date);
                    };

                    var taskList = time.parents('ul.inline-task-list');
                    if (time.hasClass('hr-date')) {

                        const macroId = time.attr('data-id');
                        const url = Confluence.getContextPath() + '/rest/handy-macros/2.0/reminder-macro/' + macroId + '/next-date';
                        $.ajax({
                            contentType: "application/x-www-form-urlencoded; charset=utf-8",
                            type: 'PUT',
                            url: url,
                            dataType: 'json',
                            data: {
                                contentId: time.attr('data-page-id'),
                                date: date.getTime()
                            },
                            success: function() {
                                date.setDate(date.getDate() - 1);
                                success();
                                time.parent().find('.reminder-macro-icon').removeClass('inactive');
                            },
                            error: self.showError
                        });
                    } else if (!isPPR && taskList.length === 0) {
                        var span = time.parent();
                        $.ajax({
                            contentType: "application/x-www-form-urlencoded; charset=utf-8",
                            type: 'PUT',
                            url: Confluence.getContextPath() + '/rest/handy-macros/2.0/date',
                            dataType: 'json',
                            data: {
                                contentId: span.attr('hd-pid'),
                                pageVersion: span.attr('hd-pv'),
                                elementId: span.attr('hd-id'),
                                date: value
                            },
                            success: success,
                            error: self.showError
                        });
                    } else if (taskList.length === 0) {
                        $.ajax({
                            contentType: "application/x-www-form-urlencoded; charset=utf-8",
                            type: 'PUT',
                            url: Confluence.getContextPath() + '/rest/handy-macros/2.0/date/ppr',
                            dataType: 'json',
                            data: {
                                contentId: time.attr("data-contentId"),
                                elementId: time.attr("data-elementId"),
                                date: value,
                                colName: time.attr("data-colname")
                            },
                            success: success,
                            error: self.showError
                        });
                    } else {
                        var li =  time.parents('li[data-inline-task-id]').eq(0);
                        var ul =  taskList.eq(0);
                        $.ajax({
                            contentType: "application/x-www-form-urlencoded; charset=utf-8",
                            type: 'PUT',
                            url: Confluence.getContextPath() + '/rest/handy-macros/2.0/date/task',
                            dataType: 'json',
                            data: {
                                contentId: ul.attr('data-inline-tasks-content-id'),
                                taskId: li.attr('data-inline-task-id'),
                                elementId: li.find('time').index(time),
                                date: value
                            },
                            success: success,
                            error: self.showError
                        });
                    }
                });
            });
        },

        showError: function(xhr) {
            var isReadOnly = xhr.responseText.indexOf('com.atlassian.confluence.api.service.exceptions.ReadOnlyException') !== -1;
            AJS.flag({
                type: 'error',
                body: isReadOnly ? AJS.I18n.getText("handy.macros.read-only-mode") : AJS.I18n.getText("handy.macros.config.error.body")
            });
        }
    };

    function init() {
        HandyDate.init();

        let timer;

        const onInsert = function (nodes) {
            $(nodes).filter(".tfac-tj")
                .find("time.handy-date-time")
                .removeClass("handy-date-time")
                .find("input")
                .remove();

            if (timer) clearTimeout(timer);

            timer = setTimeout(function () {
                console.log("Postponed init for Handy Date.");
                HandyDate.init();
            }, 1000);
        };

        var wikiContent = $('.wiki-content');
        if (wikiContent.length && wikiContent.find('.microBlogWrapper').length === 0) {
            if (window.MutationObserver) {
                var observer = new MutationObserver(function (events) {
                    events.some(function (event) {
                        if (event.addedNodes.length) {
                            return onInsert(event.addedNodes);
                        }
                    });
                });
                observer.observe(wikiContent[0], {childList: true, subtree: true});
            } else {
                wikiContent.bind('DOMNodeInserted', onInsert);
            }
        }
    }

    if (window.ConfluenceMobile) {
        ConfluenceMobile.contentEventAggregator.on("displayed", function () {
            if (!Confluence.getContextPath) {
                Confluence.getContextPath = AJS.contextPath;
            }
            init();
        });
    } else {
        AJS.toInit(function() {
            init();
        });
    }

})(AJS.$ || $, require('stiltsoft/handy-macros/analytics/client'));



