(function($) {

    var initCarousel = function (container) {
        var parent = container.parent();
        var rondell = container.data('rondell');
        var width = container.width(parent.width()).width();
        var h = 0, w = 0;

        container.find('span.companion-edit-button-placeholder').remove();

        var items = container.find('.rondell-item').width('').height('').removeClass('rondell-item');

        var images = container.find('img, iframe').each(function () {
            var element = $(this);
            if (!rondell) {
                while (!container.is(element.parent())) {
                    element.unwrap();
                }
            }

            h = Math.max(h, element.height());
            w = Math.max(w, element.width());

            if (!rondell) {
                element.click(function () {
                    var parent = element.parent();
                    if (!parent.hasClass("rondell-item-focused")) {
                        parent.click();
                        return false;
                    }
                });
            }
        });

        var delay = parseFloat(container.data('delay'));
        delay = isNaN(delay) ? 5 : delay;
        delay = delay * 1000;
        var ratio = parseFloat(container.data('ratio'));
        var controls = container.data('controls');
        var preset = container.data('preset').toLowerCase();
        var dh = 0;
        var rx = (width - w / ratio) / 2;
        var ry = h;
        var opacityMin = null;
        if (preset == "circle") {
            dh = 200;
            preset = "carousel";
        } else if (preset == "carousel") {
            ry = 0;
        } else if (preset == "pages") {
            width = w;
            ratio = 1;
        } else if (preset == "scroller") {
            ratio = 1;
            ry = 0;
            rx = null;
        } else if (preset == "slider") {
            ratio = 1;
            width = w;
            ry = null;
            rx = null;
            opacityMin = 0.03;
            container.width(w);
        } else if (preset == "gallery") {
            ry = null;
            rx = null;
        }

        container.height(h + dh);
        container.find('.rondell-control').css('top', '');
        items.addClass('rondell-item').width((w / ratio) + 'px').height((h / ratio) + 'px');
        items.filter('.rondell-item-focused').width(w + 'px').height(h + 'px');

        container.rondell({
            radius: {x: rx, y: ry},
            zIndex: 10,
            center: {left: width / 2, top: (h + dh) / 2},
            size: {width: width, height: h + dh},
            scaling: ratio,
            visibleItems: container.data('items'),
            lightbox: {enabled: false},
            autoRotation: {enabled: true, once: true, delay: delay},
            strings: {prev: "", next: ""},
            preset: preset,
            itemProperties: {
                size: {width: w / ratio, height: h / ratio},
                sizeFocused: {width: w, height: h}
            },
            controls: {
                enabled: controls != "None",
                margin: {
                    x: 0,
                    y: controls == "Top" ? 60 : controls == "Bottom" ? h + dh - 20 : (h + dh) / 2
                }
            },
            opacityMin: opacityMin,
            mousewheel: {
                enabled: true
            },
            captionsEnabled: false,
            randomStart: container.data('random')
        });

        container.data('items', container.data('rondell').visibleItems);

        container.css('visibility', '');

        if (preset != 'slider') parent.unbind('ba-resize').bind('ba-resize', function() { init(container) });

        var loadTimer = null;
        images.unbind('load').bind('load', function () {
            if (loadTimer) {
                clearTimeout(loadTimer);
                loadTimer = null;
            }

            loadTimer = setTimeout(function () {
                loadTimer = null;
                initCarousel(container);
            }, 300);
        });
    };

    var init = function() {
        var previewWait = function() {
            if ($(window).height() == 0) {
                setTimeout(previewWait, 200);
            } else {
                $('.handy-carousel').each(function() {
                    initCarousel($(this));
                });
            }
        };
        previewWait();
    };

    if (window.ConfluenceMobile) {
        ConfluenceMobile.contentEventAggregator.on("displayed", init);
    } else {
        AJS.toInit(init);
    }

})(AJS.$ || $);


