window.define(
    'stiltsoft/HandyMacrosPageEditorTablePasteMacroListener',
    ['ajs', 'tinymce', 'jquery'],
    (ajs, tinymce, $) => {

        const TABLE_PASTE_COMMANDS = [
            'mceTablePasteColAfter',
            'mceTablePasteColBefore',
            'mceTablePasteRowAfter',
            'mceTablePasteRowBefore',
        ];

        const listeners = new Map();
        let listenersMarkupSelector = '';

        const init = (macroName, onMacroPasteCallback) => {
            const listener = createListener(macroName, onMacroPasteCallback);
            listeners.set(macroName, listener);

            rebuildListenersMarkupSelector(listener.selector);
        };

        const listenTablePasteEvents = () => {
            let activeInsertion = false;

            bindActiveEditorOnBeforeCommand((editor, command) => {
                if (activeInsertion && 'change' === command) activeInsertion = false;
                if (TABLE_PASTE_COMMANDS.indexOf(command) === -1) return;

                editor.on('newcell', onNewCell);
                editor.once('change', () => editor.off('newcell', onNewCell));
            });
        };

        const bindActiveEditorOnBeforeCommand = (callback) => {
            $.aop.before({
                target: tinymce.activeEditor,
                method: 'execCommand',
            }, (command) => callback(tinymce.activeEditor, command[0]));
        };

        const onNewCell = (newCell) => onNodeAdded(newCell.node);

        const onNodeAdded = (node) => {
            if (!listeners.keys().next()) return;

            if (hasMacroAttributes(node)) {
                findAndCallListener(node);
            } else if (node.querySelectorAll) {
                node.querySelectorAll(listenersMarkupSelector).forEach(findAndCallListener);
            }
        };

        const findAndCallListener = (macroNode) => {
            const macroName = getMacroName(macroNode);
            if (!listeners.has(macroName)) return;

            listeners.get(macroName).callback(macroNode);
        };

        const rebuildListenersMarkupSelector = (newListenerSelector) => {
            if (listenersMarkupSelector.length === 0) {
                listenersMarkupSelector = newListenerSelector;
            } else {
                listenersMarkupSelector += `, ${newListenerSelector}`;
            }
        };

        const createListener = (macroName, callback) => ({
            selector: `[data-macro-name="${macroName}"]`,
            callback: callback,
        });

        const hasMacroAttributes = (node) => node.attributes && node.attributes['data-macro-name'];

        const getMacroName = (node) => node.attributes['data-macro-name'].value;

        ajs.bind("rte-ready", listenTablePasteEvents);

        return {init: init};
    });