window.define(
    'stiltsoft/HandyMacrosPageEditorPasteProcessor',
    [
        'ajs',
        'tinymce',
        'confluence-macro-browser/macro-parameter-serializer',
        'jquery',
        'stiltsoft/HandyMacrosPageEditorTablePasteMacroListener',
    ],
    (ajs, tinymce, macroParameterSerializer, $, TablePasteMacroListener) => {

        const init = (macroName, onMacroPaste) => {
            initEditorPasteListener(macroName, onMacroPaste);
            TablePasteMacroListener.init(macroName, (node) => macroPasteConsumer(node, onMacroPaste));
        };

        const initEditorPasteListener = (macroName, onMacroPaste) => {
            const onPaste = tinymce.activeEditor.plugins.confluencepaste || tinymce.activeEditor.plugins.aePaste;
            if (onPaste.onPreProcess) {
                onPaste.onPreProcess.listeners.push({
                    cb: (editor, event) => onPastePreProcess(editor, event, macroName, onMacroPaste),
                });
            } else {
                tinymce.activeEditor.on('PastePreProcess',
                    event => onPastePreProcess(tinymce.activeEditor, event, macroName, onMacroPaste));
            }
        }

        const onPastePreProcess = (editor, event, macroName, onMacroPaste) => {
            const shadowContent = $('<div/>').append(event.content);

            shadowContent.find(`img[data-macro-name="${macroName}"]`)
                .each((index, element) => macroPasteConsumer(element, onMacroPaste));

            event.content = shadowContent.html();
        };

        const macroPasteConsumer = (node, onMacroPaste) => {
            const $macro = $(node);
            const macroParams = macroParameterSerializer.deserialize($macro.data('macro-parameters'));
            const updatedMacroParams = onMacroPaste($macro, macroParams);
            $macro.attr('data-macro-parameters', macroParameterSerializer.serialize(updatedMacroParams));
        };

        return {init: init};
    });