(function ($, AnalyticsExtender) {

    const HandyTipEditor = {

        selector: 'a[href*="handytip-"]',

        init: function() {
            this.contents = $('#wysiwygTextarea_ifr').contents();
            this.bindInsert();
            this.bindPanel();
        },

        bindInsert: function() {
            const self = this;
            $('#macro-insert-list #insert-handy-tip').click(function() {
                AJS.Rte.getEditor().setDirty(true);
                const id = ("" + Math.random()).substring(2);
                if (self.insertHighlight(id)) {
                    console.log('Inserted');
                    self.sendAnalyticsInsertEvent('Handy Tip');

                    const macroRenderRequest = {
                        contentId: Confluence.Editor.getContentId(),
                        macro: {
                            name: 'handy-tip',
                            body: '',
                            params: {id: id}
                        }
                    };
                    tinymce.confluence.MacroUtils.insertMacro(macroRenderRequest);
                }
                $(document).click();
                AJS.Rte.getEditor().focus();
                return false;
            });
        },

        insertHighlight: function (id) {
            const self = this;
            const editor = AJS.Rte.getEditor();
            const selection = editor.selection;
            const html = selection.getContent({'format': 'html'});
            if(html && html.length > 0) {
                if (this.hasSelectionTips($(selection.getStart()), $(selection.getEnd()), html)) {
                    alert(AJS.I18n.getText('handy-tip.editor.selected.contains'));
                    return false;
                }

                const aLink = HandyTipMacro.link({id: id, html: html});
                tinymce.confluence.NodeUtils.replaceSelection(aLink);
                AJS.Rte.BookmarkManager.storeBookmark();
                
                return true;
            } else {
                alert(AJS.I18n.getText('handy-tip.editor.selected.nothing'));
                return false;
            }
        },

        hasSelectionTips: function(start, end, html) {
            return end.add(start).parents(this.selector).length || $('<div/>').append(html).find(this.selector).length;
        },

        bindPanel: function () {
            const self = this;

            AJS.bind("created.property-panel", function (e, data) {
                var link;
                if (data.type === 'image' && data.panel.find('.image-link-edit').length) {
                    link = $(data.anchor).parents('a');
                } else if (data.type === 'link') {
                    link = $(data.anchor);
                }

                if (link && link.length) {
                    const href = link.attr('href');
                    if (href.indexOf('handytip-') !== -1) {
                        const id = href.split('handytip-')[1];
                        const editBtn = data.panel.find('.link-property-panel-edit-button, .image-link-edit');

                        if (data.type === 'image') {
                            editBtn.before(HandyTipMacro.panelGoToBtn());
                            editBtn.removeClass('first');
                        }

                        const gotoBtn = data.panel.find('.link-property-panel-goto-button');

                        gotoBtn.removeClass('disabled').attr('aria-disabled', false).css('pointer-events', '');
                        gotoBtn.text(AJS.I18n.getText('handy-tip.editor.panel.goto'));
                        gotoBtn.click(function () {
                            const macro = self.contents.find('.wysiwyg-macro[data-macro-name="handy-tip"][data-macro-parameters*="id=' + id + '"]');
                            self.contents.find('html').animate({
                                scrollTop: macro.offset().top - 50
                            }, {
                                duration: 400,
                                complete: function () {
                                    AJS.log(macro);
                                    macro.trigger('click');
                                }
                            });
                            return false;
                        });

                        editBtn.unbind('click').click(function () {
                            const dialog = $(HandyTipMacro.dialog({id: id}));
                            const saveBtn = dialog.find('.handy-tip-link-save');
                            const cancelBtn = dialog.find('.handy-tip-link-cancel');
                            const input = dialog.find('#handy-tip-link-id');

                            input.bind('input', function () {
                                saveBtn.prop('disabled', !input.val().trim());
                            });

                            saveBtn.click(function () {
                                link.attr('href', '#handytip-' + input.val().trim());
                                AJS.dialog2(dialog).hide();
                            });

                            cancelBtn.click(function () {
                                AJS.dialog2(dialog).hide();
                            });

                            AJS.dialog2(dialog).show();

                            return false;
                        });
                    }
                }
            });

            AJS.Confluence.PropertyPanel.Macro.registerButtonHandler("goto-handy-tip-link", function(e, macroNode) {
                const macro = $(macroNode);
                const id = Confluence.MacroParameterSerializer.deserialize(macro.attr('data-macro-parameters')).id;
                const link = self.contents.find('a[href*="handytip-' + id + '"]');
                self.contents.find('html').animate({
                    scrollTop: link.offset().top - 100
                }, {
                    duration: 400,
                    complete: function () {
                        tinymce.activeEditor.selection.select(link[0]);
                    }
                });
            });
        }
    };

    AnalyticsExtender.extendObject(HandyTipEditor);

    AJS.bind("init.rte", function() {
        HandyTipEditor.init();
    });

})(AJS.$,require('stiltsoft/handy-macros/analytics/client/extender'));



