(function ($) {

    window.HandyButtonEditor = {

        init: function() {
            var self = this;
            self.bindInsert();
        },

        bindInsert: function() {
            var self = this;

            AJS.bind("created.property-panel", function (e, data) {
                if (data.type == 'macro') {
                    var macro = $(data.anchor);
                    if (macro.attr('data-macro-name') == 'button-handy' && data.panel.find('.button-handy-panel-form').length == 0) {
                        self.initPanel(data.panel, macro);

                        AJS.bind("destroyed.property-panel.handy", function() {
                            AJS.unbind("destroyed.property-panel.handy");
                            $('#handy-button-colors').hide();
                        });
                    }
                }
            });
        },

        initPanel: function(panel, macro) {
            var self = this;

            $('#handy-button-colors').remove();

            var panelButtons = panel.find('.panel-buttons');
            panelButtons.append($(HandyButtonMacro.buttonEditor()));
            var nameInput = $('#handy-button-name');
            var urlInput = $('#handy-button-url');

            var arrow = panel.find('.property-panel-bottom-arrow');

            arrow.css('top', (parseInt(arrow.css('top')) + 35) + 'px');

            nameInput.parent().wrap('<form class="aui button-handy-panel-form"></form>');

            var params = Confluence.MacroParameterSerializer.deserialize(macro.attr('data-macro-parameters'));
            const $dropdownColorButton = panelButtons.find('#handy-button-dd');
            const $dropdownColorItem = panelButtons.find('#handy-button-colors .handy-button-color-item');

            $dropdownColorButton.html($dropdownColorItem.filter('[data-color="' + params['color'] + '"]').clone());
            nameInput.val(params['name']);
            urlInput.val(params['link']);

            var diff = $(window).width() - parseInt(panel.css('left')) - panel.width() - 25;
            if (diff < 0) {
                panel.css('left', parseInt(panel.css('left')) + diff);
                var arrow = panel.find('.aui-tip-parent');
                arrow.css('left', parseInt(arrow.css('left')) - diff);
            }

            $dropdownColorItem.on('click', function(event) {
                const $colorItem = $(event.currentTarget);
                const $clonedColorItem = $colorItem.clone();
                $dropdownColorButton.html($clonedColorItem);
                params['color'] = $colorItem.data('color');
                self.saveMacro(params, macro);

                $dropdownColorButton.trigger('click');
            });

            var timer = null;

            nameInput.bind('keyup', function() {
                if (timer) {
                    clearTimeout(timer);
                    timer = null;
                }
                timer = setTimeout(function() {
                    self.input = nameInput;
                    var val = nameInput.val().trim();
                    if (val && val != params['name']) {
                        params['name'] = val;
                        self.saveMacro(params, macro);
                    }
                }, 300);
            });

            urlInput.bind('change selected.autocomplete-content', function() {
                if (timer) {
                    clearTimeout(timer);
                    timer = null;
                }
                timer = setTimeout(function() {
                    self.input = urlInput;
                    var val = urlInput.val().trim();
                    if (val && val != params['link']) {
                        params['link'] = val;
                        self.saveMacro(params, macro);
                    }
                }, 300);
            });

            nameInput.add(urlInput).bind('keypress', function(e) {
                if (e.keyCode == 13) {
                    return false;
                }
            });

            Confluence.Binder.autocompleteConfluenceContent();
            self.bindAutocompleteUrlInput(urlInput);
        },

        saveMacro: function(params, macro) {
            $.ajax({
                type: 'POST',
                url: AJS.contextPath() + "/rest/tinymce/1/macro/placeholder",
                dataType: 'text',
                contentType: "application/json; charset=utf-8",
                data: $.toJSON({
                    contentId: AJS.Meta.get('content-id') || "0",
                    macro: {
                        name: 'button-handy',
                        params: params
                    }
                }),
                success: function(img) {
                    var $img = $(img);
                    macro.attr('src', $img.attr('src'));
                    macro.attr('height', $img.attr('height'));
                    macro.attr('width', $img.attr('width'));
                    macro.attr('data-macro-parameters', $img.attr('data-macro-parameters'));
                }
            });
        },

        bindAutocompleteUrlInput: function (input) {
            var container = input.parent();
            input.bind('keyup', function () {
                var value = input.val();
                container.toggleClass('hide-autocomplete', value.indexOf('http://') === 0 || value.indexOf('https://') === 0 || value.indexOf('#') !== -1);
            });

            input.bind('quick-search-loading-stop', function () {
                container.find('.aui-dropdown').width(input.outerWidth() - 2 + 'px');
            });
        }
    };

    AJS.bind("init.rte", function() {
        HandyButtonEditor.init();
    });

})(jQuery);


