(function ($) {
    window.HandyDateUtils = {

        _userLocale: void 0,
        _userLocaleFormat: void 0,

        getLocaleFormat: function () {
            if (!this._userLocaleFormat) {
                this._userLocaleFormat = this._getUserLocaleFormat();
            }
            return this._userLocaleFormat;
        },

        _getUserLocaleFormat: function () {
            let localeDateFormat = (AJS.Meta.get("user-date-pattern") || window.parent.AJS.Meta.get("user-date-pattern"));
            if (localeDateFormat) {
                localeDateFormat = localeDateFormat.replace("yyyy", "yy");
                if (localeDateFormat.indexOf("MMM") !== -1) {
                    localeDateFormat = localeDateFormat.replace("MMM", "M");
                } else if (localeDateFormat.indexOf("MM") !== -1) {
                    localeDateFormat = localeDateFormat.replace("MM", "mm");
                } else if (localeDateFormat.indexOf("M") !== -1) {
                    localeDateFormat = localeDateFormat.replace("M", "m");
                }
                return localeDateFormat;
            }
            return 'yy-mm-dd';
        },

        getLocale: function () {
            if (!this._userLocale) {
                this._userLocale = this._getUserLocale();
            }
            return this._userLocale;
        },

        _getUserLocale: function () {
            return AJS.Meta.get("user-locale") || window.parent.AJS.Meta.get("user-locale");
        },

        initInput: function (input) {
            var localeDateFormat = HandyDateUtils.getLocaleFormat();
            var locale = HandyDateUtils.getLocale();

            if (!AJS.DatePicker.prototype.localisations) {  //Scroll Viewport
                AJS.DatePicker.prototype.localisations = [];
            }
            if (AJS.DatePicker.prototype.localisations.monthNames) {
                AJS.DatePicker.prototype.localisations = HandyDateUtils.localisations[locale];
            } else {
                AJS.DatePicker.prototype.localisations[locale] = HandyDateUtils.localisations[locale];
            }
            input.datePicker({overrideBrowserDefault: true, dateFormat: localeDateFormat, languageCode: locale});
        },

        formatDate: function(date) {
            return $.datepicker.formatDate(HandyDateUtils.getLocaleFormat(), date, HandyDateUtils.localisations[HandyDateUtils.getLocale()]);
        },

        parseDate: function(dateString, format) {
            try {
                return $.datepicker.parseDate(format || HandyDateUtils.getLocaleFormat(), dateString, HandyDateUtils.localisations[HandyDateUtils.getLocale()]);
            } catch (e) {
                return null;
            }
        },

        updateTimeStyle: function (time, date) {
            time.removeClass('date-upcoming date-past');
            if (time.tooltip) {
                try {
                    time.tooltip('destroy');
                } catch (e) {
                    console.error(e);
                }
            }
            var today = new Date().setHours(0,0,0,0);
            if (date < today) {
                time.addClass('date-past');
                if (time.tooltip && time.parents('li.checked').length === 0) {
                    time.tooltip({
                        title: function () {
                            return AJS.I18n.getText("inline-tasks.date.overdue")
                        },
                        live: true
                    });
                }
            } else if (date - today <= 604800000) {
                time.addClass('date-upcoming');
                if (time.tooltip && time.parents('li.checked').length === 0) {
                    time.tooltip({
                        title: function () {
                            return AJS.I18n.getText("inline-tasks.date.duesoon");
                        },
                        live: true
                    });
                }
            }
        },

        localisations: {
            "ar_SA": {
                monthNames: ["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو",
                    "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"],
                monthNamesShort: ["1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"],
                dayNames: ["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"],
                dayNamesShort: ["أحد", "اثنين", "ثلاثاء", "أربعاء", "خميس", "جمعة", "سبت"],
                dayNamesMin: ["ح", "ن", "ث", "ر", "خ", "ج", "س"],
                firstDay: 0,
                isRTL: true,
                showMonthAfterYear: false,
                yearSuffix: ""
            },
            "az_AZ": {
                monthNames: ["Yanvar", "Fevral", "Mart", "Aprel", "May", "İyun",
                    "İyul", "Avqust", "Sentyabr", "Oktyabr", "Noyabr", "Dekabr"],
                monthNamesShort: ["Yan", "Fev", "Mar", "Apr", "May", "İyun",
                    "İyul", "Avq", "Sen", "Okt", "Noy", "Dek"],
                dayNames: ["Bazar", "Bazar ertəsi", "Çərşənbə axşamı", "Çərşənbə", "Cümə axşamı", "Cümə", "Şənbə"],
                dayNamesShort: ["B", "Be", "Ça", "Ç", "Ca", "C", "Ş"],
                dayNamesMin: ["B", "B", "Ç", "С", "Ç", "C", "Ş"],
                firstDay: 1,
                isRTL: false,
                showMonthAfterYear: false,
                yearSuffix: ""
            },
            "be_BY": {
                monthNames: ["Студзень", "Люты", "Сакавік", "Красавік", "Травень", "Чэрвень", "Ліпень", "Жнівень", "Верасень", "Кастрычнік", "Лістапад", "Сьнежань"],
                monthNamesShort: ["Сту", "Лют", "Сак", "Кра", "Тра", "Чэр", "Ліп", "Жні", "Вер", "Кас", "Ліс", "Сьн"],
                dayNames: ["нядзеля", "панядзелак", "аўторак", "серада", "чацьвер", "пятніца", "субота"],
                dayNamesMin: ["Нд", "Пн", "Аў", "Ср", "Чц", "Пт", "Сб"],
                firstDay: 1,
                isRTL: false,
                showMonthAfterYear: false,
                yearSuffix: ""
            },
            "bg_BG": {
                monthNames: ["Януари", "Февруари", "Март", "Април", "Май", "Юни",
                    "Юли", "Август", "Септември", "Октомври", "Ноември", "Декември"],
                monthNamesShort: ["Яну", "Фев", "Мар", "Апр", "Май", "Юни",
                    "Юли", "Авг", "Сеп", "Окт", "Нов", "Дек"],
                dayNames: ["Неделя", "Понеделник", "Вторник", "Сряда", "Четвъртък", "Петък", "Събота"],
                dayNamesShort: ["Нед", "Пон", "Вто", "Сря", "Чет", "Пет", "Съб"],
                dayNamesMin: ["Не", "По", "Вт", "Ср", "Че", "Пе", "Съ"],
                firstDay: 1,
                isRTL: false,
                showMonthAfterYear: false,
                yearSuffix: ""
            },
            "bs_BA": {
                monthNames: ["Januar", "Februar", "Mart", "April", "Maj", "Juni",
                    "Juli", "August", "Septembar", "Oktobar", "Novembar", "Decembar"],
                monthNamesShort: ["Jan", "Feb", "Mar", "Apr", "Maj", "Jun",
                    "Jul", "Aug", "Sep", "Okt", "Nov", "Dec"],
                dayNames: ["Nedelja", "Ponedeljak", "Utorak", "Srijeda", "Četvrtak", "Petak", "Subota"],
                dayNamesShort: ["Ned", "Pon", "Uto", "Sri", "Čet", "Pet", "Sub"],
                dayNamesMin: ["Ne", "Po", "Ut", "Sr", "Če", "Pe", "Su"],
                firstDay: 1,
                isRTL: false,
                showMonthAfterYear: false,
                yearSuffix: ""
            },
            "ca_ES": {
                monthNames: ["gener", "febrer", "març", "abril", "maig", "juny",
                    "juliol", "agost", "setembre", "octubre", "novembre", "desembre"],
                monthNamesShort: ["gen", "feb", "març", "abr", "maig", "juny",
                    "jul", "ag", "set", "oct", "nov", "des"],
                dayNames: ["diumenge", "dilluns", "dimarts", "dimecres", "dijous", "divendres", "dissabte"],
                dayNamesShort: ["dg", "dl", "dt", "dc", "dj", "dv", "ds"],
                dayNamesMin: ["dg", "dl", "dt", "dc", "dj", "dv", "ds"],
                firstDay: 1,
                isRTL: false,
                showMonthAfterYear: false,
                yearSuffix: ""
            },
            "cs_CZ": {
                monthNames: ["leden", "únor", "březen", "duben", "květen", "červen",
                    "červenec", "srpen", "září", "říjen", "listopad", "prosinec"],
                monthNamesShort: ["led", "úno", "bře", "dub", "kvě", "čer",
                    "čvc", "srp", "zář", "říj", "lis", "pro"],
                dayNames: ["neděle", "pondělí", "úterý", "středa", "čtvrtek", "pátek", "sobota"],
                dayNamesShort: ["ne", "po", "út", "st", "čt", "pá", "so"],
                dayNamesMin: ["ne", "po", "út", "st", "čt", "pá", "so"],
                firstDay: 1,
                isRTL: false,
                showMonthAfterYear: false,
                yearSuffix: ""
            },
            "da_DK": {
                monthNames: ["Januar", "Februar", "Marts", "April", "Maj", "Juni",
                    "Juli", "August", "September", "Oktober", "November", "December"],
                monthNamesShort: ["Jan", "Feb", "Mar", "Apr", "Maj", "Jun",
                    "Jul", "Aug", "Sep", "Okt", "Nov", "Dec"],
                dayNames: ["Søndag", "Mandag", "Tirsdag", "Onsdag", "Torsdag", "Fredag", "Lørdag"],
                dayNamesShort: ["Søn", "Man", "Tir", "Ons", "Tor", "Fre", "Lør"],
                dayNamesMin: ["Sø", "Ma", "Ti", "On", "To", "Fr", "Lø"],
                firstDay: 1,
                isRTL: false,
                showMonthAfterYear: false,
                yearSuffix: ""
            },
            "de_CH": {
                monthNames: ["Januar", "Februar", "März", "April", "Mai", "Juni",
                    "Juli", "August", "September", "Oktober", "November", "Dezember"],
                monthNamesShort: ["Jan", "Feb", "Mär", "Apr", "Mai", "Jun",
                    "Jul", "Aug", "Sep", "Okt", "Nov", "Dez"],
                dayNames: ["Sonntag", "Montag", "Dienstag", "Mittwoch", "Donnerstag", "Freitag", "Samstag"],
                dayNamesShort: ["So", "Mo", "Di", "Mi", "Do", "Fr", "Sa"],
                dayNamesMin: ["So", "Mo", "Di", "Mi", "Do", "Fr", "Sa"],
                firstDay: 1,
                isRTL: false,
                showMonthAfterYear: false,
                yearSuffix: ""
            },
            "de_DE": {
                monthNames: ["Januar", "Februar", "März", "April", "Mai", "Juni",
                    "Juli", "August", "September", "Oktober", "November", "Dezember"],
                monthNamesShort: ["Jan", "Feb", "Mär", "Apr", "Mai", "Jun",
                    "Jul", "Aug", "Sep", "Okt", "Nov", "Dez"],
                dayNames: ["Sonntag", "Montag", "Dienstag", "Mittwoch", "Donnerstag", "Freitag", "Samstag"],
                dayNamesShort: ["So", "Mo", "Di", "Mi", "Do", "Fr", "Sa"],
                dayNamesMin: ["So", "Mo", "Di", "Mi", "Do", "Fr", "Sa"],
                firstDay: 1,
                isRTL: false,
                showMonthAfterYear: false,
                yearSuffix: ""
            },
            "el_GR": {
                monthNames: ["Ιανουάριος", "Φεβρουάριος", "Μάρτιος", "Απρίλιος", "Μάιος", "Ιούνιος",
                    "Ιούλιος", "Αύγουστος", "Σεπτέμβριος", "Οκτώβριος", "Νοέμβριος", "Δεκέμβριος"],
                monthNamesShort: ["Ιαν", "Φεβ", "Μαρ", "Απρ", "Μαι", "Ιουν",
                    "Ιουλ", "Αυγ", "Σεπ", "Οκτ", "Νοε", "Δεκ"],
                dayNames: ["Κυριακή", "Δευτέρα", "Τρίτη", "Τετάρτη", "Πέμπτη", "Παρασκευή", "Σάββατο"],
                dayNamesShort: ["Κυρ", "Δευ", "Τρι", "Τετ", "Πεμ", "Παρ", "Σαβ"],
                dayNamesMin: ["Κυ", "Δε", "Τρ", "Τε", "Πε", "Πα", "Σα"],
                firstDay: 1,
                isRTL: false,
                showMonthAfterYear: false,
                yearSuffix: ""
            },
            "en_GB": {
                "dayNames": ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"],
                "dayNamesMin": ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],
                "firstDay": 0,
                "isRTL": false,
                "monthNames": ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"],
                monthNamesShort: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"],
                "showMonthAfterYear": false,
                "yearSuffix": ""
            },
            "en_US": {
                "dayNames": ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"],
                "dayNamesMin": ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],
                "firstDay": 0,
                "isRTL": false,
                "monthNames": ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"],
                monthNamesShort: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"],
                "showMonthAfterYear": false,
                "yearSuffix": ""
            },
            "es_AR": {
                monthNames: ["enero", "febrero", "marzo", "abril", "mayo", "junio",
                    "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"],
                monthNamesShort: ["ene", "feb", "mar", "abr", "may", "jun",
                    "jul", "ago", "sep", "oct", "nov", "dic"],
                dayNames: ["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"],
                dayNamesShort: ["dom", "lun", "mar", "mié", "jue", "vie", "sáb"],
                dayNamesMin: ["D", "L", "M", "X", "J", "V", "S"],
                firstDay: 1,
                isRTL: false,
                showMonthAfterYear: false,
                yearSuffix: ""
            },
            "es_MX": {
                monthNames: ["enero", "febrero", "marzo", "abril", "mayo", "junio",
                    "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"],
                monthNamesShort: ["ene", "feb", "mar", "abr", "may", "jun",
                    "jul", "ago", "sep", "oct", "nov", "dic"],
                dayNames: ["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"],
                dayNamesShort: ["dom", "lun", "mar", "mié", "jue", "vie", "sáb"],
                dayNamesMin: ["D", "L", "M", "X", "J", "V", "S"],
                firstDay: 1,
                isRTL: false,
                showMonthAfterYear: false,
                yearSuffix: ""
            },
            "es_VE": {
                monthNames: ["enero", "febrero", "marzo", "abril", "mayo", "junio",
                    "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"],
                monthNamesShort: ["ene", "feb", "mar", "abr", "may", "jun",
                    "jul", "ago", "sep", "oct", "nov", "dic"],
                dayNames: ["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"],
                dayNamesShort: ["dom", "lun", "mar", "mié", "jue", "vie", "sáb"],
                dayNamesMin: ["D", "L", "M", "X", "J", "V", "S"],
                firstDay: 1,
                isRTL: false,
                showMonthAfterYear: false,
                yearSuffix: ""
            },
            "es_ES": {
                monthNames: ["enero", "febrero", "marzo", "abril", "mayo", "junio",
                    "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"],
                monthNamesShort: ["ene", "feb", "mar", "abr", "may", "jun",
                    "jul", "ago", "sep", "oct", "nov", "dic"],
                dayNames: ["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"],
                dayNamesShort: ["dom", "lun", "mar", "mié", "jue", "vie", "sáb"],
                dayNamesMin: ["D", "L", "M", "X", "J", "V", "S"],
                firstDay: 1,
                isRTL: false,
                showMonthAfterYear: false,
                yearSuffix: ""
            },
            "et_EE": {
                monthNames: ["Jaanuar", "Veebruar", "Märts", "Aprill", "Mai", "Juuni",
                    "Juuli", "August", "September", "Oktoober", "November", "Detsember"],
                monthNamesShort: ["Jaan", "Veebr", "Märts", "Apr", "Mai", "Juuni",
                    "Juuli", "Aug", "Sept", "Okt", "Nov", "Dets"],
                dayNames: ["Pühapäev", "Esmaspäev", "Teisipäev", "Kolmapäev", "Neljapäev", "Reede", "Laupäev"],
                dayNamesShort: ["Pühap", "Esmasp", "Teisip", "Kolmap", "Neljap", "Reede", "Laup"],
                dayNamesMin: ["P", "E", "T", "K", "N", "R", "L"],
                firstDay: 1,
                isRTL: false,
                showMonthAfterYear: false,
                yearSuffix: ""
            },
            "eu_ES": {
                monthNames: ["urtarrila", "otsaila", "martxoa", "apirila", "maiatza", "ekaina",
                    "uztaila", "abuztua", "iraila", "urria", "azaroa", "abendua"],
                monthNamesShort: ["urt.", "ots.", "mar.", "api.", "mai.", "eka.",
                    "uzt.", "abu.", "ira.", "urr.", "aza.", "abe."],
                dayNames: ["igandea", "astelehena", "asteartea", "asteazkena", "osteguna", "ostirala", "larunbata"],
                dayNamesShort: ["ig.", "al.", "ar.", "az.", "og.", "ol.", "lr."],
                dayNamesMin: ["ig", "al", "ar", "az", "og", "ol", "lr"],
                firstDay: 1,
                isRTL: false,
                showMonthAfterYear: false,
                yearSuffix: ""
            },
            "fa_IR": {
                monthNames: ["ژانویه", "فوریه", "مارس", "آوریل", "مه", "ژوئن", "ژوئیه", "اوت", "سپتامبر", "اکتبر", "نوامبر", "دسامبر"],
                monthNamesShort: ["1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"],
                dayNames: ["يکشنبه", "دوشنبه", "سه‌شنبه", "چهارشنبه", "پنجشنبه", "جمعه", "شنبه"],
                dayNamesShort: ["ی", "د", "س", "چ", "پ", "ج", "ش"],
                dayNamesMin: ["ی", "د", "س", "چ", "پ", "ج", "ش"],
                firstDay: 6,
                isRTL: true,
                showMonthAfterYear: false,
                yearSuffix: ""
            },
            "fi_FI": {
                monthNames: ["Tammikuu", "Helmikuu", "Maaliskuu", "Huhtikuu", "Toukokuu", "Kesäkuu",
                    "Heinäkuu", "Elokuu", "Syyskuu", "Lokakuu", "Marraskuu", "Joulukuu"],
                monthNamesShort: ["Tammi", "Helmi", "Maalis", "Huhti", "Touko", "Kesä",
                    "Heinä", "Elo", "Syys", "Loka", "Marras", "Joulu"],
                dayNamesShort: ["Su", "Ma", "Ti", "Ke", "To", "Pe", "La"],
                dayNames: ["Sunnuntai", "Maanantai", "Tiistai", "Keskiviikko", "Torstai", "Perjantai", "Lauantai"],
                dayNamesMin: ["Su", "Ma", "Ti", "Ke", "To", "Pe", "La"],
                firstDay: 1,
                isRTL: false,
                showMonthAfterYear: false,
                yearSuffix: ""
            },
            "fr_BE": {
                monthNames: ["janvier", "février", "mars", "avril", "mai", "juin",
                    "juillet", "août", "septembre", "octobre", "novembre", "décembre"],
                monthNamesShort: ["janv.", "févr.", "mars", "avr.", "mai", "juin",
                    "juil.", "août", "sept.", "oct.", "nov.", "déc."],
                dayNames: ["dimanche", "lundi", "mardi", "mercredi", "jeudi", "vendredi", "samedi"],
                dayNamesShort: ["dim.", "lun.", "mar.", "mer.", "jeu.", "ven.", "sam."],
                dayNamesMin: ["D", "L", "M", "M", "J", "V", "S"],
                firstDay: 1,
                isRTL: false,
                showMonthAfterYear: false,
                yearSuffix: ""
            },
            "fr_CA": {
                monthNames: ["janvier", "février", "mars", "avril", "mai", "juin",
                    "juillet", "août", "septembre", "octobre", "novembre", "décembre"],
                monthNamesShort: ["janv.", "févr.", "mars", "avril", "mai", "juin",
                    "juil.", "août", "sept.", "oct.", "nov.", "déc."],
                dayNames: ["dimanche", "lundi", "mardi", "mercredi", "jeudi", "vendredi", "samedi"],
                dayNamesShort: ["dim.", "lun.", "mar.", "mer.", "jeu.", "ven.", "sam."],
                dayNamesMin: ["D", "L", "M", "M", "J", "V", "S"],
                firstDay: 0,
                isRTL: false,
                showMonthAfterYear: false,
                yearSuffix: ""
            },
            "fr_FR": {
                monthNames: ["janvier", "février", "mars", "avril", "mai", "juin",
                    "juillet", "août", "septembre", "octobre", "novembre", "décembre"],
                monthNamesShort: ["janv.", "févr.", "mars", "avr.", "mai", "juin",
                    "juil.", "août", "sept.", "oct.", "nov.", "déc."],
                dayNames: ["dimanche", "lundi", "mardi", "mercredi", "jeudi", "vendredi", "samedi"],
                dayNamesShort: ["dim.", "lun.", "mar.", "mer.", "jeu.", "ven.", "sam."],
                dayNamesMin: ["D", "L", "M", "M", "J", "V", "S"],
                firstDay: 1,
                isRTL: false,
                showMonthAfterYear: false,
                yearSuffix: ""
            },
            "hi_IN": {
                monthNames: ["जनवरी ", "फरवरी", "मार्च", "अप्रेल", "मई", "जून", "जूलाई", "अगस्त ", "सितम्बर", "अक्टूबर", "नवम्बर", "दिसम्बर"],
                monthNamesShort: ["जन", "फर", "मार्च", "अप्रेल", "मई", "जून", "जूलाई", "अग", "सित", "अक्ट", "नव", "दि"],
                dayNames: ["रविवार", "सोमवार", "मंगलवार", "बुधवार", "गुरुवार", "शुक्रवार", "शनिवार"],
                dayNamesMin: ["रवि", "सोम", "मंगल", "बुध", "गुरु", "शुक्र", "शनि"],
                firstDay: 1,
                isRTL: false,
                showMonthAfterYear: false,
                yearSuffix: ""
            },
            "hu_HU": {
                monthNames: ["Január", "Február", "Március", "Április", "Május", "Június",
                    "Július", "Augusztus", "Szeptember", "Október", "November", "December"],
                monthNamesShort: ["Jan", "Feb", "Már", "Ápr", "Máj", "Jún",
                    "Júl", "Aug", "Szep", "Okt", "Nov", "Dec"],
                dayNames: ["Vasárnap", "Hétfő", "Kedd", "Szerda", "Csütörtök", "Péntek", "Szombat"],
                dayNamesShort: ["Vas", "Hét", "Ked", "Sze", "Csü", "Pén", "Szo"],
                dayNamesMin: ["V", "H", "K", "Sze", "Cs", "P", "Szo"],
                firstDay: 1,
                isRTL: false,
                showMonthAfterYear: true,
                yearSuffix: ""
            },
            "in_ID": {
                monthNames: ["Januari", "Februari", "Maret", "April", "Mei", "Juni", "Juli", "Agustus", "September", "Oktober", "Nopember", "Desember"],
                monthNamesShort: ["Jan", "Feb", "Mar", "Apr", "Mei", "Jun", "Jul", "Agus", "Sep", "Okt", "Nop", "Des"],
                dayNames: ["Minggu", "Senin", "Selasa", "Rabu", "Kamis", "Jumat", "Sabtu"],
                dayNamesMin: ["Mg", "Sn", "Sl", "Rb", "Km", "jm", "Sb"],
                firstDay: 0,
                isRTL: false,
                showMonthAfterYear: false,
                yearSuffix: ""
            },
            "is_IS": {
                monthNames: ["Janúar", "Febrúar", "Mars", "Apríl", "Maí", "Júní",
                    "Júlí", "Ágúst", "September", "Október", "Nóvember", "Desember"],
                monthNamesShort: ["Jan", "Feb", "Mar", "Apr", "Maí", "Jún",
                    "Júl", "Ágú", "Sep", "Okt", "Nóv", "Des"],
                dayNames: ["Sunnudagur", "Mánudagur", "Þriðjudagur", "Miðvikudagur", "Fimmtudagur", "Föstudagur", "Laugardagur"],
                dayNamesShort: ["Sun", "Mán", "Þri", "Mið", "Fim", "Fös", "Lau"],
                dayNamesMin: ["Su", "Má", "Þr", "Mi", "Fi", "Fö", "La"],
                firstDay: 0,
                isRTL: false,
                showMonthAfterYear: false,
                yearSuffix: ""
            },
            "it_IT": {
                monthNames: ["Gennaio", "Febbraio", "Marzo", "Aprile", "Maggio", "Giugno",
                    "Luglio", "Agosto", "Settembre", "Ottobre", "Novembre", "Dicembre"],
                monthNamesShort: ["Gen", "Feb", "Mar", "Apr", "Mag", "Giu",
                    "Lug", "Ago", "Set", "Ott", "Nov", "Dic"],
                dayNames: ["Domenica", "Lunedì", "Martedì", "Mercoledì", "Giovedì", "Venerdì", "Sabato"],
                dayNamesShort: ["Dom", "Lun", "Mar", "Mer", "Gio", "Ven", "Sab"],
                dayNamesMin: ["Do", "Lu", "Ma", "Me", "Gi", "Ve", "Sa"],
                firstDay: 1,
                isRTL: false,
                showMonthAfterYear: false,
                yearSuffix: ""
            },
            "iw_IL": {
                monthNames: ["ינואר", "פברואר", "מרץ", "אפריל", "מאי", "יוני", "יולי", "אוגוסט", "ספטמבר", "אוקטובר", "נובמבר", "דצמבר"],
                monthNamesShort: ["ינו", "פבר", "מרץ", "אפר", "מאי", "יוני", "יולי", "אוג", "ספט", "אוק", "נוב", "דצמ"],
                dayNames: ["ראשון", "שני", "שלישי", "רביעי", "חמישי", "שישי", "שבת"],
                dayNamesMin: ["א'", "ב'", "ג'", "ד'", "ה'", "ו'", "שבת"],
                firstDay: 0,
                isRTL: true,
                showMonthAfterYear: false,
                yearSuffix: ""
            },
            "ja_JP": {
                monthNames: ["1月", "2月", "3月", "4月", "5月", "6月",
                    "7月", "8月", "9月", "10月", "11月", "12月"],
                monthNamesShort: ["1月", "2月", "3月", "4月", "5月", "6月",
                    "7月", "8月", "9月", "10月", "11月", "12月"],
                dayNames: ["日曜日", "月曜日", "火曜日", "水曜日", "木曜日", "金曜日", "土曜日"],
                dayNamesShort: ["日", "月", "火", "水", "木", "金", "土"],
                dayNamesMin: ["日", "月", "火", "水", "木", "金", "土"],
                firstDay: 0,
                isRTL: false,
                showMonthAfterYear: true,
                yearSuffix: "年"
            },
            "ka_GE": {
                monthNames: ["იანვარი", "თებერვალი", "მარტი", "აპრილი", "მაისი", "ივნისი", "ივლისი", "აგვისტო", "სექტემბერი", "ოქტომბერი", "ნოემბერი", "დეკემბერი"],
                monthNamesShort: ["იან", "თებ", "მარ", "აპრ", "მაი", "ივნ", "ივლ", "აგვ", "სექ", "ოქტ", "ნოე", "დეკ"],
                dayNames: ["კვირა", "ორშაბათი", "სამშაბათი", "ოთხშაბათი", "ხუთშაბათი", "პარასკევი", "შაბათი"],
                dayNamesShort: ["კვ", "ორშ", "სამ", "ოთხ", "ხუთ", "პარ", "შაბ"],
                dayNamesMin: ["კვ", "ორშ", "სამ", "ოთხ", "ხუთ", "პარ", "შაბ"],
                firstDay: 1,
                isRTL: false,
                showMonthAfterYear: false,
                yearSuffix: ""
            },
            "ko_KR": {
                monthNames: ["1월", "2월", "3월", "4월", "5월", "6월",
                    "7월", "8월", "9월", "10월", "11월", "12월"],
                monthNamesShort: ["1월", "2월", "3월", "4월", "5월", "6월",
                    "7월", "8월", "9월", "10월", "11월", "12월"],
                dayNames: ["일요일", "월요일", "화요일", "수요일", "목요일", "금요일", "토요일"],
                dayNamesShort: ["일", "월", "화", "수", "목", "금", "토"],
                dayNamesMin: ["일", "월", "화", "수", "목", "금", "토"],
                firstDay: 0,
                isRTL: false,
                showMonthAfterYear: true,
                yearSuffix: "년"
            },
            "lt_LT": {
                monthNames: ["Sausis", "Vasaris", "Kovas", "Balandis", "Gegužė", "Birželis",
                    "Liepa", "Rugpjūtis", "Rugsėjis", "Spalis", "Lapkritis", "Gruodis"],
                monthNamesShort: ["Sau", "Vas", "Kov", "Bal", "Geg", "Bir",
                    "Lie", "Rugp", "Rugs", "Spa", "Lap", "Gru"],
                dayNames: ["sekmadienis", "pirmadienis", "antradienis", "trečiadienis", "ketvirtadienis", "penktadienis", "šeštadienis"],
                dayNamesShort: ["sek", "pir", "ant", "tre", "ket", "pen", "šeš"],
                dayNamesMin: ["Se", "Pr", "An", "Tr", "Ke", "Pe", "Še"],
                firstDay: 1,
                isRTL: false,
                showMonthAfterYear: true,
                yearSuffix: ""
            },
            "lv_LV": {
                monthNames: ["Janvāris", "Februāris", "Marts", "Aprīlis", "Maijs", "Jūnijs",
                    "Jūlijs", "Augusts", "Septembris", "Oktobris", "Novembris", "Decembris"],
                monthNamesShort: ["Jan", "Feb", "Mar", "Apr", "Mai", "Jūn",
                    "Jūl", "Aug", "Sep", "Okt", "Nov", "Dec"],
                dayNames: ["svētdiena", "pirmdiena", "otrdiena", "trešdiena", "ceturtdiena", "piektdiena", "sestdiena"],
                dayNamesShort: ["svt", "prm", "otr", "tre", "ctr", "pkt", "sst"],
                dayNamesMin: ["Sv", "Pr", "Ot", "Tr", "Ct", "Pk", "Ss"],
                firstDay: 1,
                isRTL: false,
                showMonthAfterYear: false,
                yearSuffix: ""
            },
            "mk_MK": {
                monthNames: ["Јануари", "Февруари", "Март", "Април", "Мај", "Јуни",
                    "Јули", "Август", "Септември", "Октомври", "Ноември", "Декември"],
                monthNamesShort: ["Јан", "Фев", "Мар", "Апр", "Мај", "Јун",
                    "Јул", "Авг", "Сеп", "Окт", "Ное", "Дек"],
                dayNames: ["Недела", "Понеделник", "Вторник", "Среда", "Четврток", "Петок", "Сабота"],
                dayNamesShort: ["Нед", "Пон", "Вто", "Сре", "Чет", "Пет", "Саб"],
                dayNamesMin: ["Не", "По", "Вт", "Ср", "Че", "Пе", "Са"],
                firstDay: 1,
                isRTL: false,
                showMonthAfterYear: false,
                yearSuffix: ""
            },
            "nl_BE": {
                monthNames: ["januari", "februari", "maart", "april", "mei", "juni",
                    "juli", "augustus", "september", "oktober", "november", "december"],
                monthNamesShort: ["jan", "feb", "mrt", "apr", "mei", "jun",
                    "jul", "aug", "sep", "okt", "nov", "dec"],
                dayNames: ["zondag", "maandag", "dinsdag", "woensdag", "donderdag", "vrijdag", "zaterdag"],
                dayNamesShort: ["zon", "maa", "din", "woe", "don", "vri", "zat"],
                dayNamesMin: ["zo", "ma", "di", "wo", "do", "vr", "za"],
                firstDay: 1,
                isRTL: false,
                showMonthAfterYear: false,
                yearSuffix: ""
            },
            "nl_NL": {
                monthNames: ["januari", "februari", "maart", "april", "mei", "juni",
                    "juli", "augustus", "september", "oktober", "november", "december"],
                monthNamesShort: ["jan", "feb", "mrt", "apr", "mei", "jun",
                    "jul", "aug", "sep", "okt", "nov", "dec"],
                dayNames: ["zondag", "maandag", "dinsdag", "woensdag", "donderdag", "vrijdag", "zaterdag"],
                dayNamesShort: ["zon", "maa", "din", "woe", "don", "vri", "zat"],
                dayNamesMin: ["zo", "ma", "di", "wo", "do", "vr", "za"],
                firstDay: 1,
                isRTL: false,
                showMonthAfterYear: false,
                yearSuffix: ""
            },
            "no_NO": {
                monthNames: ["januar", "februar", "mars", "april", "mai", "juni", "juli", "august", "september", "oktober", "november", "desember"],
                monthNamesShort: ["jan", "feb", "mar", "apr", "mai", "jun", "jul", "aug", "sep", "okt", "nov", "des"],
                dayNamesShort: ["søn", "man", "tir", "ons", "tor", "fre", "lør"],
                dayNames: ["søndag", "mandag", "tirsdag", "onsdag", "torsdag", "fredag", "lørdag"],
                dayNamesMin: ["sø", "ma", "ti", "on", "to", "fr", "lø"],
                firstDay: 1,
                isRTL: false,
                showMonthAfterYear: false,
                yearSuffix: ""
            },
            "pl_PL": {
                monthNames: ["Styczeń", "Luty", "Marzec", "Kwiecień", "Maj", "Czerwiec",
                    "Lipiec", "Sierpień", "Wrzesień", "Październik", "Listopad", "Grudzień"],
                monthNamesShort: ["Sty", "Lu", "Mar", "Kw", "Maj", "Cze",
                    "Lip", "Sie", "Wrz", "Pa", "Lis", "Gru"],
                dayNames: ["Niedziela", "Poniedziałek", "Wtorek", "Środa", "Czwartek", "Piątek", "Sobota"],
                dayNamesShort: ["Nie", "Pn", "Wt", "Śr", "Czw", "Pt", "So"],
                dayNamesMin: ["N", "Pn", "Wt", "Śr", "Cz", "Pt", "So"],
                firstDay: 1,
                isRTL: false,
                showMonthAfterYear: false,
                yearSuffix: ""
            },
            "pt_BR": {
                monthNames: ["Janeiro", "Fevereiro", "Março", "Abril", "Maio", "Junho",
                    "Julho", "Agosto", "Setembro", "Outubro", "Novembro", "Dezembro"],
                monthNamesShort: ["Jan", "Fev", "Mar", "Abr", "Mai", "Jun",
                    "Jul", "Ago", "Set", "Out", "Nov", "Dez"],
                dayNames: ["Domingo", "Segunda-feira", "Terça-feira", "Quarta-feira", "Quinta-feira", "Sexta-feira", "Sábado"],
                dayNamesShort: ["Dom", "Seg", "Ter", "Qua", "Qui", "Sex", "Sáb"],
                dayNamesMin: ["Dom", "Seg", "Ter", "Qua", "Qui", "Sex", "Sáb"],
                firstDay: 0,
                isRTL: false,
                showMonthAfterYear: false,
                yearSuffix: ""
            },
            "pt_PT": {
                monthNames: ["Janeiro", "Fevereiro", "Março", "Abril", "Maio", "Junho",
                    "Julho", "Agosto", "Setembro", "Outubro", "Novembro", "Dezembro"],
                monthNamesShort: ["Jan", "Fev", "Mar", "Abr", "Mai", "Jun",
                    "Jul", "Ago", "Set", "Out", "Nov", "Dez"],
                dayNames: ["Domingo", "Segunda-feira", "Terça-feira", "Quarta-feira", "Quinta-feira", "Sexta-feira", "Sábado"],
                dayNamesShort: ["Dom", "Seg", "Ter", "Qua", "Qui", "Sex", "Sáb"],
                dayNamesMin: ["Dom", "Seg", "Ter", "Qua", "Qui", "Sex", "Sáb"],
                firstDay: 0,
                isRTL: false,
                showMonthAfterYear: false,
                yearSuffix: ""
            },
            "ro_RO": {
                monthNames: ["Ianuarie", "Februarie", "Martie", "Aprilie", "Mai", "Iunie",
                    "Iulie", "August", "Septembrie", "Octombrie", "Noiembrie", "Decembrie"],
                monthNamesShort: ["Ian", "Feb", "Mar", "Apr", "Mai", "Iun",
                    "Iul", "Aug", "Sep", "Oct", "Nov", "Dec"],
                dayNames: ["Duminică", "Luni", "Marţi", "Miercuri", "Joi", "Vineri", "Sâmbătă"],
                dayNamesShort: ["Dum", "Lun", "Mar", "Mie", "Joi", "Vin", "Sâm"],
                dayNamesMin: ["Du", "Lu", "Ma", "Mi", "Jo", "Vi", "Sâ"],
                firstDay: 1,
                isRTL: false,
                showMonthAfterYear: false,
                yearSuffix: ""
            },
            "ru_RU": {
                monthNames: ["Январь", "Февраль", "Март", "Апрель", "Май", "Июнь",
                    "Июль", "Август", "Сентябрь", "Октябрь", "Ноябрь", "Декабрь"],
                monthNamesShort: ["Янв", "Фев", "Мар", "Апр", "Май", "Июн",
                    "Июл", "Авг", "Сен", "Окт", "Ноя", "Дек"],
                dayNames: ["воскресенье", "понедельник", "вторник", "среда", "четверг", "пятница", "суббота"],
                dayNamesShort: ["вск", "пнд", "втр", "срд", "чтв", "птн", "сбт"],
                dayNamesMin: ["Вс", "Пн", "Вт", "Ср", "Чт", "Пт", "Сб"],
                firstDay: 1,
                isRTL: false,
                showMonthAfterYear: false,
                yearSuffix: ""
            },
            "sk_SK": {
                monthNames: ["január", "február", "marec", "apríl", "máj", "jún",
                    "júl", "august", "september", "október", "november", "december"],
                monthNamesShort: ["Jan", "Feb", "Mar", "Apr", "Máj", "Jún",
                    "Júl", "Aug", "Sep", "Okt", "Nov", "Dec"],
                dayNames: ["nedeľa", "pondelok", "utorok", "streda", "štvrtok", "piatok", "sobota"],
                dayNamesShort: ["Ned", "Pon", "Uto", "Str", "Štv", "Pia", "Sob"],
                dayNamesMin: ["Ne", "Po", "Ut", "St", "Št", "Pia", "So"],
                firstDay: 1,
                isRTL: false,
                showMonthAfterYear: false,
                yearSuffix: ""
            },
            "sl_SL": {
                monthNames: ["Januar", "Februar", "Marec", "April", "Maj", "Junij",
                    "Julij", "Avgust", "September", "Oktober", "November", "December"],
                monthNamesShort: ["Jan", "Feb", "Mar", "Apr", "Maj", "Jun",
                    "Jul", "Avg", "Sep", "Okt", "Nov", "Dec"],
                dayNames: ["Nedelja", "Ponedeljek", "Torek", "Sreda", "Četrtek", "Petek", "Sobota"],
                dayNamesShort: ["Ned", "Pon", "Tor", "Sre", "Čet", "Pet", "Sob"],
                dayNamesMin: ["Ne", "Po", "To", "Sr", "Če", "Pe", "So"],
                firstDay: 1,
                isRTL: false,
                showMonthAfterYear: false,
                yearSuffix: ""
            },
            "sr_SR": {
                monthNames: ["Јануар", "Фебруар", "Март", "Април", "Мај", "Јун",
                    "Јул", "Август", "Септембар", "Октобар", "Новембар", "Децембар"],
                monthNamesShort: ["Јан", "Феб", "Мар", "Апр", "Мај", "Јун",
                    "Јул", "Авг", "Сеп", "Окт", "Нов", "Дец"],
                dayNames: ["Недеља", "Понедељак", "Уторак", "Среда", "Четвртак", "Петак", "Субота"],
                dayNamesShort: ["Нед", "Пон", "Уто", "Сре", "Чет", "Пет", "Суб"],
                dayNamesMin: ["Не", "По", "Ут", "Ср", "Че", "Пе", "Су"],
                firstDay: 1,
                isRTL: false,
                showMonthAfterYear: false,
                yearSuffix: ""
            },
            "sv_SE": {
                monthNames: ["Januari", "Februari", "Mars", "April", "Maj", "Juni",
                    "Juli", "Augusti", "September", "Oktober", "November", "December"],
                monthNamesShort: ["Jan", "Feb", "Mar", "Apr", "Maj", "Jun",
                    "Jul", "Aug", "Sep", "Okt", "Nov", "Dec"],
                dayNamesShort: ["Sön", "Mån", "Tis", "Ons", "Tor", "Fre", "Lör"],
                dayNames: ["Söndag", "Måndag", "Tisdag", "Onsdag", "Torsdag", "Fredag", "Lördag"],
                dayNamesMin: ["Sö", "Må", "Ti", "On", "To", "Fr", "Lö"],
                firstDay: 1,
                isRTL: false,
                showMonthAfterYear: false,
                yearSuffix: ""
            },
            "th_TH": {
                monthNames: ["มกราคม", "กุมภาพันธ์", "มีนาคม", "เมษายน", "พฤษภาคม", "มิถุนายน",
                    "กรกฎาคม", "สิงหาคม", "กันยายน", "ตุลาคม", "พฤศจิกายน", "ธันวาคม"],
                monthNamesShort: ["ม.ค.", "ก.พ.", "มี.ค.", "เม.ย.", "พ.ค.", "มิ.ย.",
                    "ก.ค.", "ส.ค.", "ก.ย.", "ต.ค.", "พ.ย.", "ธ.ค."],
                dayNames: ["อาทิตย์", "จันทร์", "อังคาร", "พุธ", "พฤหัสบดี", "ศุกร์", "เสาร์"],
                dayNamesShort: ["อา.", "จ.", "อ.", "พ.", "พฤ.", "ศ.", "ส."],
                dayNamesMin: ["อา.", "จ.", "อ.", "พ.", "พฤ.", "ศ.", "ส."],
                firstDay: 0,
                isRTL: false,
                showMonthAfterYear: false,
                yearSuffix: ""
            },
            "tr_TR": {
                monthNames: ["Ocak", "Şubat", "Mart", "Nisan", "Mayıs", "Haziran",
                    "Temmuz", "Ağustos", "Eylül", "Ekim", "Kasım", "Aralık"],
                monthNamesShort: ["Oca", "Şub", "Mar", "Nis", "May", "Haz",
                    "Tem", "Ağu", "Eyl", "Eki", "Kas", "Ara"],
                dayNames: ["Pazar", "Pazartesi", "Salı", "Çarşamba", "Perşembe", "Cuma", "Cumartesi"],
                dayNamesShort: ["Pz", "Pt", "Sa", "Ça", "Pe", "Cu", "Ct"],
                dayNamesMin: ["Pz", "Pt", "Sa", "Ça", "Pe", "Cu", "Ct"],
                firstDay: 1,
                isRTL: false,
                showMonthAfterYear: false,
                yearSuffix: ""
            },
            "uk_UA": {
                monthNames: ["Січень", "Лютий", "Березень", "Квітень", "Травень", "Червень", "Липень", "Серпень", "Вересень", "Жовтень", "Листопад", "Грудень"],
                monthNamesShort: ["Січ", "Лют", "Бер", "Кві", "Тра", "Чер",
                    "Лип", "Сер", "Вер", "Жов", "Лис", "Гру"],
                dayNames: ["неділя", "понеділок", "вівторок", "середа", "четвер", "п’ятниця", "субота"],
                dayNamesShort: ["нед", "пнд", "вів", "срд", "чтв", "птн", "сбт"],
                dayNamesMin: ["Нд", "Пн", "Вт", "Ср", "Чт", "Пт", "Сб"],
                firstDay: 1,
                isRTL: false,
                showMonthAfterYear: false,
                yearSuffix: ""
            },
            "vi_VN": {
                monthNames: ["Tháng Một", "Tháng Hai", "Tháng Ba", "Tháng Tư", "Tháng Năm", "Tháng Sáu",
                    "Tháng Bảy", "Tháng Tám", "Tháng Chín", "Tháng Mười", "Tháng Mười Một", "Tháng Mười Hai"],
                monthNamesShort: ["Tháng 1", "Tháng 2", "Tháng 3", "Tháng 4", "Tháng 5", "Tháng 6",
                    "Tháng 7", "Tháng 8", "Tháng 9", "Tháng 10", "Tháng 11", "Tháng 12"],
                dayNames: ["Chủ Nhật", "Thứ Hai", "Thứ Ba", "Thứ Tư", "Thứ Năm", "Thứ Sáu", "Thứ Bảy"],
                dayNamesShort: ["CN", "T2", "T3", "T4", "T5", "T6", "T7"],
                dayNamesMin: ["CN", "T2", "T3", "T4", "T5", "T6", "T7"],
                firstDay: 0,
                isRTL: false,
                showMonthAfterYear: false,
                yearSuffix: ""
            },
            "zh_CN": {
                monthNames: ["一月", "二月", "三月", "四月", "五月", "六月", "七月", "八月", "九月", "十月", "十一月", "十二月"],
                monthNamesShort: ["一月", "二月", "三月", "四月", "五月", "六月", "七月", "八月", "九月", "十月", "十一月", "十二月"],
                dayNames: ["星期日", "星期一", "星期二", "星期三", "星期四", "星期五", "星期六"],
                dayNamesShort: ["周日", "周一", "周二", "周三", "周四", "周五", "周六"],
                dayNamesMin: ["日", "一", "二", "三", "四", "五", "六"],
                firstDay: 1,
                isRTL: false,
                showMonthAfterYear: true,
                yearSuffix: "年"
            },
            "zh_TW": {
                monthNames: ["一月", "二月", "三月", "四月", "五月", "六月", "七月", "八月", "九月", "十月", "十一月", "十二月"],
                monthNamesShort: ["一月", "二月", "三月", "四月", "五月", "六月", "七月", "八月", "九月", "十月", "十一月", "十二月"],
                dayNames: ["星期日", "星期一", "星期二", "星期三", "星期四", "星期五", "星期六"],
                dayNamesShort: ["周日", "周一", "周二", "周三", "周四", "周五", "周六"],
                dayNamesMin: ["日", "一", "二", "三", "四", "五", "六"],
                firstDay: 1,
                isRTL: false,
                showMonthAfterYear: true,
                yearSuffix: "年"
            }
        }
    };
})(AJS.$ || $);
