window.define('stiltsoft/handy-macros/cookie-manager', ['exports'], function(exports) {
    exports.setCookie = function(name, value) {
        document.cookie = name + '=' + encodeURIComponent(value) + '; max-age=' + 60 * 60 * 24 * 3000;
    };

    exports.getCookie = function(name) {
        const cookie = document.cookie;
        if (cookie.length !== 0) {
            const re = new RegExp('[; ]' + name + '=([^\\s;]*)');
            const matcher = (' ' + cookie).match(re);
            if (matcher) {
                return decodeURIComponent(matcher[1]);
            }
        }
        return '';
    };
});
