window.define('stiltsoft/handy-macros/analytics/settings',
    [
        'exports',
        'jquery',
        'backbone',
        'stiltsoft/handy-macros/analytics/model'
    ],
    function (exports, $, Backbone, StateModel) {

        const SettingsView = Backbone.View.extend({
            tagName: 'div',
            template: Stiltsoft.HandyMacros.Analytics.sectionView,
            events: {
                "change form": "onChange",
            },

            initialize: function () {
                this.listenTo(this.model, "change", this.render);
            },

            onChange: function(e) {
                console.log('Value', e.target.checked);
                this.model.setState(e.target.checked);
            },

            render: function () {
                this.$el.empty();
                if (this.model.get('ready')) {
                    var state = this.model.get('state');
                    if (state === 'none') {
                        this.$el.append(this.template({state: true}));
                    } else {
                        this.$el.append(this.template({state: state}));
                    }
                }
                return this;
            }
        });

        function onTabSelect(e) {
            console.log('Create view');
            const model = new StateModel();
            const container = document.getElementById('ga-setting-pane');
            const view = new SettingsView({model: model, el: container});
            view.render();
            model.fetchState();
        }

        exports.init = function () {
            console.log('Init section');
            var tabMenuItem = document.querySelector('.menu-item > a.settings');
            if (tabMenuItem) {
                $(tabMenuItem).one('tabSelect', onTabSelect);
            }
        }
    });