window.define('stiltsoft/handy-macros/analytics/operations',
    ['exports', 'jquery', 'underscore'], function (exports, $, _) {
        var TRACKING_URL = '/rest/handy-macros/2.0/analytics';

        function allowTracking() {
            return $.ajax({
                contentType: "application/json; charset=utf-8",
                type: 'PUT',
                cache: false,
                url: Confluence.getContextPath() + TRACKING_URL,
                data: {},
                dataType: 'json'
            }).promise();
        }

        function disableTracking() {
            return $.ajax({
                contentType: "application/json; charset=utf-8",
                type: 'DELETE',
                cache: false,
                url: Confluence.getContextPath() + TRACKING_URL,
                data: {},
                dataType: 'json'
            }).promise();
        }

        exports.fetchState = function () {
            return new Promise(function (resolve, reject) {
                $.ajax({
                    contentType: "application/json; charset=utf-8",
                    type: 'GET',
                    cache: false,
                    url: Confluence.getContextPath() + TRACKING_URL,
                    data: {},
                    dataType: 'json',
                    success: function (response, statusText, jqXHR) {
                        if (statusText === 'nocontent') {
                            resolve(false);
                        }
                        resolve(response);
                    },
                    error: function (xhr) {
                        reject(xhr);
                    }
                });
            });
        };

        exports.trackingUrl = TRACKING_URL;

        exports.setState = function (value) {
            var xhr = (value)
                ? allowTracking()
                : disableTracking();
            return xhr.then(function () {
                return value;
            });
        };
    });