window.define('stiltsoft/handy-macros/analytics/model',
    ['jquery', 'backbone', 'stiltsoft/handy-macros/analytics/operations'],
    function ($, Backbone, Operations) {
        return Backbone.Model.extend({
            onDataReady: function (response) {
                console.log("State ready", response);
                this.set({ready: true, state: response});
                $(document).on('handy-ga-state', this.onStateChange.bind(this));
            },

            fetchState: function () {
                Operations.fetchState()
                    .then(this.onDataReady.bind(this))
                    .catch(function (e) {
                        console.log('Error', e);
                    });
            },

            onStateChange: function (event, value) {
                console.log("State changed", value);
                this.set({state: value});
            },

            onSetComplete: function(value) {
                this.set({state: value});
                $(document).trigger('handy-ga-state', value);
            },

            setState: function (value) {
                console.log("Set state", value);
                Operations.setState(value).then(this.onSetComplete.bind(this));
            }
        });

    });