window.define('stiltsoft/handy-macros/analytics',
    ['exports', 'underscore', 'backbone', 'stiltsoft/handy-macros/analytics/model'],
    function (exports, _, Backbone, StateModel) {

        const ConsentView = Backbone.View.extend({
            tagName: 'div',
            template: Stiltsoft.HandyMacros.Analytics.sectionMessage,
            events: {
                "click .accept": "onAccept",
                "click .decline": "onDecline"
            },

            initialize: function () {
                this.listenTo(this.model, "change", this.render);
            },

            onAccept: function() {
                this.model.setState(true);
            },

            onDecline: function() {
                this.model.setState(false);
            },

            render: function () {
                this.$el.empty();
                if (this.model.get('ready')) {
                    if (this.model.get('state') === 'none') {
                        this.$el.append(this.template());
                    }
                }
                return this;
            }
        });

        function getContainer() {
            const isSpace = !!document.querySelector('.ia-splitter')
            if (isSpace) {
                return document.getElementById('title-heading');
            } else {
                return document.querySelector('.logo-heading-block');
            }
        }

        exports.createConsentMessage = function () {
            var container = getContainer();
            var model = new StateModel();
            var consentView = new ConsentView({model: model});
            $(container).after(consentView.render().$el);
            model.fetchState();
        };
    });
