window.define('stiltsoft/handy-macros/analytics/client',
    [
        'exports',
        'stiltsoft/handy-macros/analytics/operations',
    ], function (exports, Operations) {

        const ga4eventsResourcePath = 'com.stiltsoft.confluence.handy.macros:ga4-events';
        const googleAnalytics4ResourcePath = 'com.stiltsoft.confluence.handy.macros:google-analytics4';

        function ga4macroInsertedAccessor(macroType) {
            return () => {
                window.HandyGA4Events.ga4macroInserted({macro_type: macroType});
            };
        }

        function ga4featureUsedAccessor(featureType) {
            return () => {
                window.HandyGA4Events.ga4featureUsed({feature_type: featureType});
            };
        }

        function ga4statusSelectedAccessor(count) {
            return () => {
                window.HandyGA4Events.ga4statusSelected({statuses_count: count});
            };
        }

        function ga4pageStatusEnableGlobalAccessor() {
            return () => {
                window.HandyGA4Events.ga4pageStatusEnableGlobal();
            };
        }

        function ga4pageStatusDisableGlobalAccessor() {
            return () => {
                window.HandyGA4Events.ga4pageStatusDisableGlobal();
            };
        }

        function sendAnalyticsEvent(eventAccessor) {
            Operations.fetchState().then((response) => {
                if (!response) {
                    return;
                }
                if (!window.handyGtag) {
                    WRM.require(googleAnalytics4ResourcePath);
                }
                if (window.handyGtag && window.HandyGA4Events) {
                    eventAccessor();
                } else {
                    loadLazyGA4EventsResourceAndSendEvent(eventAccessor);
                }
            });
        }

        function loadLazyGA4EventsResourceAndSendEvent(eventAccessor) {
            let attempts = 10;
            const interval = setInterval(function () {
                if (attempts < 1) {
                    clearInterval(interval);
                    console.error('Failed to load HandyGA4Events resource after multiple attempts.');
                    return;
                }
                if (window.handyGtag) {
                    WRM.require(ga4eventsResourcePath, () => {
                        if (window.HandyGA4Events) {
                            clearInterval(interval);
                            eventAccessor();
                        } else {
                            console.error('HandyGA4Events is still unavailable after loading the resource.');
                        }
                    });
                } else {
                    attempts--;
                    console.log('Attempts to load HandyGA4Events resource = ' + (10 - attempts));
                }
            }, 1000);
        }

        function sendInsertMacroEvent(macroType) {
            sendAnalyticsEvent(ga4macroInsertedAccessor(macroType));
        }

        function sendFeatureUsedEvent(featureType) {
            sendAnalyticsEvent(ga4featureUsedAccessor(featureType));
        }

        function sendStatusChangedEvent(count) {
            sendAnalyticsEvent(ga4statusSelectedAccessor(count));
        }

        function sendPageStatusEnableGlobalEvent() {
            sendAnalyticsEvent(ga4pageStatusEnableGlobalAccessor());
        }

        function sendPageStatusDisableGlobalEvent() {
            sendAnalyticsEvent(ga4pageStatusDisableGlobalAccessor());
        }

        exports.sendFeatureUsedEvent = sendFeatureUsedEvent;
        exports.sendInsertMacroEvent = sendInsertMacroEvent;
        exports.sendStatusChangedEvent = sendStatusChangedEvent;
        exports.sendPageStatusEnableGlobalEvent = sendPageStatusEnableGlobalEvent;
        exports.sendPageStatusDisableGlobalEvent = sendPageStatusDisableGlobalEvent;
    });

window.define('stiltsoft/handy-macros/analytics/client/extender',
    ['exports',
        'underscore',
        'stiltsoft/handy-macros/analytics/client',
    ], function (exports, _, Client) {

        exports.extendObject = function (obj) {
            _.extend(obj, {
                sendAnalyticsInsertEvent: Client.sendInsertMacroEvent,
                sendAnalyticsUsedEvent: Client.sendFeatureUsedEvent,
            });
        };

        exports.extend = function (obj) {
            obj.updateSelectedMacro = function () {
                console.log('Is updated macro');
                this.updated = true;
            }.bind(obj);

            obj.manipulateMarkup = function (metadata) {
                if (!this.updated) {
                    console.log('Send event', metadata);
                    Client.sendInsertMacroEvent(metadata.title);
                }
            }.bind(obj);
            return obj;
        };
    });
