/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.workbox;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.mywork.model.Notification;
import com.atlassian.mywork.model.NotificationBuilder;
import com.atlassian.mywork.service.LocalNotificationService;
import com.atlassian.user.User;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WorkboxManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkboxManager.class);
    private final UserAccessor userAccessor;
    private final GlobalSettingsManager settingsManager;
    private final LocalNotificationService localNotificationService;

    public WorkboxManager(UserAccessor userAccessor, GlobalSettingsManager settingsManager, LocalNotificationService localNotificationService) {
        this.userAccessor = userAccessor;
        this.settingsManager = settingsManager;
        this.localNotificationService = localNotificationService;
    }

    public void addReminderNotification(ConfluenceUser user, ConfluenceUser author, AbstractPage page, String desc, int id) {
        try {
            ObjectNode metadata = new ObjectMapper().createObjectNode();
            metadata.put("user", author.getFullName());
            metadata.put("page", page.getTitle());
            Notification notification = new NotificationBuilder().application("com.stiltsoft.confluence.handy.macros.workbox").entity("reminder").action("view").itemTitle(page.getTitle()).itemUrl(this.settingsManager.getGlobalSettings().getBaseUrl() + page.getUrlPath() + "#handy-reminder-" + id).iconUrl(this.settingsManager.getGlobalSettings().getBaseUrl() + this.userAccessor.getUserProfilePicture((User)author).getUriReference()).description(desc).metadata(metadata.toString()).groupingId(String.valueOf(id)).createNotification();
            this.localNotificationService.createOrUpdate(user.getName(), notification).get();
        }
        catch (Exception e) {
            log.error("Unable to add 'handy reminder' to workbox", (Throwable)e);
        }
    }
}

