/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.util.log;

import com.stiltsoft.confluence.handy.macros.util.log.Tick;
import com.stiltsoft.confluence.handy.macros.util.log.TickCollector;
import java.text.DecimalFormat;
import java.util.Iterator;
import org.slf4j.Logger;

public class Ticks {
    private static final DecimalFormat df = new DecimalFormat("#.###");

    public static TickCollector start(String name) {
        TickCollector collector = new TickCollector();
        collector.addTick(name);
        return collector;
    }

    public static void log(Logger log, TickCollector tickCollector) {
        if (!log.isDebugEnabled()) {
            return;
        }
        Iterator<Tick> iterator = tickCollector.iterator();
        Tick initTick = iterator.next();
        StringBuilder sb = new StringBuilder();
        while (iterator.hasNext()) {
            Tick current = iterator.next();
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(current.getName()).append(": ").append(Ticks.formatValue(current.getValue()));
        }
        log.debug("Ticks - {} - {} ", (Object)initTick.getName(), (Object)sb);
    }

    private static String formatValue(long value) {
        if (value < 1000L) {
            return value + "ns";
        }
        long trunc = value / 1000L;
        return df.format((double)trunc / 1000.0) + "ms";
    }
}

