/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.util;

import com.atlassian.confluence.core.DateFormatter;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.User;
import com.stiltsoft.confluence.handy.macros.util.UserLocaleConfiguration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.springframework.stereotype.Component;

@Component
public class TimeFormatter {
    private final UserLocaleConfiguration userLocaleConfiguration;

    public TimeFormatter(UserLocaleConfiguration userLocaleConfiguration) {
        this.userLocaleConfiguration = userLocaleConfiguration;
    }

    public String format(Date date, String format) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        DateFormatter dateFormatter = this.userLocaleConfiguration.getDateFormatter((User)user);
        return dateFormatter.formatGivenString(format, date);
    }

    public String formatUTC(long millis) {
        Instant instant = Instant.ofEpochMilli(millis);
        ZonedDateTime zonedDateTimeUTC = instant.atZone(ZoneOffset.UTC);
        return zonedDateTimeUTC.format(DateTimeFormatter.ISO_DATE_TIME);
    }
}

