/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class StringUtil {
    private StringUtil() {
        throw new IllegalAccessError("Utility class");
    }

    public static List<String> splitString(String value, String splitter) {
        return Optional.ofNullable(value).filter(users -> !users.isEmpty()).map(users -> Arrays.asList(users.split(splitter))).orElseGet(Collections::emptyList);
    }

    public static int parsePositiveInt(String value, int defaultValue, int maxValue) {
        return StringUtils.defaultString((String)value).matches("\\d+") ? Math.min(Integer.parseInt(value), maxValue) : defaultValue;
    }

    public static Optional<Integer> parseInteger(String value) {
        try {
            Integer number = Integer.valueOf(value);
            return Optional.of(number);
        }
        catch (NumberFormatException ex) {
            return Optional.empty();
        }
    }
}

