/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class JsonSerializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JsonSerializer.class);
    private final ObjectMapper objectMapper = new ObjectMapper();

    public String serialize(Object object) {
        try {
            return this.objectMapper.writeValueAsString(object);
        }
        catch (IOException e) {
            String errorMessage = "Unable to serialize object. Object: " + object.toString();
            log.error(errorMessage, (Throwable)e);
            throw new RuntimeException(errorMessage, e);
        }
    }

    public <T> T deserialize(String content, Class<T> valueType) {
        try {
            return (T)this.objectMapper.readValue(content, valueType);
        }
        catch (IOException e) {
            String errorMessage = "Unable to deserialize content. Content: " + content;
            log.error(errorMessage, (Throwable)e);
            throw new RuntimeException(errorMessage, e);
        }
    }
}

