/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.util;

import com.atlassian.confluence.content.render.xhtml.model.time.Time;
import com.atlassian.confluence.core.TimeZone;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public final class DateTimeUtil {
    public static final DateTimeFormatter DEF_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    private DateTimeUtil() {
        throw new IllegalAccessError("Utility class");
    }

    public static Time convertToTime(long timestamp, TimeZone timeZone) {
        ZonedDateTime zonedDateTime = DateTimeUtil.getZonedDateTime(timestamp, timeZone);
        return DateTimeUtil.convertZonedDateTimeToTime(zonedDateTime);
    }

    public static Time convertZonedDateTimeToTime(ZonedDateTime zonedDateTime) {
        return new Time(zonedDateTime.format(DEF_DATE_TIME_FORMATTER));
    }

    public static ZonedDateTime getZonedDateTime(long timestamp, TimeZone timeZone) {
        Instant instant = Instant.ofEpochMilli(timestamp);
        ZoneId zoneId = ZoneId.of(timeZone.getID());
        return ZonedDateTime.ofInstant(instant, zoneId);
    }
}

