/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class CollectionUtil {
    private CollectionUtil() {
        throw new IllegalAccessError("Utility class");
    }

    public static <T> List<Collection<T>> splitCollection(Collection<T> sourceCollection, int batchSize) {
        if (sourceCollection.isEmpty() || batchSize <= 0) {
            return Collections.emptyList();
        }
        if (sourceCollection.size() <= batchSize) {
            return Collections.singletonList(sourceCollection);
        }
        ArrayList<Collection<T>> batches = new ArrayList<Collection<T>>();
        int currentBatch = 1;
        int count = 1;
        ArrayList<T> tempList = new ArrayList<T>(batchSize * 2);
        for (T entry : sourceCollection) {
            tempList.add(entry);
            if (++currentBatch <= batchSize && ++count <= sourceCollection.size()) continue;
            currentBatch = 1;
            batches.add(new ArrayList(tempList));
            tempList.clear();
        }
        return batches;
    }
}

