/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.user.impl;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.User;
import com.stiltsoft.confluence.handy.macros.rest.entity.UserRestEntity;
import com.stiltsoft.confluence.handy.macros.user.UserResourceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultUserResourceService
implements UserResourceService {
    private final UserAccessor userAccessor;
    private final UserRestEntity anonymous;

    @Autowired
    public DefaultUserResourceService(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
        String avatarUrl = userAccessor.getUserProfilePicture(null).getUriReference();
        this.anonymous = new UserRestEntity("", "", "Anonymous", avatarUrl);
    }

    @Override
    public UserRestEntity getUserRestEntity(String userKey) {
        UserKey authorUserKey = new UserKey(userKey);
        ConfluenceUser user = this.userAccessor.getUserByKey(authorUserKey);
        if (user == null) {
            return this.anonymous;
        }
        String avatarUrl = this.userAccessor.getUserProfilePicture((User)user).getUriReference();
        return new UserRestEntity(userKey, user.getName(), user.getFullName(), avatarUrl);
    }
}

