/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.tracking.dao.impl;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.stiltsoft.confluence.handy.macros.tracking.dao.ReminderMacroUsageDao;
import java.util.Objects;
import org.springframework.stereotype.Component;

@Component
public class DefaultReminderMacroUsageDao
implements ReminderMacroUsageDao {
    public static final String REMINDERS_NUMBER_STORE_KEY = "com.stiltsoft.confluence.handy.macros.reminders.number";
    public static final String REMINDERS_LAST_SEND_DATE_STORE_KEY = "com.stiltsoft.confluence.handy.macros.reminders.last.date";
    private final BandanaManager bandanaManager;
    private final BandanaContext bandanaContext;

    public DefaultReminderMacroUsageDao(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
        this.bandanaContext = new ConfluenceBandanaContext();
    }

    @Override
    public int getRemindersNumber() {
        Integer remindersNumber = (Integer)this.bandanaManager.getValue(this.bandanaContext, REMINDERS_NUMBER_STORE_KEY);
        if (Objects.isNull(remindersNumber)) {
            this.bandanaManager.setValue(this.bandanaContext, REMINDERS_NUMBER_STORE_KEY, (Object)0);
            this.setCurrentTimeAsLastSendDate();
            return 0;
        }
        return remindersNumber;
    }

    @Override
    public long getRemindersNumberLastSendDate() {
        Long remindersLastSendDate = (Long)this.bandanaManager.getValue(this.bandanaContext, REMINDERS_LAST_SEND_DATE_STORE_KEY);
        if (Objects.isNull(remindersLastSendDate)) {
            return this.setCurrentTimeAsLastSendDate();
        }
        return remindersLastSendDate;
    }

    @Override
    public void addRemindersNumber(int remindersNumber) {
        int currentRemindersNumber = this.getRemindersNumber();
        int newRemindersNumberValue = currentRemindersNumber + remindersNumber;
        this.bandanaManager.setValue(this.bandanaContext, REMINDERS_NUMBER_STORE_KEY, (Object)newRemindersNumberValue);
    }

    @Override
    public void updateRemindersLastSendDate(long newSendDate) {
        this.bandanaManager.setValue(this.bandanaContext, REMINDERS_LAST_SEND_DATE_STORE_KEY, (Object)newSendDate);
        this.bandanaManager.setValue(this.bandanaContext, REMINDERS_NUMBER_STORE_KEY, (Object)0);
    }

    private long setCurrentTimeAsLastSendDate() {
        long currentTimeMillis = System.currentTimeMillis();
        this.bandanaManager.setValue(this.bandanaContext, REMINDERS_LAST_SEND_DATE_STORE_KEY, (Object)currentTimeMillis);
        return currentTimeMillis;
    }
}

