/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.tracking;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.stiltsoft.confluence.handy.macros.license.LicenseInfo;
import com.stiltsoft.confluence.handy.macros.license.LicenseManager;
import com.stiltsoft.confluence.handy.macros.rest.analytics.entity.CommonDimensionsRestEntity;
import com.stiltsoft.confluence.handy.macros.tracking.DeploymentType;
import com.stiltsoft.confluence.handy.macros.tracking.TrackingService;
import com.stiltsoft.confluence.handy.macros.tracking.dao.ReminderMacroUsageDao;
import com.stiltsoft.confluence.handy.macros.util.AuthenticatedUserUtil;
import java.util.Optional;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.stereotype.Component;

@Component
public class DefaultTrackingService
implements TrackingService {
    private static final String STORAGE_NAME = " com.stiltsoft.confluence.handy.macros";
    private static final String PLUGIN_KEY = "com.stiltsoft.confluence.handy.macros";
    private final PluginAccessor pluginAccessor;
    private final LicenseManager licenseManager;
    private final PluginSettingsFactory pluginSettingsFactory;
    private final ReminderMacroUsageDao reminderMacroUsageDao;

    public DefaultTrackingService(LicenseManager licenseManager, PluginAccessor pluginAccessor, PluginSettingsFactory pluginSettingsFactory, ReminderMacroUsageDao reminderMacroUsageDao) {
        this.licenseManager = licenseManager;
        this.pluginAccessor = pluginAccessor;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.reminderMacroUsageDao = reminderMacroUsageDao;
    }

    @Override
    public Optional<Boolean> getTrackingConsent() {
        if (!AuthenticatedUserUtil.getAuthenticatedUser().isPresent()) {
            return Optional.of(false);
        }
        String value = (String)this.pluginSettingsFactory.createSettingsForKey(STORAGE_NAME).get(".tracking");
        return Optional.ofNullable(value).map(Boolean::parseBoolean);
    }

    @Override
    public void allowTracking() {
        this.pluginSettingsFactory.createSettingsForKey(STORAGE_NAME).put(".tracking", (Object)Boolean.TRUE.toString());
    }

    @Override
    public void disableTracking() {
        this.pluginSettingsFactory.createSettingsForKey(STORAGE_NAME).put(".tracking", (Object)Boolean.FALSE.toString());
    }

    @Override
    public void updateRemindersLastSendDate(long newSendDate) {
        this.reminderMacroUsageDao.updateRemindersLastSendDate(newSendDate);
    }

    @Override
    public CommonDimensionsRestEntity getCommonDimensionsRestEntity() {
        String anonymousOrUserKey = AuthenticatedUserUtil.getAuthenticatedUser().map(user -> user.getKey().getStringValue()).orElse("anonymous");
        String userHash = DigestUtils.sha256Hex((String)anonymousOrUserKey);
        LicenseInfo licenseInfo = this.licenseManager.getLicenseInfo();
        Plugin plugin = this.pluginAccessor.getEnabledPlugin(PLUGIN_KEY);
        String pluginVersion = plugin.getPluginInformation().getVersion();
        return CommonDimensionsRestEntity.builder().serverHash(licenseInfo.getServerHash()).userHash(userHash).userCount(licenseInfo.getUserCount()).pluginVersion(pluginVersion).licenseType(licenseInfo.getLicenseType()).deploymentType(this.getDeploymentType()).remindersNumber(this.reminderMacroUsageDao.getRemindersNumber()).remindersNumberLastSendDate(this.reminderMacroUsageDao.getRemindersNumberLastSendDate()).build();
    }

    private DeploymentType getDeploymentType() {
        return this.licenseManager.isLicensedForDataCenter() ? DeploymentType.DATA_CENTER : DeploymentType.SERVER;
    }
}

