/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.storage.transformer;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.content.render.xhtml.transformers.Transformer;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.User;
import com.atlassian.webresource.api.WebResourceManager;
import com.stiltsoft.confluence.handy.macros.license.LicenseManager;
import com.stiltsoft.confluence.handy.macros.service.HandyPermissionService;
import com.stiltsoft.confluence.handy.macros.settings.HandyHeaderSettingsService;
import com.stiltsoft.confluence.handy.macros.settings.HandyTasksSettingsService;
import com.stiltsoft.confluence.handy.macros.storage.transformer.HandyProcessor;
import com.stiltsoft.confluence.handy.macros.util.log.TickCollector;
import com.stiltsoft.confluence.handy.macros.util.log.Ticks;
import java.io.Reader;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandyTransformer
implements Transformer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HandyTransformer.class);
    protected static final String HANDY_ALREADY_RENDERED = "handy-rendered";
    private static final String SKIP_HANDY = "skip-handy";
    private final HandyProcessor handyProcessor;
    private final HandyPermissionService handyPermissionService;
    private final LicenseManager licenseManager;
    private final HandyHeaderSettingsService handyHeaderSettingsService;
    private final HandyTasksSettingsService handyTasksSettingsService;
    private final WebResourceManager resourceManager;
    private String include;

    public HandyTransformer(HandyProcessor handyProcessor, HandyPermissionService handyPermissionService, LicenseManager licenseManager, HandyHeaderSettingsService handyHeaderSettingsService, HandyTasksSettingsService handyTasksSettingsService, WebResourceManager webResourceManager) {
        this.handyProcessor = handyProcessor;
        this.handyPermissionService = handyPermissionService;
        this.licenseManager = licenseManager;
        this.handyHeaderSettingsService = handyHeaderSettingsService;
        this.handyTasksSettingsService = handyTasksSettingsService;
        this.resourceManager = webResourceManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String transform(Reader input, ConversionContext conversionContext) throws XhtmlException {
        String originalStorageMarkup = "";
        ContentEntityObject entity = conversionContext.getEntity();
        String title = entity == null ? "{nopage}" : entity.getTitle();
        TickCollector collector = Ticks.start("Transform [" + title + "]");
        try {
            originalStorageMarkup = IOUtils.toString((Reader)input);
            if (this.shouldTransform(conversionContext)) {
                collector.addTick("shouldTransform");
                String modifiedStorageMarkup = this.handyProcessor.process(originalStorageMarkup, entity, this.include);
                collector.addTick("process");
                conversionContext.setProperty(HANDY_ALREADY_RENDERED, (Object)Boolean.TRUE);
                String string = modifiedStorageMarkup;
                return string;
            }
            collector.addTick("shouldTransform");
            String modifiedStorageMarkup = originalStorageMarkup;
            return modifiedStorageMarkup;
        }
        catch (Throwable e) {
            log.error("Failed to process XHTML for Handy Date. Markup = {}.", (Object)originalStorageMarkup, (Object)e);
            String string = originalStorageMarkup;
            return string;
        }
        finally {
            Ticks.log(log, collector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean shouldTransform(ConversionContext conversionContext) {
        if (!this.licenseManager.isActive()) {
            return false;
        }
        ContentEntityObject entity = conversionContext.getEntity();
        if (!(entity instanceof AbstractPage) && !(entity instanceof Comment)) {
            return false;
        }
        if (conversionContext.hasProperty(SKIP_HANDY) || conversionContext.hasProperty(HANDY_ALREADY_RENDERED)) {
            return false;
        }
        if (!this.isPageView()) {
            return false;
        }
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        String personalKey = user == null ? "global" : "user:" + user.getKey().getStringValue();
        TickCollector collector = Ticks.start("shouldTransformIf");
        try {
            if (user != null && this.handyTasksSettingsService.isEnabled("global") && this.handyTasksSettingsService.isEnabled("space:" + StringUtils.defaultString((String)conversionContext.getSpaceKey())) && this.handyTasksSettingsService.isEnabled(personalKey)) {
                this.resourceManager.requireResource("com.stiltsoft.confluence.handy.macros:handy-task-resources");
            }
            collector.addTick("requireTaskResource");
            if (this.handyHeaderSettingsService.isEnabled("global") && this.handyHeaderSettingsService.isEnabled("space:" + StringUtils.defaultString((String)conversionContext.getSpaceKey())) && this.handyHeaderSettingsService.isEnabled(personalKey)) {
                this.resourceManager.requireResource("com.stiltsoft.confluence.handy.macros:handy-header-url-resources");
            }
            collector.addTick("requireHeaderResource");
            if (!entity.isLatestVersion()) {
                boolean bl = false;
                return bl;
            }
            collector.addTick("isLatestVersion");
            if (!this.handyPermissionService.hasEntityEditPermission((User)user, entity)) {
                collector.addTick("NoPageEditPermission");
                boolean bl = false;
                return bl;
            }
            collector.addTick("hasPageEditPermission");
            boolean bl = true;
            return bl;
        }
        finally {
            Ticks.log(log, collector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPageView() {
        this.include = "";
        TickCollector collector = Ticks.start("isPageView");
        StackTraceElement[] stackTrace = new Exception().getStackTrace();
        collector.addTick("stackTrace[" + stackTrace.length + "]");
        try {
            for (StackTraceElement traceElement : stackTrace) {
                String className = traceElement.getClassName();
                if (className.endsWith(".MultiExcerptIncludeMacro")) {
                    this.include = "MultiExcerptIncludeMacro";
                    continue;
                }
                if (className.endsWith(".ExcerptIncludeMacro") || className.endsWith(".AdvancedMacrosExcerpter")) {
                    this.include = "ExcerptIncludeMacro";
                    continue;
                }
                if (className.endsWith(".PageIncludeMacro")) {
                    this.include = "PageIncludeMacro";
                    continue;
                }
                if (className.endsWith(".ViewPageAction") || className.endsWith(".ZenTheme")) {
                    boolean bl = true;
                    return bl;
                }
                if (!className.startsWith("com.brikit.") && !className.startsWith("net.customware.")) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            collector.addTick("forEach");
            Ticks.log(log, collector);
        }
    }
}

