/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.storage.transformer;

import com.atlassian.confluence.content.render.xhtml.StaxUtils;
import com.atlassian.confluence.content.render.xhtml.XMLEventFactoryProvider;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.content.render.xhtml.XmlEventReaderFactory;
import com.atlassian.confluence.content.render.xhtml.XmlOutputFactory;
import com.atlassian.confluence.content.render.xhtml.storage.inlinetask.StorageInlineTaskConstants;
import com.atlassian.confluence.content.render.xhtml.storage.macro.StorageMacroConstants;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.confluence.xhtml.api.MacroDefinitionHandler;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class HandyProcessor {
    private static final Pattern multiExcerptParam = Pattern.compile("<ac:parameter ac:name=\"MultiExcerptName\">(.+?)</ac:parameter>");
    private static final QName thTag = new QName("http://www.w3.org/1999/xhtml", "th");
    private static final QName tdTag = new QName("http://www.w3.org/1999/xhtml", "td");
    private static final QName timeTag = new QName("http://www.w3.org/1999/xhtml", "time");
    private static final QName timeDateAttr = new QName("http://www.w3.org/1999/xhtml", "datetime");
    private static final QName timeIdAttr = new QName(null, "hd-id");
    private static final QName span = new QName("http://www.w3.org/1999/xhtml", "span");
    private final XmlEventReaderFactory xmlEventReaderFactory;
    private final XmlOutputFactory xmlOutputFactory;
    private final XMLEventFactory xmlEventFactory;
    private final XhtmlContent xhtmlContent;
    private final Set<QName> macros;

    public HandyProcessor(XmlEventReaderFactory xmlEventReaderFactory, @Qualifier(value="xmlOutputFactory") XmlOutputFactory xmlOutputFactory, XMLEventFactoryProvider xmlEventFactoryProvider, XhtmlContent xhtmlContent) {
        this.xmlEventReaderFactory = xmlEventReaderFactory;
        this.xmlOutputFactory = xmlOutputFactory;
        this.xmlEventFactory = xmlEventFactoryProvider.getXmlEventFactory();
        this.xhtmlContent = xhtmlContent;
        if (xmlOutputFactory.isPropertySupported("com.ctc.wstx.outputValidateStructure")) {
            xmlOutputFactory.setProperty("com.ctc.wstx.outputValidateStructure", (Object)Boolean.FALSE);
        }
        this.macros = new HashSet<QName>();
        this.macros.add(StorageMacroConstants.MACRO_ELEMENT);
        this.macros.add(new QName("http://atlassian.com/content", "structured-macro"));
    }

    public String process(String storageMarkup, ContentEntityObject ceo, String include) throws XhtmlException, XMLStreamException {
        return this.addDateMarkers(storageMarkup, ceo.getIdAsString(), String.valueOf(ceo.getVersion()), !include.isEmpty() ? ceo.getBodyAsString() : "", include);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String addDateMarkers(String storageMarkup, String pageId, String version, String originalBody, String include) throws XMLStreamException, XhtmlException {
        block13: {
            xmlEventReader = null;
            try {
                xmlEventReader = this.xmlEventReaderFactory.createStorageXmlEventReader((Reader)new StringReader(storageMarkup), false);
                writer = new StringWriter();
                markupWriter = this.xmlOutputFactory.createXMLEventWriter((Writer)writer);
                markerId = 0;
                multiExcerptId = 0;
                if ("ExcerptIncludeMacro".equals(include)) {
                    excerptMarkerId = this.addDateMarkers(originalBody, "", "", "", "");
                    if (excerptMarkerId.matches("\\d+")) {
                        markerId = Integer.valueOf(excerptMarkerId);
                    }
                    handler = new MacroBodyHandler("excerpt");
                    this.xhtmlContent.handleMacroDefinitions(originalBody, null, (MacroDefinitionHandler)handler);
                } else if ("MultiExcerptIncludeMacro".equals(include)) {
                    processedOB = originalBody.replaceAll("ac:macro-id=\"[a-fA-F0-9-]+\"", "");
                    insertIndex = processedOB.indexOf(processedSM = storageMarkup.replaceAll("ac:macro-id=\"[a-fA-F0-9-]+\"", "").replaceAll("\u00a0", "&nbsp;"));
                    if (insertIndex >= 0) {
                        processedOB = processedOB.substring(0, insertIndex);
                    }
                    multiexcerptIndex = processedOB.lastIndexOf("ac:name=\"multiexcerpt\"");
                    paramName = null;
                    paramValue = null;
                    if (multiexcerptIndex >= 0 && (matcher = HandyProcessor.multiExcerptParam.matcher(processedOB.substring(multiexcerptIndex))).find()) {
                        paramName = "MultiExcerptName";
                        paramValue = matcher.group(1);
                    }
                    handler = new MacroBodyHandler("multiexcerpt", paramName, paramValue);
                    this.xhtmlContent.handleMacroDefinitions(originalBody, null, (MacroDefinitionHandler)handler);
                    excerptMarkerId = this.addDateMarkers(originalBody, "", String.valueOf(handler.getCount()), "", "");
                    if (excerptMarkerId.matches("\\d+")) {
                        markerId = Integer.valueOf(excerptMarkerId);
                    }
                }
                isTimeTag = false;
                isTaskList = false;
lbl33:
                // 5 sources

                while (xmlEventReader.hasNext()) {
                    block15: {
                        block14: {
                            event = xmlEventReader.nextEvent();
                            if (!event.isStartElement()) ** GOTO lbl-1000
                            if (!StorageInlineTaskConstants.TASK_LIST_ELEMENT.equals(event.asStartElement().getName())) break block14;
                            isTaskList = true;
                            ** GOTO lbl-1000
                        }
                        if (isTaskList) ** GOTO lbl-1000
                        if (!HandyProcessor.timeTag.equals(event.asStartElement().getName()) || event.asStartElement().getAttributeByName(HandyProcessor.timeIdAttr) != null) break block15;
                        markupWriter.add(this.xmlEventFactory.createStartElement(HandyProcessor.span, null, null));
                        markupWriter.add(this.xmlEventFactory.createAttribute("hd-id", markerId.toString()));
                        markupWriter.add(this.xmlEventFactory.createAttribute("hd-pid", pageId));
                        markupWriter.add(this.xmlEventFactory.createAttribute("hd-pv", version));
                        var14_19 = markerId;
                        markerId = markerId + 1;
                        isTimeTag = true;
                        ** GOTO lbl-1000
                    }
                    if (!pageId.isEmpty()) ** GOTO lbl-1000
                    if (!version.isEmpty()) ** GOTO lbl-1000
                    if (this.isStartEventExcerptMacro(event)) {
                        var14_20 = markerId.toString();
                        break block13;
                    }
                    ** GOTO lbl-1000
                }
                ** GOTO lbl79
            }
            catch (Throwable var19_26) {
                StaxUtils.closeQuietly(xmlEventReader);
                throw var19_26;
            }
        }
        StaxUtils.closeQuietly((XMLEventReader)xmlEventReader);
        return var14_20;
lbl-1000:
        // 1 sources

        {
            if (!this.isStartEventMultiExcerptMacro(event) || Integer.valueOf(version) != ++multiExcerptId) ** GOTO lbl-1000
            var14_21 = markerId.toString();
        }
        StaxUtils.closeQuietly((XMLEventReader)xmlEventReader);
        return var14_21;
lbl-1000:
        // 7 sources

        {
            block16: {
                markupWriter.add(event);
                if (!event.isEndElement()) ** GOTO lbl33
                if (!StorageInlineTaskConstants.TASK_LIST_ELEMENT.equals(event.asEndElement().getName())) break block16;
                isTaskList = false;
                ** GOTO lbl33
            }
            if (!isTimeTag) ** GOTO lbl33
            isTimeTag = false;
            markupWriter.add(this.xmlEventFactory.createEndElement(HandyProcessor.span, null));
            ** GOTO lbl33
lbl79:
            // 1 sources

            markupWriter.flush();
            StaxUtils.closeQuietly((XMLEventWriter)markupWriter);
            var13_17 = writer.toString();
        }
        StaxUtils.closeQuietly((XMLEventReader)xmlEventReader);
        return var13_17;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map.Entry<String, Boolean> updateDate(String storageMarkup, int elementId, String date) throws XMLStreamException {
        AbstractMap.SimpleEntry<String, Boolean> simpleEntry;
        XMLEventReader xmlEventReader = null;
        try {
            xmlEventReader = this.xmlEventReaderFactory.createStorageXmlEventReader((Reader)new StringReader(storageMarkup));
            StringWriter writer = new StringWriter();
            XMLEventWriter markupWriter = this.xmlOutputFactory.createXMLEventWriter((Writer)writer);
            int markerId = 0;
            boolean updated = false;
            boolean isTaskList = false;
            while (xmlEventReader.hasNext()) {
                XMLEvent event = xmlEventReader.nextEvent();
                if (event.isStartElement()) {
                    if (StorageInlineTaskConstants.TASK_LIST_ELEMENT.equals(event.asStartElement().getName())) {
                        isTaskList = true;
                        markupWriter.add(event);
                        continue;
                    }
                    if (!isTaskList) {
                        if (timeTag.equals(event.asStartElement().getName())) {
                            if (markerId == elementId) {
                                markupWriter.add(this.xmlEventFactory.createStartElement(timeTag, null, null));
                                markupWriter.add(this.xmlEventFactory.createAttribute(timeDateAttr, date));
                                updated = true;
                            } else {
                                markupWriter.add(event);
                            }
                            ++markerId;
                            continue;
                        }
                        markupWriter.add(event);
                        continue;
                    }
                    markupWriter.add(event);
                    continue;
                }
                markupWriter.add(event);
                if (!event.isEndElement() || !StorageInlineTaskConstants.TASK_LIST_ELEMENT.equals(event.asEndElement().getName())) continue;
                isTaskList = false;
            }
            markupWriter.flush();
            StaxUtils.closeQuietly((XMLEventWriter)markupWriter);
            simpleEntry = new AbstractMap.SimpleEntry<String, Boolean>(writer.toString(), updated);
        }
        catch (Throwable throwable) {
            StaxUtils.closeQuietly(xmlEventReader);
            throw throwable;
        }
        StaxUtils.closeQuietly((XMLEventReader)xmlEventReader);
        return simpleEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String updatePPRDate(String storageMarkup, int elementId, String date, String colName) throws XMLStreamException {
        String string;
        XMLEventWriter markupWriter;
        StringWriter writer;
        XMLEventReader xmlEventReader;
        block24: {
            xmlEventReader = null;
            try {
                xmlEventReader = this.xmlEventReaderFactory.createStorageXmlEventReader((Reader)new StringReader(storageMarkup));
                writer = new StringWriter();
                markupWriter = this.xmlOutputFactory.createXMLEventWriter((Writer)writer);
                int thCount = -1;
                int thDepth = -1;
                int tdCount = -1;
                int tdDepth = -1;
                int cellPosition = -1;
                boolean found = false;
                while (xmlEventReader.hasNext()) {
                    XMLEvent event = xmlEventReader.nextEvent();
                    if (!found) {
                        if (event.isStartElement()) {
                            if (thDepth < 0 && tdDepth < 0) {
                                if (thTag.equals(event.asStartElement().getName())) {
                                    ++thCount;
                                    ++thDepth;
                                } else if (tdTag.equals(event.asStartElement().getName())) {
                                    if (tdCount < thCount) {
                                        ++tdCount;
                                    }
                                    ++tdDepth;
                                }
                            } else if (thDepth >= 0) {
                                ++thDepth;
                            } else if (tdDepth >= 0) {
                                ++tdDepth;
                                if (timeTag.equals(event.asStartElement().getName())) {
                                    if (!found && tdCount == cellPosition) {
                                        markupWriter.add(this.xmlEventFactory.createStartElement(timeTag, null, null));
                                        markupWriter.add(this.xmlEventFactory.createAttribute(timeDateAttr, date));
                                        found = true;
                                        continue;
                                    }
                                    markupWriter.add(event);
                                    continue;
                                }
                            }
                        } else if (event.isEndElement()) {
                            if (thDepth >= 0) {
                                --thDepth;
                            } else if (tdDepth >= 0) {
                                --tdDepth;
                            }
                        } else if (event.isCharacters() && thDepth >= 0 && colName.equals(event.asCharacters().getData().trim())) {
                            cellPosition = thCount;
                        }
                    }
                    markupWriter.add(event);
                }
                if (found) break block24;
                string = this.updatePPRDateByPosition(storageMarkup, elementId, date);
            }
            catch (Throwable throwable) {
                StaxUtils.closeQuietly(xmlEventReader);
                throw throwable;
            }
            StaxUtils.closeQuietly((XMLEventReader)xmlEventReader);
            return string;
        }
        markupWriter.flush();
        StaxUtils.closeQuietly((XMLEventWriter)markupWriter);
        string = writer.toString();
        StaxUtils.closeQuietly((XMLEventReader)xmlEventReader);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String updatePPRDateByPosition(String storageMarkup, int elementId, String date) throws XMLStreamException {
        String string;
        XMLEventReader xmlEventReader = null;
        try {
            xmlEventReader = this.xmlEventReaderFactory.createStorageXmlEventReader((Reader)new StringReader(storageMarkup));
            StringWriter writer = new StringWriter();
            XMLEventWriter markupWriter = this.xmlOutputFactory.createXMLEventWriter((Writer)writer);
            int markerId = 0;
            while (xmlEventReader.hasNext()) {
                XMLEvent event = xmlEventReader.nextEvent();
                if (event.isStartElement() && timeTag.equals(event.asStartElement().getName())) {
                    if (markerId == elementId) {
                        markupWriter.add(this.xmlEventFactory.createStartElement(timeTag, null, null));
                        markupWriter.add(this.xmlEventFactory.createAttribute(timeDateAttr, date));
                    } else {
                        markupWriter.add(event);
                    }
                    ++markerId;
                    continue;
                }
                markupWriter.add(event);
            }
            markupWriter.flush();
            StaxUtils.closeQuietly((XMLEventWriter)markupWriter);
            string = writer.toString();
        }
        catch (Throwable throwable) {
            StaxUtils.closeQuietly(xmlEventReader);
            throw throwable;
        }
        StaxUtils.closeQuietly((XMLEventReader)xmlEventReader);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String updateTaskDate(String storageMarkup, int taskId, int elementId, String date) throws XMLStreamException {
        String string;
        XMLEventReader xmlEventReader = null;
        try {
            xmlEventReader = this.xmlEventReaderFactory.createStorageXmlEventReader((Reader)new StringReader(storageMarkup));
            StringWriter writer = new StringWriter();
            XMLEventWriter markupWriter = this.xmlOutputFactory.createXMLEventWriter((Writer)writer);
            int markerId = 0;
            boolean isTheTask = false;
            boolean isTaskBody = false;
            boolean completed = false;
            while (xmlEventReader.hasNext()) {
                XMLEvent event = xmlEventReader.nextEvent();
                if (!completed) {
                    if (isTaskBody) {
                        if (event.isStartElement() && timeTag.equals(event.asStartElement().getName())) {
                            if (markerId == elementId) {
                                markupWriter.add(this.xmlEventFactory.createStartElement(timeTag, null, null));
                                markupWriter.add(this.xmlEventFactory.createAttribute(timeDateAttr, date));
                                completed = true;
                                event = xmlEventReader.nextEvent();
                            }
                            ++markerId;
                        }
                        if (event.isEndElement() && StorageInlineTaskConstants.TASK_BODY_ELEMENT.equals(event.asEndElement().getName())) {
                            isTaskBody = false;
                            isTheTask = false;
                        }
                    } else if (isTheTask) {
                        if (event.isStartElement() && StorageInlineTaskConstants.TASK_BODY_ELEMENT.equals(event.asStartElement().getName())) {
                            isTaskBody = true;
                        }
                    } else if (event.isStartElement() && StorageInlineTaskConstants.TASK_ID_ELEMENT.equals(event.asStartElement().getName())) {
                        markupWriter.add(event);
                        event = xmlEventReader.nextEvent();
                        Integer thisTaskId = Integer.valueOf(event.asCharacters().getData().trim());
                        if (thisTaskId == taskId) {
                            isTheTask = true;
                        }
                    }
                }
                markupWriter.add(event);
            }
            markupWriter.flush();
            StaxUtils.closeQuietly((XMLEventWriter)markupWriter);
            string = writer.toString();
        }
        catch (Throwable throwable) {
            StaxUtils.closeQuietly(xmlEventReader);
            throw throwable;
        }
        StaxUtils.closeQuietly((XMLEventReader)xmlEventReader);
        return string;
    }

    public String createTask(Integer id, String summary) throws XMLStreamException {
        StringWriter writer = new StringWriter();
        XMLEventWriter markupWriter = this.xmlOutputFactory.createXMLEventWriter((Writer)writer);
        markupWriter.add(this.xmlEventFactory.createStartElement(StorageInlineTaskConstants.TASK_ELEMENT, null, null));
        markupWriter.add(this.xmlEventFactory.createStartElement(StorageInlineTaskConstants.TASK_ID_ELEMENT, null, null));
        markupWriter.add(this.xmlEventFactory.createCharacters(id.toString()));
        markupWriter.add(this.xmlEventFactory.createEndElement(StorageInlineTaskConstants.TASK_ID_ELEMENT, null));
        markupWriter.add(this.xmlEventFactory.createStartElement(StorageInlineTaskConstants.TASK_STATUS_ELEMENT, null, null));
        markupWriter.add(this.xmlEventFactory.createCharacters(StorageInlineTaskConstants.TASK_STATUS_INCOMPLETE));
        markupWriter.add(this.xmlEventFactory.createEndElement(StorageInlineTaskConstants.TASK_STATUS_ELEMENT, null));
        markupWriter.add(this.xmlEventFactory.createStartElement(StorageInlineTaskConstants.TASK_BODY_ELEMENT, null, null));
        markupWriter.add(this.xmlEventReaderFactory.createStorageXmlEventReader((Reader)new StringReader(summary)));
        markupWriter.add(this.xmlEventFactory.createEndElement(StorageInlineTaskConstants.TASK_BODY_ELEMENT, null));
        markupWriter.add(this.xmlEventFactory.createEndElement(StorageInlineTaskConstants.TASK_ELEMENT, null));
        markupWriter.flush();
        StaxUtils.closeQuietly((XMLEventWriter)markupWriter);
        return writer.toString();
    }

    private boolean isStartEventExcerptMacro(XMLEvent event) {
        return this.macros.contains(event.asStartElement().getName()) && "excerpt".equals(event.asStartElement().getAttributeByName(StorageMacroConstants.NAME_ATTRIBUTE).getValue());
    }

    private boolean isStartEventMultiExcerptMacro(XMLEvent event) {
        return this.macros.contains(event.asStartElement().getName()) && "multiexcerpt".equals(event.asStartElement().getAttributeByName(StorageMacroConstants.NAME_ATTRIBUTE).getValue());
    }

    private class MacroBodyHandler
    implements MacroDefinitionHandler {
        private String macroName;
        private String paramName;
        private String paramValue;
        private String body;
        private int count;

        public MacroBodyHandler(String macroName) {
            this.macroName = macroName;
            this.count = 0;
        }

        public MacroBodyHandler(String macroName, String paramName, String paramValue) {
            this(macroName);
            this.paramName = paramName;
            this.paramValue = paramValue;
        }

        public void handle(MacroDefinition macroDefinition) {
            if (this.macroName.equals(macroDefinition.getName()) && this.body == null) {
                if (this.paramName == null || this.paramValue.equals(macroDefinition.getParameter(this.paramName))) {
                    this.body = macroDefinition.getBodyText();
                }
                ++this.count;
            }
        }

        public String getBody() {
            return StringUtils.defaultString((String)this.body);
        }

        public int getCount() {
            return this.count;
        }
    }
}

