/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.storage.impl;

import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentBody;
import com.atlassian.confluence.api.model.content.ContentRepresentation;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.FormattedBody;
import com.atlassian.confluence.api.model.content.Version;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.Streamable;
import com.atlassian.confluence.content.render.xhtml.Streamables;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.content.render.xhtml.definition.MacroBody;
import com.atlassian.confluence.content.render.xhtml.definition.RichTextMacroBody;
import com.atlassian.confluence.content.render.xhtml.editor.EditorConverter;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.core.SaveContext;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.CommentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.util.diffs.MergeResult;
import com.atlassian.confluence.util.diffs.Merger;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.confluence.xhtml.api.MacroDefinitionHandler;
import com.atlassian.confluence.xhtml.api.MacroDefinitionReplacer;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.renderer.RenderContext;
import com.stiltsoft.confluence.handy.macros.storage.HandyWikiStyleRenderer;
import com.stiltsoft.confluence.handy.macros.storage.StorageService;
import com.stiltsoft.confluence.handy.macros.storage.transformer.HandyProcessor;
import com.stiltsoft.confluence.handy.macros.util.ServiceResult;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.xml.stream.XMLStreamException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class DefaultStorageService
implements StorageService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultStorageService.class);
    private static final String STATUS_MACRO_NAME = "status-handy";
    private static final String REMINDER_MACRO_NAME = "handy-reminder";
    private static final String STATUS_TIMESTAMP_MACRO_NAME = "handy-status-timestamp";
    private static final Pattern TASK_ID = Pattern.compile("<ac:task-id>(\\d+)</ac:task-id>");
    private final PageManager pageManager;
    private final HandyProcessor processor;
    private final XhtmlContent xhtmlContent;
    private final CommentManager commentManager;
    private final EditorConverter editConverter;
    private final PluginAccessor pluginAccessor;
    private final ContentEntityManager contentEntityManager;
    private final ContentService contentService;

    public DefaultStorageService(PageManager pageManager, HandyProcessor processor, XhtmlContent xhtmlContent, CommentManager commentManager, EditorConverter editConverter, PluginAccessor pluginAccessor, @Qualifier(value="contentEntityManager") ContentEntityManager contentEntityManager, ContentService contentService) {
        this.pageManager = pageManager;
        this.processor = processor;
        this.xhtmlContent = xhtmlContent;
        this.commentManager = commentManager;
        this.editConverter = editConverter;
        this.pluginAccessor = pluginAccessor;
        this.contentEntityManager = contentEntityManager;
        this.contentService = contentService;
    }

    @Override
    public boolean isStatusMacroPresentInContentStorage(@Nullable ContentEntityObject ceo, int statusMacroId) {
        String rawStatusMacroId = String.valueOf(statusMacroId);
        return this.isMacroWithIdPresentInContentStorage(STATUS_MACRO_NAME, rawStatusMacroId, ceo);
    }

    @Override
    public boolean isStatusMacroPresentInContentStorage(@Nullable Content content, int statusMacroId) {
        String rawStatusMacroId = String.valueOf(statusMacroId);
        return this.isMacroWithIdPresentInContentStorage(STATUS_MACRO_NAME, rawStatusMacroId, content);
    }

    @Override
    public boolean isReminderMacroPresentInContentStorage(@Nullable ContentEntityObject ceo, int reminderMacroId) {
        String rawReminderMacroId = String.valueOf(reminderMacroId);
        return this.isMacroWithIdPresentInContentStorage(REMINDER_MACRO_NAME, rawReminderMacroId, ceo);
    }

    @Override
    public void handleStatusMacroDefinitions(@Nullable ContentEntityObject ceo, MacroDefinitionHandler handler) {
        this.handleMacroDefinition(STATUS_MACRO_NAME, ceo, handler);
    }

    @Override
    public void handleReminderMacroDefinition(@Nullable ContentEntityObject ceo, MacroDefinitionHandler handler) {
        this.handleMacroDefinition(REMINDER_MACRO_NAME, ceo, handler);
    }

    @Override
    public void updateReminderId(Long pageId, String id, String newId) {
        this.updateId(pageId, REMINDER_MACRO_NAME, id, newId);
    }

    @Override
    public void replaceStatusMacroIdInContentStorage(long contentId, int currentMacroId, int newMacroId) {
        String rawCurrentMacroId = Integer.toString(currentMacroId);
        String rawNewMacroId = Integer.toString(newMacroId);
        this.updateId(contentId, STATUS_MACRO_NAME, rawCurrentMacroId, rawNewMacroId);
        this.updateStatusMacroIdForStatusTimestamp(contentId, rawCurrentMacroId, rawNewMacroId);
    }

    @Override
    public int updateStatusName(Long pageId, int macroId, String statusName) {
        return this.updateStatusName(pageId, macroId, statusName, false);
    }

    @Override
    public int updateStatusName(Long pageId, int macroId, String statusName, boolean suppressEvents) {
        String rawMacroId = Integer.toString(macroId);
        return this.updateParam(pageId, STATUS_MACRO_NAME, "id", rawMacroId, "Status", statusName, false, true, suppressEvents);
    }

    @Override
    public void updatePPRBody(Content content, int elementId, String date, String colName) {
        String originStorage = ((ContentBody)content.getBody().get(ContentRepresentation.STORAGE)).getValue();
        try {
            DefaultConversionContext context = new DefaultConversionContext(HandyWikiStyleRenderer.getDefaultRenderContext());
            String updatedStorage = this.xhtmlContent.replaceMacroDefinitionsWithString(originStorage, (ConversionContext)context, arg_0 -> this.lambda$updatePPRBody$0(elementId, date, colName, (ConversionContext)context, arg_0));
            this.saveNewContentVersion(content, updatedStorage, false);
        }
        catch (XhtmlException e) {
            log.error("Can not update storage markup (PPR)", (Throwable)e);
        }
    }

    @Override
    public String getExcerptMacroBodyStorage(ContentEntityObject ceo) {
        DefaultConversionContext context = new DefaultConversionContext((RenderContext)ceo.toPageContext());
        try {
            AtomicReference atomicMacroDefinition = new AtomicReference();
            this.xhtmlContent.handleMacroDefinitions(ceo.getBodyAsString(), (ConversionContext)context, macroDefinition -> {
                if ("excerpt".equals(macroDefinition.getName())) {
                    atomicMacroDefinition.set(macroDefinition);
                }
            });
            if (atomicMacroDefinition.get() == null) {
                return null;
            }
            return Streamables.writeToString((Streamable)((MacroDefinition)atomicMacroDefinition.get()).getBody().getStorageBodyStream());
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public int getNextTaskId(int lastTaskId, Content content) {
        int nextId = lastTaskId + 1;
        String pageBody = ((ContentBody)content.getBody().get(ContentRepresentation.STORAGE)).getValue();
        Matcher matcher = TASK_ID.matcher(pageBody);
        while (matcher.find()) {
            int thisId = Integer.parseInt(matcher.group(1)) + 1;
            if (thisId <= nextId) continue;
            nextId = thisId;
        }
        return nextId;
    }

    @Override
    public String createNewTaskInContentStorage(int lastTaskId, int nextTaskId, Content content, String taskSummary) throws XMLStreamException, XhtmlException {
        String pageBody = ((ContentBody)content.getBody().get(ContentRepresentation.STORAGE)).getValue();
        int index = pageBody.indexOf("<ac:task-id>" + lastTaskId + "</ac:task-id>");
        index = pageBody.indexOf("</ac:task>", index) + 10;
        DefaultConversionContext context = new DefaultConversionContext(HandyWikiStyleRenderer.getDefaultRenderContext());
        String storageSummary = this.editConverter.convert(taskSummary, (ConversionContext)context);
        String taskStorage = this.processor.createTask(nextTaskId, storageSummary);
        String newBody = pageBody.substring(0, index) + taskStorage + pageBody.substring(index);
        this.saveNewContentVersion(content, newBody, false);
        return this.xhtmlContent.convertStorageToView(storageSummary, (ConversionContext)context);
    }

    @Override
    public ServiceResult<Boolean> updateDate(Content latestContent, Content actualContent, int elementId, String date) throws XMLStreamException {
        String actualContentStorage = ((ContentBody)actualContent.getBody().get(ContentRepresentation.STORAGE)).getValue();
        String latestContentStorage = ((ContentBody)latestContent.getBody().get(ContentRepresentation.STORAGE)).getValue();
        Map.Entry<String, Boolean> result = this.processor.updateDate(actualContentStorage, elementId, date);
        String storage = result.getKey();
        if (Boolean.FALSE.equals(result.getValue())) {
            result = this.processor.updateDate(latestContentStorage, elementId, date);
            if (Boolean.FALSE.equals(result.getValue())) {
                return ServiceResult.ERROR("not-inserted");
            }
            storage = result.getKey();
        } else if (latestContent.getVersion() != actualContent.getVersion()) {
            List mergers = this.pluginAccessor.getEnabledModulesByClass(Merger.class);
            if (mergers.isEmpty()) {
                return ServiceResult.ERROR("");
            }
            MergeResult mergeResult = ((Merger)mergers.get(0)).mergeContent(actualContentStorage, latestContentStorage, storage);
            if (mergeResult.hasConflicts()) {
                result = this.processor.updateDate(latestContentStorage, elementId, date);
                if (Boolean.FALSE.equals(result.getValue())) {
                    return ServiceResult.ERROR("merge");
                }
                storage = result.getKey();
            } else {
                storage = mergeResult.getMergedContent();
            }
        }
        this.saveNewContentVersion(latestContent, storage, true);
        return ServiceResult.SUCCESS(true);
    }

    @Override
    public void updateTaskDate(Content content, int taskId, int elementId, String date) throws XMLStreamException {
        String originStorage = ((ContentBody)content.getBody().get(ContentRepresentation.STORAGE)).getValue();
        String updatedStorage = this.processor.updateTaskDate(originStorage, taskId, elementId, date);
        this.saveNewContentVersion(content, updatedStorage, false);
    }

    private int updateParam(Long pageId, String macroName, String searchParamName, String searchParamValue, String paramName, String newParamValue, boolean suppressNotifications, boolean updateLastModifier, boolean suppressEvents) {
        ContentEntityObject ceo = this.contentEntityManager.getById(pageId.longValue());
        if (ceo instanceof AbstractPage) {
            AbstractPage page = (AbstractPage)ceo;
            this.pageManager.saveNewVersion((ContentEntityObject)page, content -> {
                try {
                    DefaultConversionContext context = new DefaultConversionContext((RenderContext)content.toPageContext());
                    content.setBodyAsString(this.xhtmlContent.replaceMacroDefinitionsWithString(content.getBodyAsString(), (ConversionContext)context, (MacroDefinitionReplacer)new MacroReplacer((ConversionContext)context, macroName, searchParamName, searchParamValue, paramName, newParamValue)));
                }
                catch (XhtmlException e) {
                    e.printStackTrace();
                }
            }, (SaveContext)((DefaultSaveContext.Builder)((DefaultSaveContext.Builder)DefaultSaveContext.builder().suppressNotifications(suppressNotifications)).updateLastModifier(updateLastModifier).suppressEvents(suppressEvents)).build());
            return page.getVersion();
        }
        if (ceo instanceof Comment) {
            Comment comment = (Comment)ceo;
            this.commentManager.saveNewVersion((ContentEntityObject)comment, content -> {
                try {
                    DefaultConversionContext context = new DefaultConversionContext((RenderContext)content.toPageContext());
                    content.setBodyAsString(this.xhtmlContent.replaceMacroDefinitionsWithString(content.getBodyAsString(), (ConversionContext)context, (MacroDefinitionReplacer)new MacroReplacer((ConversionContext)context, macroName, searchParamName, searchParamValue, paramName, newParamValue)));
                }
                catch (XhtmlException e) {
                    e.printStackTrace();
                }
            }, (SaveContext)((DefaultSaveContext.Builder)((DefaultSaveContext.Builder)DefaultSaveContext.builder().suppressNotifications(suppressNotifications)).updateLastModifier(updateLastModifier).suppressEvents(suppressEvents)).build());
            return ceo.getVersion();
        }
        return 0;
    }

    private void saveNewContentVersion(Content content, String storage, boolean suppressNotifications) {
        ContentBody newContentBody = ((ContentBody.ContentBodyBuilder)((ContentBody.ContentBodyBuilder)ContentBody.contentBodyBuilder().content(content).representation(ContentRepresentation.STORAGE)).value(storage)).build();
        List<Content> newContentAncestors = DefaultStorageService.getOnlyLastParentAsAncestorsIfExist(content);
        Content newContent = Content.builder((ContentType)content.getType(), (ContentId)content.getId()).title(content.getTitle()).space(content.getSpace()).status(content.getStatus()).body(newContentBody).ancestors(newContentAncestors).version(Version.builder().minorEdit(suppressNotifications).number(content.getVersion().getNumber() + 1).message("").build()).build();
        this.contentService.update(newContent);
    }

    private static List<Content> getOnlyLastParentAsAncestorsIfExist(Content content) {
        List contentAncestors = content.getAncestors();
        if (!contentAncestors.isEmpty()) {
            Content father = (Content)contentAncestors.get(contentAncestors.size() - 1);
            return Collections.singletonList(father);
        }
        return Collections.emptyList();
    }

    private boolean isMacroWithIdPresentInContentStorage(String macroName, String parameterIdValue, Content content) {
        return Optional.ofNullable(content).map(Content::getBody).map(bodyByRepresentation -> (ContentBody)bodyByRepresentation.get(ContentRepresentation.STORAGE)).map(FormattedBody::getValue).map(contentStorage -> {
            LinkedList macroDefinitions = new LinkedList();
            this.handleMacroDefinitionsFromStorage(macroName, (String)contentStorage, content.getId().asLong(), macroDefinitions::add);
            return macroDefinitions.stream().anyMatch(macroDefinition -> parameterIdValue.equals(macroDefinition.getParameters().get("id")));
        }).orElse(Boolean.FALSE);
    }

    private boolean isMacroWithIdPresentInContentStorage(String macroName, String parameterIdValue, @Nullable ContentEntityObject ceo) {
        return Optional.ofNullable(ceo).map(ContentEntityObject::getBodyAsString).map(contentStorage -> {
            LinkedList macroDefinitions = new LinkedList();
            this.handleMacroDefinitionsFromStorage(macroName, (String)contentStorage, ceo.getId(), macroDefinitions::add);
            return macroDefinitions.stream().anyMatch(macroDefinition -> parameterIdValue.equals(macroDefinition.getParameters().get("id")));
        }).orElse(Boolean.FALSE);
    }

    private void handleMacroDefinitionsFromStorage(String macroName, String contentStorage, long contentEntityId, MacroDefinitionHandler handler) {
        DefaultConversionContext conversionContext = new DefaultConversionContext(new RenderContext());
        try {
            this.xhtmlContent.handleMacroDefinitions(contentStorage, (ConversionContext)conversionContext, macroDefinition -> {
                if (macroDefinition.isValid() && macroName.equals(macroDefinition.getName())) {
                    handler.handle(macroDefinition);
                }
            });
        }
        catch (Exception e) {
            log.error("Failed to extract macro {} from content id = {}", new Object[]{macroName, contentEntityId, e});
        }
    }

    private void updateStatusMacroIdForStatusTimestamp(Long pageId, String oldStatusMacroId, String newStatusMacroId) {
        this.updateParam(pageId, STATUS_TIMESTAMP_MACRO_NAME, "statusMacroId", oldStatusMacroId, "statusMacroId", newStatusMacroId, true, false, true);
    }

    private void updateId(Long pageId, String macroName, String id, String newId) {
        this.updateParam(pageId, macroName, "id", id, "id", newId, true, false, true);
    }

    private void handleMacroDefinition(String macroName, @Nullable ContentEntityObject ceo, MacroDefinitionHandler handler) {
        Optional.ofNullable(ceo).map(ContentEntityObject::getBodyAsString).filter(storage -> storage.contains(macroName)).ifPresent(storage -> this.handleMacroDefinitionsFromStorage(macroName, (String)storage, ceo.getId(), handler));
    }

    private /* synthetic */ String lambda$updatePPRBody$0(int elementId, String date, String colName, ConversionContext context, MacroDefinition macroDefinition) throws XhtmlException {
        if ("details".equals(macroDefinition.getName())) {
            String storage = Streamables.writeToString((Streamable)macroDefinition.getBody().getStorageBodyStream());
            try {
                String body = this.processor.updatePPRDate(storage, elementId, date, colName);
                macroDefinition.setBody((MacroBody)RichTextMacroBody.withStorage((Streamable)Streamables.from((String)body)));
            }
            catch (XMLStreamException e) {
                log.error("Failed to process PPR", (Throwable)e);
            }
        }
        return this.xhtmlContent.convertMacroDefinitionToStorage(macroDefinition, context);
    }

    private class MacroReplacer
    implements MacroDefinitionReplacer {
        ConversionContext context;
        String macroName;
        String searchParamName;
        String searchParamValue;
        String newParam;
        boolean isNew;
        String paramName;
        boolean found;

        public MacroReplacer(ConversionContext context, String macroName, String searchParamName, String searchParamValue, String paramName, String newParamValue) {
            this.context = context;
            this.macroName = macroName;
            this.searchParamName = searchParamName;
            this.searchParamValue = searchParamValue;
            this.newParam = newParamValue;
            this.paramName = paramName;
            this.isNew = false;
            for (Method method : MacroDefinition.class.getDeclaredMethods()) {
                if (!"setTypedParameter".equals(method.getName())) continue;
                this.isNew = true;
                break;
            }
            this.found = false;
        }

        public String replace(MacroDefinition macroDefinition) throws XhtmlException {
            if (!this.found && this.macroName.equals(macroDefinition.getName()) && this.searchParamValue.equals(macroDefinition.getParameters().get(this.searchParamName))) {
                if (this.isNew) {
                    macroDefinition.setParameter(this.paramName, this.newParam);
                    macroDefinition.setTypedParameter(this.paramName, (Object)this.newParam);
                } else {
                    Map params = macroDefinition.getParameters();
                    params.put(this.paramName, this.newParam);
                    macroDefinition.setParameters(params);
                }
                this.found = true;
            }
            return DefaultStorageService.this.xhtmlContent.convertMacroDefinitionToStorage(macroDefinition, this.context);
        }
    }
}

